/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.compat;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.champeau.gradle.japicmp.report.PostProcessViolationsRule;
import me.champeau.gradle.japicmp.report.Severity;
import me.champeau.gradle.japicmp.report.ViolationCheckContextWithViolations;

public class InternalAnnotationPostProcessRule
implements PostProcessViolationsRule {
    public void execute(ViolationCheckContextWithViolations context) {
        Set internalTypes = (Set)context.getUserData("micronaut.internal.types");
        if (internalTypes != null) {
            Set toBeSuppressed = context.getViolations().keySet().stream().filter(internalTypes::contains).collect(Collectors.toSet());
            Set entries = context.getViolations().entrySet();
            for (Map.Entry entry : entries) {
                if (!toBeSuppressed.contains(entry.getKey())) continue;
                List replacement = ((List)entry.getValue()).stream().map(v -> {
                    if (v.getSeverity() == Severity.error) {
                        return v.withSeverity(Severity.warning);
                    }
                    return v;
                }).collect(Collectors.toList());
                ((List)entry.getValue()).clear();
                ((List)entry.getValue()).addAll(replacement);
            }
        }
    }
}

