/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.compat;

import io.micronaut.build.utils.ComparableVersion;
import io.micronaut.build.utils.VersionParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class MavenMetadataVersionHelper {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+\\.\\d+\\.\\d+)([.-]\\w+)?$");
    private static final String VERSION_OPEN_TAG = "<version>";
    private static final String VERSION_CLOSE_TAG = "</version>";

    private MavenMetadataVersionHelper() {
    }

    public static List<ComparableVersion> findReleasesFrom(byte[] mavenMetadata) {
        List<ComparableVersion> list;
        ArrayList<String> allVersions = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(new String(mavenMetadata, StandardCharsets.UTF_8)));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(VERSION_OPEN_TAG)) continue;
                String version = line.substring(line.indexOf(VERSION_OPEN_TAG) + VERSION_OPEN_TAG.length(), line.indexOf(VERSION_CLOSE_TAG));
                allVersions.add(version);
            }
            list = allVersions.stream().map(VersionParser::parse).sorted().collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return List.of();
            }
        }
        reader.close();
        return list;
    }

    public static Optional<ComparableVersion> findPreviousReleaseFor(ComparableVersion version, List<ComparableVersion> releases) {
        return releases.stream().filter(v -> v.qualifier().isEmpty()).filter(v -> v.compareTo(version) < 0).reduce((a, b) -> b);
    }
}

