/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.compat;

import io.micronaut.build.catalogs.internal.LenientVersionCatalogParser;
import io.micronaut.build.catalogs.internal.Library;
import io.micronaut.build.catalogs.internal.VersionCatalogTomlModel;
import io.micronaut.build.catalogs.internal.VersionModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class VersionCatalogCompatibilityCheck
extends DefaultTask {
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getBaseline();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getCurrent();

    @Input
    public abstract SetProperty<String> getAcceptedVersionRegressions();

    @Input
    public abstract SetProperty<String> getAcceptedLibraryRegressions();

    @OutputFile
    public abstract RegularFileProperty getReportFile();

    @TaskAction
    public void checkCompatibility() throws IOException {
        VersionCatalogTomlModel baselineModel = this.parse(this.getBaseline());
        VersionCatalogTomlModel currentModel = this.parse(this.getCurrent());
        Set<String> removedVersions = VersionCatalogCompatibilityCheck.diff(VersionCatalogCompatibilityCheck.collectVersionsFrom(baselineModel), VersionCatalogCompatibilityCheck.collectVersionsFrom(currentModel), (Set)this.getAcceptedVersionRegressions().get());
        Set<String> removedLibs = VersionCatalogCompatibilityCheck.diff(VersionCatalogCompatibilityCheck.collectLibrariesFrom(baselineModel), VersionCatalogCompatibilityCheck.collectLibrariesFrom(currentModel), (Set)this.getAcceptedLibraryRegressions().get());
        ArrayList<String> report = new ArrayList<String>();
        boolean fail = false;
        if (!removedVersions.isEmpty()) {
            fail = true;
            report.add("The following versions were present in the baseline version but missing from this catalog:");
            removedVersions.forEach(version -> report.add("  - " + version));
        }
        if (!removedLibs.isEmpty()) {
            fail = true;
            report.add("The following libraries were present in the baseline version but missing from this catalog:");
            removedLibs.forEach(version -> report.add("  - " + version));
        }
        Files.write(((File)this.getReportFile().getAsFile().get()).toPath(), report, StandardCharsets.UTF_8, new OpenOption[0]);
        if (fail) {
            throw new RuntimeException("Version catalogs are not compatible:\n" + String.join((CharSequence)"\n", report));
        }
    }

    private static Set<String> collectVersionsFrom(VersionCatalogTomlModel model) {
        return model.getVersionsTable().stream().map(VersionModel::getReference).collect(Collectors.toSet());
    }

    private static Set<String> collectLibrariesFrom(VersionCatalogTomlModel model) {
        return model.getLibrariesTable().stream().map(Library::getAlias).collect(Collectors.toSet());
    }

    private VersionCatalogTomlModel parse(RegularFileProperty file) {
        LenientVersionCatalogParser parser = new LenientVersionCatalogParser();
        try (InputStream in = Files.newInputStream(((File)file.getAsFile().get()).toPath(), new OpenOption[0]);){
            parser.parse(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return parser.getModel();
    }

    private static Set<String> diff(Set<String> baseline, Set<String> current, Set<String> acceptedRegressions) {
        HashSet<String> removedVersions = new HashSet<String>(baseline);
        removedVersions.removeAll(current);
        removedVersions.removeAll(acceptedRegressions);
        return removedVersions;
    }
}

