/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.docs;

import io.micronaut.docs.GitHubTagsParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CacheableTask
public abstract class CreateReleasesDropdownTask
extends DefaultTask {
    private static final int CACHE_IN_SECONDS = 3600;
    private static final Logger LOG = LoggerFactory.getLogger(CreateReleasesDropdownTask.class);
    private static final String MICRONAUT_GITHUB_ORGANIZATION = "micronaut-projects";
    private static final String MICRONAUT_CORE_REPOSITORY = "micronaut-core";
    public static final String PROJECTS_MICRONAUT_CORE = "micronaut-projects/micronaut-core";

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getSourceIndex();

    @Input
    public abstract Property<String> getSlug();

    @Input
    public abstract Property<String> getVersion();

    @OutputFile
    public abstract RegularFileProperty getOutputIndex();

    @Input
    protected Provider<Long> getTimestamp() {
        return this.getProviders().provider(() -> {
            long seconds = System.currentTimeMillis() / 1000L;
            long base = seconds / 3600L;
            return base * 3600L;
        });
    }

    @Internal
    public abstract Property<String> getVersionsJson();

    @Inject
    protected abstract ProviderFactory getProviders();

    @TaskAction
    public void createDropdown() throws IOException {
        String slug = (String)this.getSlug().get();
        String version = (String)this.getVersion().get();
        String json = (String)this.getVersionsJson().getOrNull();
        String selectHtml = json != null ? CreateReleasesDropdownTask.composeSelectHtml(json, slug, version) : version;
        String versionHtml = "<p><strong>Version:</strong> " + version + "</p>";
        String substitute = selectHtml.replaceAll(" style='margin-top: 10px' ", " style='max-width: 200px' ");
        String versionWithSelectHtml = "<p><strong>Version:</strong> " + substitute + " </p>";
        String original = (String)this.getProviders().fileContents((Provider)this.getSourceIndex()).getAsText().get();
        File targetFile = ((RegularFile)this.getOutputIndex().get()).getAsFile();
        if (targetFile.getParentFile().isDirectory() || targetFile.getParentFile().mkdirs()) {
            try (FileOutputStream out = new FileOutputStream(targetFile);){
                ((OutputStream)out).write(original.replace(versionHtml, versionWithSelectHtml).getBytes("utf-8"));
            }
        } else {
            throw new GradleException("Cannot create " + targetFile);
        }
    }

    public static String composeSelectHtml(String json, String slug, String version) {
        String[] splitted = slug.split("/");
        String org = splitted[0];
        String repo = splitted[1];
        StringBuilder selectHtml = new StringBuilder("<select style='margin-top: 10px' onChange='window.document.location.href=this.options[this.selectedIndex].value;'>");
        String snapshotHref = CreateReleasesDropdownTask.snapshotRefUrl(org, repo);
        selectHtml.append(CreateReleasesDropdownTask.option(snapshotHref, "SNAPSHOT", version.endsWith("SNAPSHOT")));
        String latestHref = CreateReleasesDropdownTask.latestRefUrl(org, repo);
        selectHtml.append(CreateReleasesDropdownTask.option(latestHref, "LATEST", false));
        GitHubTagsParser.toVersions(json).forEach(softwareVersion -> {
            String versionName = softwareVersion.getVersionText();
            String href = "https://" + org + ".github.io/" + repo + "/" + versionName + "/guide/index.html";
            if (PROJECTS_MICRONAUT_CORE.equals(slug)) {
                href = "https://docs.micronaut.io/" + versionName + "/guide/index.html";
            }
            selectHtml.append(CreateReleasesDropdownTask.option(href, versionName, version.equals(versionName)));
        });
        selectHtml.append("</select>");
        return selectHtml.toString();
    }

    private static String option(String href, String text, boolean selected) {
        StringBuilder sb = new StringBuilder();
        if (selected) {
            sb.append("<option selected='selected' value='").append(href).append("'>").append(text).append("</option>");
        } else {
            sb.append("<option value='").append(href).append("'>").append(text).append("</option>");
        }
        return sb.toString();
    }

    static String snapshotRefUrl(String org, String repo) {
        if (MICRONAUT_GITHUB_ORGANIZATION.equals(org) && MICRONAUT_CORE_REPOSITORY.equals(repo)) {
            return "https://docs.micronaut.io/snapshot/guide/index.html";
        }
        return String.format("https://%s.github.io/%s/snapshot/guide/index.html", org, repo);
    }

    static String latestRefUrl(String org, String repo) {
        if (MICRONAUT_GITHUB_ORGANIZATION.equals(org) && MICRONAUT_CORE_REPOSITORY.equals(repo)) {
            return "https://docs.micronaut.io/latest/guide/index.html";
        }
        return String.format("https://%s.github.io/%s/latest/guide/index.html", org, repo);
    }
}

