/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.docs;

import io.micronaut.docs.DocPublisher;
import io.micronaut.docs.macros.HiddenMacro;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class PublishGuideTask
extends DefaultTask {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getSourceDir();

    @OutputDirectory
    public abstract DirectoryProperty getTargetDir();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public abstract DirectoryProperty getResourcesDir();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public abstract ConfigurableFileCollection getPropertiesFiles();

    @Input
    @Optional
    public abstract Property<String> getLanguage();

    @Input
    public abstract Property<Boolean> getAsciidoc();

    @Input
    @Optional
    public abstract Property<String> getSourceRepo();

    @Input
    public abstract MapProperty<String, Object> getProperties();

    @Inject
    protected abstract FileOperations getFileOperations();

    @Inject
    public PublishGuideTask() {
        ProjectLayout layout = this.getProject().getLayout();
        Directory projectDirectory = layout.getProjectDirectory();
        DirectoryProperty buildDirectory = layout.getBuildDirectory();
        this.getSourceDir().convention(projectDirectory.dir("src"));
        this.getTargetDir().convention(buildDirectory.dir("docs"));
        this.getResourcesDir().convention(projectDirectory.dir("resources"));
        this.getAsciidoc().convention((Object)false);
    }

    private static void loadProperties(Properties into, File src) throws IOException {
        try (FileInputStream fis = new FileInputStream(src);){
            into.load(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void generate() throws IOException {
        Properties props = new Properties();
        File docProperties = ((RegularFile)this.getResourcesDir().file("doc.properties").get()).getAsFile();
        if (docProperties.exists()) {
            PublishGuideTask.loadProperties(props, docProperties);
        }
        for (File f : this.getPropertiesFiles().getFiles()) {
            PublishGuideTask.loadProperties(props, f);
        }
        props.putAll((Map<?, ?>)((Map)this.getProperties().get()));
        File sourceDir = (File)this.getSourceDir().getAsFile().get();
        File targetDir = (File)this.getTargetDir().getAsFile().get();
        DocPublisher publisher = new DocPublisher(sourceDir, targetDir);
        publisher.setFileOperations(this.getFileOperations());
        publisher.setAsciidoc((Boolean)this.getAsciidoc().get());
        publisher.setDocResources((File)this.getResourcesDir().getAsFile().get());
        publisher.setApiDir(targetDir);
        publisher.setLanguage((String)this.getLanguage().getOrElse((Object)""));
        publisher.setSourceRepo((String)this.getSourceRepo().getOrNull());
        publisher.setImages(((Directory)this.getResourcesDir().dir("img").get()).getAsFile());
        publisher.setCss(((Directory)this.getResourcesDir().dir("css").get()).getAsFile());
        publisher.setFonts(((Directory)this.getResourcesDir().dir("fonts").get()).getAsFile());
        publisher.setJs(((Directory)this.getResourcesDir().dir("js").get()).getAsFile());
        publisher.setStyle(((Directory)this.getResourcesDir().dir("style").get()).getAsFile());
        publisher.setVersion(String.valueOf(props.get("grails.version")));
        if (this.getLanguage().isPresent()) {
            String language = (String)this.getLanguage().get();
            int pos = language.length() + 1;
            props.entrySet().stream().filter(e -> String.valueOf(e.getKey()).startsWith(language + ".")).forEach(e -> {
                String key = String.valueOf(e.getKey()).substring(pos);
                props.put(key, e.getValue());
            });
        }
        publisher.setEngineProperties(props);
        publisher.registerMacro((Object)new HiddenMacro());
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(publisher.getClass().getClassLoader());
            publisher.publish();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

