/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.docs.props;

import io.micronaut.build.docs.props.AtValue;
import io.micronaut.build.docs.props.JavaDocAtValueReplacement;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class JavaDocAtValueReplacementTask
extends DefaultTask {
    private static final Pattern JAVA_CLASSNAME_PATTERN = Pattern.compile("(\\p{javaJavaIdentifierPart}+).*");

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getSourceFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    public abstract ConfigurableFileCollection getInputFiles();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @TaskAction
    public void execute() throws IOException {
        File outputFile = (File)this.getOutputFile().getAsFile().get();
        if (outputFile.getParentFile().isDirectory() || outputFile.getParentFile().mkdirs()) {
            for (File adocFile : this.getInputFiles().getFiles()) {
                if (!adocFile.exists()) continue;
                String configurationPropertiesClassName = null;
                List<String> lines = Files.readAllLines(adocFile.toPath(), StandardCharsets.UTF_8);
                try (PrintWriter prn = new PrintWriter(outputFile, StandardCharsets.UTF_8.name());){
                    for (int i = 0; i < lines.size(); ++i) {
                        String line = lines.get(i);
                        if ("++++".equals(line) && lines.get(i + 1).startsWith("<a id=\"")) {
                            String subline = lines.get(i + 1).substring("<a id=\"".length());
                            configurationPropertiesClassName = subline.substring(0, subline.indexOf("\""));
                        }
                        Object processedLine = line;
                        for (int attempts = 5; ((String)processedLine).contains("{@value") && attempts > 0; --attempts) {
                            AtValue atValueReplacement = JavaDocAtValueReplacement.atValueField(configurationPropertiesClassName, (String)processedLine);
                            if (atValueReplacement == null || atValueReplacement.getType() == null || atValueReplacement.getFieldName() == null) continue;
                            try {
                                String resolvedValue = this.calculateResolvedValue(atValueReplacement.getType(), atValueReplacement.getFieldName());
                                if (resolvedValue != null) {
                                    Object result = ((String)processedLine).substring(0, ((String)processedLine).indexOf("{@value "));
                                    result = (String)result + resolvedValue;
                                    String sub = ((String)processedLine).substring(((String)processedLine).indexOf("{@value ") + "{@value ".length());
                                    sub = sub.substring(sub.indexOf(125) + "}".length());
                                    processedLine = result = (String)result + sub;
                                    continue;
                                }
                                this.getLogger().error("no resolved value for type: {} fieldname: {}", (Object)atValueReplacement.getType(), (Object)atValueReplacement.getFieldName());
                                continue;
                            }
                            catch (StringIndexOutOfBoundsException e) {
                                this.getLogger().error("StringIndexOutOfBoundsException - no resolved value for type: {} fieldname: {}", (Object)atValueReplacement.getType(), (Object)atValueReplacement.getFieldName());
                            }
                        }
                        prn.print((String)processedLine + "\n");
                    }
                }
            }
        }
    }

    Set<File> calculateClassFiles(List<String> targetClassNames) {
        return this.getSourceFiles().getFiles().stream().filter(File::isFile).filter(file -> file.getName().endsWith(".java")).filter(file -> targetClassNames.stream().anyMatch(targetClassName -> file.getName().equals(targetClassName + ".java"))).collect(Collectors.toSet());
    }

    private static List<String> calculateTargetClassNames(String className) {
        return Arrays.stream(className.split("[.]")).filter(s -> Character.isUpperCase(s.charAt(0))).flatMap(s -> Arrays.stream(s.split("[$]"))).collect(Collectors.toList());
    }

    String calculateResolvedValue(String className, String fieldName) throws IOException {
        List<String> targetClassNames = JavaDocAtValueReplacementTask.calculateTargetClassNames(className);
        Set<File> classFiles = this.calculateClassFiles(targetClassNames);
        if (!classFiles.isEmpty()) {
            File f = classFiles.iterator().next();
            List<String> lines = Files.readAllLines(f.toPath(), StandardCharsets.UTF_8);
            Collections.reverse(targetClassNames);
            for (String targetClassName : targetClassNames) {
                String classEvaluated = null;
                String interfaceEvaluated = null;
                for (String line : lines) {
                    Matcher matcher;
                    String subLine;
                    if (line.contains("class ")) {
                        subLine = line.substring(line.indexOf("class ") + "class ".length());
                        matcher = JAVA_CLASSNAME_PATTERN.matcher(subLine);
                        classEvaluated = matcher.find() ? matcher.group(1) : subLine;
                    }
                    if (line.contains("interface ")) {
                        subLine = line.substring(line.indexOf("interface ") + "interface ".length());
                        matcher = JAVA_CLASSNAME_PATTERN.matcher(subLine);
                        interfaceEvaluated = matcher.find() ? matcher.group(1) : subLine;
                    }
                    if ((classEvaluated == null || !classEvaluated.equals(targetClassName)) && (interfaceEvaluated == null || !interfaceEvaluated.equals(targetClassName)) || !line.contains(" " + fieldName + " = ") || !line.contains(";")) continue;
                    return line.substring(line.indexOf(fieldName + " = ") + (fieldName + " = ").length(), line.indexOf(59));
                }
            }
        }
        return null;
    }
}

