/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.pom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.provider.Property;

public class InterceptedVersionCatalogBuilder
implements VersionCatalogBuilder {
    private final VersionCatalogBuilder delegate;
    private final Map<String, String> versions = new HashMap<String, String>();
    private final List<Consumer<? super LibraryDefinition>> onLibrary = new ArrayList<Consumer<? super LibraryDefinition>>();

    public InterceptedVersionCatalogBuilder(VersionCatalogBuilder delegate) {
        this.delegate = delegate;
    }

    public void onLibrary(Consumer<? super LibraryDefinition> consumer) {
        this.onLibrary.add(consumer);
    }

    public Property<String> getDescription() {
        return this.delegate.getDescription();
    }

    public void from(Object dependencyNotation) {
        this.delegate.from(dependencyNotation);
    }

    public String version(String alias, Action<? super MutableVersionConstraint> versionSpec) {
        return this.delegate.version(alias, versionSpec);
    }

    public String version(String alias, String version) {
        this.versions.put(alias, version);
        return this.delegate.version(alias, version);
    }

    public VersionCatalogBuilder.LibraryAliasBuilder library(String alias, final String group, final String artifact) {
        final VersionCatalogBuilder.LibraryAliasBuilder library = this.delegate.library(alias, group, artifact);
        return new VersionCatalogBuilder.LibraryAliasBuilder(){

            public void version(Action<? super MutableVersionConstraint> versionSpec) {
                library.version(versionSpec);
            }

            public void version(String version) {
                library.version(version);
            }

            public void versionRef(String versionRef) {
                library.versionRef(versionRef);
                InterceptedVersionCatalogBuilder.this.onLibrary.forEach(listener -> listener.accept(new LibraryDefinition(group, artifact, versionRef)));
            }

            public void withoutVersion() {
                library.withoutVersion();
                InterceptedVersionCatalogBuilder.this.onLibrary.forEach(listener -> listener.accept(new LibraryDefinition(group, artifact, null)));
            }
        };
    }

    public void library(String alias, String groupArtifactVersion) {
        this.delegate.library(alias, groupArtifactVersion);
    }

    public VersionCatalogBuilder.PluginAliasBuilder plugin(String alias, String id) {
        return this.delegate.plugin(alias, id);
    }

    public void bundle(String alias, List<String> aliases) {
        this.delegate.bundle(alias, aliases);
    }

    public String getLibrariesExtensionName() {
        return this.delegate.getLibrariesExtensionName();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public final class LibraryDefinition {
        private final String groupId;
        private final String artifactId;
        private final String versionRef;

        public LibraryDefinition(String groupId, String artifactId, String versionRef) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.versionRef = versionRef;
        }

        public String version() {
            if (this.versionRef == null) {
                return null;
            }
            return InterceptedVersionCatalogBuilder.this.versions.get(this.versionRef);
        }

        public String groupId() {
            return this.groupId;
        }

        public String artifactId() {
            return this.artifactId;
        }

        public String versionRef() {
            return this.versionRef;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            LibraryDefinition that = (LibraryDefinition)obj;
            return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.versionRef, that.versionRef);
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId, this.versionRef);
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId + ":" + this.version();
        }
    }
}

