/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public final class ComparableVersion
implements Comparable<ComparableVersion> {
    private static final List<String> PARTIAL_QUALIFIER_ORDER = List.of("snapshot", "alpha", "beta", "rc", "final");
    private final String fullVersion;
    private final Integer major;
    private final Integer minor;
    private final Integer patch;
    private final String qualifier;
    private final Integer qualifierVersion;
    private final List<Integer> extraVersions;

    ComparableVersion(String fullVersion, Integer major, Integer minor, Integer patch, String qualifier, Integer qualifierVersion, List<Integer> extraVersions) {
        this.fullVersion = fullVersion;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualifier;
        this.qualifierVersion = qualifierVersion;
        this.extraVersions = extraVersions;
    }

    public String fullVersion() {
        return this.fullVersion;
    }

    public Optional<Integer> major() {
        return Optional.ofNullable(this.major);
    }

    public Optional<Integer> minor() {
        return Optional.ofNullable(this.minor);
    }

    public Optional<Integer> patch() {
        return Optional.ofNullable(this.patch);
    }

    public Optional<String> qualifier() {
        return Optional.ofNullable(this.qualifier);
    }

    public Optional<Integer> qualifierVersion() {
        return Optional.ofNullable(this.qualifierVersion);
    }

    public List<Integer> getExtraVersions() {
        return this.extraVersions;
    }

    public List<Integer> getVersionComponents() {
        ArrayList<Integer> all = new ArrayList<Integer>(3 + this.extraVersions.size());
        all.add(Objects.requireNonNullElse(this.major, 0));
        all.add(Objects.requireNonNullElse(this.minor, 0));
        all.add(Objects.requireNonNullElse(this.patch, 0));
        all.addAll(this.extraVersions);
        return all;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparableVersion that = (ComparableVersion)o;
        return Objects.equals(this.fullVersion, that.fullVersion);
    }

    public int hashCode() {
        return Objects.hashCode(this.fullVersion);
    }

    public String toString() {
        return this.fullVersion;
    }

    @Override
    public int compareTo(ComparableVersion o) {
        int otherQualifierIndex;
        int thisQualifierIndex;
        List<Integer> components = this.getVersionComponents();
        List<Integer> otherComponents = o.getVersionComponents();
        if (components.size() != otherComponents.size()) {
            if (components.size() < otherComponents.size()) {
                components = new ArrayList<Integer>(components);
                while (components.size() < otherComponents.size()) {
                    components.add(0);
                }
            } else {
                otherComponents = new ArrayList<Integer>(otherComponents);
                while (otherComponents.size() < components.size()) {
                    otherComponents.add(0);
                }
            }
        }
        for (int i = 0; i < components.size(); ++i) {
            int result = components.get(i).compareTo(otherComponents.get(i));
            if (result == 0) continue;
            return result;
        }
        if (this.qualifier == null && o.qualifier != null) {
            return 1;
        }
        if (this.qualifier != null && o.qualifier == null) {
            return -1;
        }
        if (this.qualifier != null && (thisQualifierIndex = PARTIAL_QUALIFIER_ORDER.indexOf(this.qualifier.toLowerCase(Locale.US))) != (otherQualifierIndex = PARTIAL_QUALIFIER_ORDER.indexOf(o.qualifier.toLowerCase(Locale.US)))) {
            return Integer.compare(thisQualifierIndex, otherQualifierIndex);
        }
        if (this.qualifierVersion != null && o.qualifierVersion != null) {
            return this.qualifierVersion.compareTo(o.qualifierVersion);
        }
        if (this.qualifierVersion != null) {
            return 1;
        }
        if (o.qualifierVersion != null) {
            return -1;
        }
        return 0;
    }
}

