/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.utils;

import java.io.File;
import java.io.FileReader;
import java.util.Properties;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public class ProviderUtils {
    public static boolean guessCI(ProviderFactory providers) {
        return (Boolean)providers.environmentVariable("CI").flatMap(s -> providers.environmentVariable("GRADLE_ENTERPRISE_ACCESS_KEY").map(env -> true).orElse((Object)false)).orElse((Object)false).get();
    }

    public static String envOrSystemProperty(ProviderFactory providers, String envName, String propertyName, String defaultValue) {
        return (String)providers.environmentVariable(envName).orElse(providers.gradleProperty(propertyName)).orElse(providers.systemProperty(propertyName)).getOrElse((Object)defaultValue);
    }

    public static Provider<String> fromGradleProperty(ProviderFactory providers, File baseDir, String propertyName) {
        return providers.gradleProperty(propertyName).orElse(providers.provider(() -> {
            File dir = baseDir;
            while (dir.getParentFile() != null) {
                File gradleProperties = new File(dir, "gradle.properties");
                if (gradleProperties.exists()) {
                    Properties props = new Properties();
                    try (FileReader reader = new FileReader(gradleProperties);){
                        props.load(reader);
                        String property = props.getProperty(propertyName);
                        if (property != null) {
                            String string = property;
                            return string;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error reading gradle.properties", e);
                    }
                }
                dir = dir.getParentFile();
            }
            return null;
        }));
    }
}

