/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.docs.converter;

import io.micronaut.docs.converter.AbstractModelVisitor;
import io.micronaut.docs.converter.ModelVisitor;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class JavaPropertiesGenerator
extends AbstractModelVisitor {
    private static final Pattern NON_ASCII_CHARS = Pattern.compile("[^\\p{ASCII}]");

    public JavaPropertiesGenerator(Map<String, Object> model) {
        super(model);
    }

    @Override
    public void visitMapEntry(ModelVisitor.Context context, String entryKey, Object entryValue, boolean isLast) {
        this.visit(context, entryValue);
    }

    @Override
    public void preVisitMap(ModelVisitor.Context context, Map<String, Object> map) {
    }

    @Override
    public void postVisitMap(ModelVisitor.Context context, Map<String, Object> map) {
    }

    @Override
    public void postVisitMapEntry(ModelVisitor.Context context, String entryKey, Object entryValue, boolean isLast) {
    }

    @Override
    public void preVisitMapEntry(ModelVisitor.Context context, String entryKey, Object entryValue, boolean isLast) {
    }

    @Override
    public void preVisitList(ModelVisitor.Context context, List<Object> list) {
    }

    @Override
    public void postVisitList(ModelVisitor.Context context, List<Object> list) {
    }

    @Override
    public void preVisitListItem(ModelVisitor.Context context, Object item, boolean isLastItem) {
    }

    @Override
    public void postVisitListItem(ModelVisitor.Context context, Object item, boolean isLastItem) {
    }

    @Override
    public void visitListItem(ModelVisitor.Context context, Object item, boolean isLastItem) {
        this.visit(context, item);
    }

    @Override
    public void visitObject(ModelVisitor.Context context, Object scalar) {
        String path = context.pathElements().reduce("", (cur, item) -> {
            String escaped = JavaPropertiesGenerator.escape(item);
            if ("".equals(cur)) {
                return escaped;
            }
            if (item.startsWith("[")) {
                return cur + escaped;
            }
            return cur + "." + escaped;
        });
        this.append(path).append("=").append(scalar);
        this.append("\n");
    }

    private static String escape(String str) {
        return NON_ASCII_CHARS.matcher(str).replaceAll("\\\\$0");
    }
}

