/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import groovy.namespace.QName;
import groovy.util.Node;
import io.micronaut.build.MicronautBuildExtensionPlugin;
import io.micronaut.build.MicronautDependencyResolutionConfigurationPlugin;
import io.micronaut.build.MicronautPlugin;
import io.micronaut.build.MicronautPublishingPlugin;
import io.micronaut.build.SimpleMavenModelResolver;
import io.micronaut.build.catalogs.internal.LenientVersionCatalogParser;
import io.micronaut.build.catalogs.internal.Library;
import io.micronaut.build.catalogs.internal.Plugin;
import io.micronaut.build.catalogs.internal.VersionCatalogTomlModel;
import io.micronaut.build.catalogs.internal.VersionModel;
import io.micronaut.build.compat.MicronautBinaryCompatibilityPlugin;
import io.micronaut.build.pom.InterceptedVersionCatalogBuilder;
import io.micronaut.build.pom.MicronautBomExtension;
import io.micronaut.build.pom.PomChecker;
import io.micronaut.build.pom.PomCheckerUtils;
import io.micronaut.build.pom.VersionCatalogConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.DefaultModelProcessor;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.composition.DefaultDependencyManagementImporter;
import org.apache.maven.model.composition.DependencyManagementImporter;
import org.apache.maven.model.inheritance.DefaultInheritanceAssembler;
import org.apache.maven.model.inheritance.InheritanceAssembler;
import org.apache.maven.model.interpolation.DefaultModelVersionProcessor;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.interpolation.ModelVersionProcessor;
import org.apache.maven.model.interpolation.StringVisitorModelInterpolator;
import org.apache.maven.model.io.DefaultModelReader;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.locator.DefaultModelLocator;
import org.apache.maven.model.locator.ModelLocator;
import org.apache.maven.model.management.DefaultDependencyManagementInjector;
import org.apache.maven.model.management.DefaultPluginManagementInjector;
import org.apache.maven.model.management.DependencyManagementInjector;
import org.apache.maven.model.management.PluginManagementInjector;
import org.apache.maven.model.normalization.DefaultModelNormalizer;
import org.apache.maven.model.normalization.ModelNormalizer;
import org.apache.maven.model.path.DefaultModelPathTranslator;
import org.apache.maven.model.path.DefaultModelUrlNormalizer;
import org.apache.maven.model.path.DefaultPathTranslator;
import org.apache.maven.model.path.DefaultUrlNormalizer;
import org.apache.maven.model.path.ModelPathTranslator;
import org.apache.maven.model.path.ModelUrlNormalizer;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.path.ProfileActivationFilePathInterpolator;
import org.apache.maven.model.path.UrlNormalizer;
import org.apache.maven.model.plugin.DefaultReportingConverter;
import org.apache.maven.model.plugin.ReportingConverter;
import org.apache.maven.model.profile.DefaultProfileSelector;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.superpom.DefaultSuperPomProvider;
import org.apache.maven.model.superpom.SuperPomProvider;
import org.apache.maven.model.validation.DefaultModelValidator;
import org.apache.maven.model.validation.ModelValidator;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.VersionCatalog;
import org.gradle.api.artifacts.VersionCatalogsExtension;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.RegularFile;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.plugins.JavaPlatformExtension;
import org.gradle.api.plugins.JavaPlatformPlugin;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.plugins.catalog.CatalogPluginExtension;
import org.gradle.api.plugins.catalog.VersionCatalogPlugin;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MicronautBomPlugin
implements MicronautPlugin<Project> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicronautBomPlugin.class);
    private static final Pattern BASENAME_EXTRACTOR = Pattern.compile("^([a-zA-Z0-9-]+?)-\\d[\\d.-]*(-[a-zA-Z0-9]+)?.+$");
    public static final List<String> DEPENDENCY_PATH = Arrays.asList("dependencyManagement", "dependencies", "dependency");
    public static final String BOM_VERSION_INFERENCE_CONFIGURATION_NAME = "bomVersionInference";
    public static final String EXTRA_BOMS_INLINING_CONFIGURATION_NAME = "extraBomsInlining";
    public static final String ALL_BOMS_CONFIGURATION_NAME = "allBoms";
    public static final String CATALOGS_INLINING_CONFIGURATION_NAME = "inlinedCatalogs";
    private ModelResolver mavenModelResolver;

    public void apply(Project project) {
        PluginManager plugins = project.getPluginManager();
        plugins.apply(JavaPlatformPlugin.class);
        plugins.apply(VersionCatalogPlugin.class);
        plugins.apply(MicronautBuildExtensionPlugin.class);
        plugins.apply(MicronautPublishingPlugin.class);
        plugins.apply(MicronautDependencyResolutionConfigurationPlugin.class);
        plugins.apply(MicronautBinaryCompatibilityPlugin.class);
        MicronautBomExtension bomExtension = (MicronautBomExtension)project.getExtensions().create("micronautBom", MicronautBomExtension.class, new Object[0]);
        bomExtension.getPublishCatalog().convention((Object)true);
        bomExtension.getIncludeBomInCatalog().convention((Object)true);
        bomExtension.getImportProjectCatalog().convention((Object)true);
        bomExtension.getExcludeProject().convention(p -> p.getName().contains("bom") || p.getName().startsWith("test-suite") || !p.getSubprojects().isEmpty());
        bomExtension.getExtraExcludedProjects().add((Object)project.getName());
        bomExtension.getCatalogToPropertyNameOverrides().convention(Collections.emptyMap());
        bomExtension.getInlineNestedCatalogs().convention((Object)true);
        bomExtension.getExcludedInlinedAliases().convention(Set.of());
        bomExtension.getInlineRegularBOMs().convention((Object)false);
        bomExtension.getInferProjectsToInclude().convention((Object)true);
        bomExtension.getCatalogName().convention((Object)"libs");
        this.configureBOM(project, bomExtension);
        this.mavenModelResolver = new SimpleMavenModelResolver(project.getConfigurations(), project.getDependencies());
        MicronautBomPlugin.createHelperConfigurations(project);
    }

    private static void createHelperConfigurations(Project project) {
        project.getConfigurations().create(BOM_VERSION_INFERENCE_CONFIGURATION_NAME, conf -> {
            conf.setCanBeResolved(true);
            conf.setCanBeConsumed(false);
        });
        project.getConfigurations().create(ALL_BOMS_CONFIGURATION_NAME, conf -> {
            conf.setCanBeResolved(true);
            conf.setCanBeConsumed(false);
        });
        project.getConfigurations().create(EXTRA_BOMS_INLINING_CONFIGURATION_NAME, conf -> {
            conf.setCanBeResolved(true);
            conf.setCanBeConsumed(false);
        });
        project.getConfigurations().create(CATALOGS_INLINING_CONFIGURATION_NAME, catalogs -> {
            catalogs.setCanBeResolved(true);
            catalogs.setCanBeConsumed(false);
            catalogs.attributes(attrs -> {
                attrs.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)project.getObjects().named(Category.class, "platform")));
                attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "version-catalog")));
            });
        });
    }

    private static String nameOf(Node n) {
        Object name = n.name();
        if (name instanceof String) {
            return (String)name;
        }
        return ((QName)n.name()).getLocalPart();
    }

    private static Stream<Node> forEachNode(Node node, List<String> path) {
        if (path.isEmpty()) {
            return Stream.empty();
        }
        String child = path.get(0);
        List children = node.children();
        if (path.size() == 1) {
            return children.stream().filter(n -> MicronautBomPlugin.nameOf(n).equals(child));
        }
        return children.stream().filter(n -> MicronautBomPlugin.nameOf(n).equals(child)).flatMap(n -> MicronautBomPlugin.forEachNode(n, path.subList(1, path.size())));
    }

    private Node childOf(Node node, String name) {
        List children = node.children();
        return children.stream().filter(n -> MicronautBomPlugin.nameOf(n).equals(name)).findFirst().orElse(null);
    }

    private static String removePrefix(String str, String prefix) {
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    private static String toPropertyName(String alias) {
        return Arrays.stream(alias.split("(?=[A-Z])")).map(s -> s.toLowerCase(Locale.US)).collect(Collectors.joining("-")).replace('-', '.');
    }

    private String bomPropertyName(MicronautBomExtension ext, String alias) {
        alias = MicronautBomPlugin.removePrefix(alias, "managed.");
        alias = MicronautBomPlugin.removePrefix(alias, "boms.");
        String baseName = (String)ext.getCatalogToPropertyNameOverrides().getting((Object)alias).getOrElse((Object)MicronautBomPlugin.toPropertyName(alias));
        return baseName + ".version";
    }

    private static List<ProjectDescriptor> computeProjectDescriptors(MicronautBomExtension ext, Project project, Set<String> includedProjects, Set<String> skippedProjects) {
        ArrayList<ProjectDescriptor> result = new ArrayList<ProjectDescriptor>();
        boolean inferProjectsToInclude = (Boolean)ext.getInferProjectsToInclude().getOrElse((Object)true);
        Set excludedProjects = (Set)ext.getExtraExcludedProjects().get();
        Spec excludeSpec = (Spec)ext.getExcludeProject().get();
        for (Project p : project.getRootProject().getSubprojects()) {
            if (p.equals(project) || excludeSpec.isSatisfiedBy((Object)p) || excludedProjects.contains(p.getName())) continue;
            project.evaluationDependsOn(p.getPath());
            if (!inferProjectsToInclude || p.getPlugins().hasPlugin(MicronautPublishingPlugin.class)) {
                includedProjects.add(p.getPath());
                result.add(ProjectDescriptor.fromProject(p));
                continue;
            }
            skippedProjects.add(p.getPath());
        }
        return Collections.unmodifiableList(result);
    }

    private void configureBOM(Project project, MicronautBomExtension bomExtension) {
        PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        JavaPlatformExtension javaPlatformExtension = (JavaPlatformExtension)project.getExtensions().getByType(JavaPlatformExtension.class);
        javaPlatformExtension.allowDependencies();
        TaskContainer tasks = project.getTasks();
        project.afterEvaluate(unused -> this.configureLate(project, bomExtension, publishing, tasks));
        this.registerCheckBomTask(project, publishing, bomExtension);
    }

    private void configureLate(Project project, MicronautBomExtension bomExtension, PublishingExtension publishing, TaskContainer tasks) {
        String mainProjectId = (String)bomExtension.getPropertyName().getOrElse((Object)project.getRootProject().getName().replace("-parent", "").replace('-', '.'));
        String publishedName = MicronautPlugin.moduleNameOf(project.getName());
        String group = String.valueOf(project.getGroup());
        Optional<VersionCatalog> versionCatalog = MicronautBomPlugin.findVersionCatalog(project, bomExtension);
        VersionCatalogConverter modelConverter = new VersionCatalogConverter(project.getRootProject().file((Object)("gradle/" + (String)bomExtension.getCatalogName().get() + ".versions.toml")), (CatalogPluginExtension)project.getExtensions().findByType(CatalogPluginExtension.class));
        ArrayList libraryDefinitions = new ArrayList();
        modelConverter.onLibrary(libraryDefinitions::add);
        tasks.named("generateCatalogAsToml", task -> modelConverter.populateModel());
        if (((Boolean)bomExtension.getPublishCatalog().get()).booleanValue()) {
            this.configureVersionCatalog(project, bomExtension, publishedName, group, mainProjectId);
        }
        Provider modelProvider = project.provider(modelConverter::getModel);
        final HashSet includedProjects = new HashSet();
        final HashSet skippedProjects = new HashSet();
        Provider projectDescriptors = project.provider(() -> MicronautBomPlugin.computeProjectDescriptors(bomExtension, project, includedProjects, skippedProjects));
        LinkedHashMap inlinedPomProperties = new LinkedHashMap();
        ArrayList inlinedMavenDependencies = new ArrayList();
        final Path logFile = MicronautBomPlugin.prepareLogFile(project);
        publishing.getPublications().named("maven", MavenPublication.class, pub -> {
            pub.setArtifactId(publishedName);
            pub.from((SoftwareComponent)project.getComponents().getByName("javaPlatform"));
            pub.pom(pom -> {
                pom.setPackaging("pom");
                pom.withXml(xml -> {
                    Node node = xml.asNode();
                    ((VersionCatalogTomlModel)modelProvider.get()).getLibrariesTable().forEach(library -> {
                        String alias = Optional.ofNullable(library.getVersion().getReference()).map(a -> a.replace('-', '.')).orElse("");
                        String libraryAlias = Optional.ofNullable(library.getAlias()).map(a -> a.replace('-', '.')).orElse("");
                        if (libraryAlias.startsWith("managed.") || libraryAlias.startsWith("boms.")) {
                            Optional<Node> pomDep = MicronautBomPlugin.forEachNode(node, DEPENDENCY_PATH).filter(n -> this.childOf((Node)n, "artifactId").text().equals(library.getName()) && this.childOf((Node)n, "groupId").text().equals(library.getGroup())).findFirst();
                            if (pomDep.isPresent()) {
                                String bomPropertyName = this.bomPropertyName(bomExtension, alias);
                                this.childOf(pomDep.get(), "version").setValue((Object)("${" + bomPropertyName + "}"));
                            } else {
                                System.err.println("[WARNING] Didn't find library " + library.getGroup() + ":" + library.getName() + " in BOM file");
                            }
                        }
                    });
                    ((List)projectDescriptors.get()).forEach(p -> {
                        String propertyName = "micronaut." + mainProjectId + ".version";
                        String projectGroup = p.getGroupId();
                        String moduleName = p.getArtifactId();
                        Optional<Node> pomDep = MicronautBomPlugin.forEachNode(node, DEPENDENCY_PATH).filter(n -> this.childOf((Node)n, "artifactId").text().equals(moduleName) && this.childOf((Node)n, "groupId").text().equals(projectGroup)).findFirst();
                        if (pomDep.isPresent()) {
                            this.childOf(pomDep.get(), "version").setValue((Object)("${" + propertyName + "}"));
                        } else {
                            System.err.println("[WARNING] Didn't find dependency " + projectGroup + ":" + moduleName + " in BOM file");
                        }
                    });
                    Node propertiesNode = this.childOf(node, "properties");
                    Node dependencyManagementNode = this.childOf(node, "dependencyManagement");
                    Node dependencyManagementDependenciesNode = this.childOf(dependencyManagementNode, "dependencies");
                    inlinedPomProperties.forEach((moduleName, version) -> {
                        String propertyName = this.bomPropertyName(bomExtension, (String)moduleName);
                        Node existingProperty = this.childOf(propertiesNode, propertyName);
                        if (existingProperty == null) {
                            propertiesNode.appendNode((Object)propertyName, version);
                        }
                    });
                    propertiesNode.children().sort((o1, o2) -> {
                        String name1 = MicronautBomPlugin.nameOf((Node)o1);
                        String name2 = MicronautBomPlugin.nameOf((Node)o2);
                        return name1.compareTo(name2);
                    });
                    inlinedMavenDependencies.forEach(dep -> {
                        Node dependencyNode = new Node(null, (Object)"dependency");
                        dependencyNode.append(new Node(null, (Object)"groupId", (Object)dep.groupId));
                        dependencyNode.append(new Node(null, (Object)"artifactId", (Object)dep.artifactId));
                        dependencyNode.append(new Node(null, (Object)"version", (Object)("${" + dep.versionProperty + "}")));
                        dependencyManagementDependenciesNode.append(dependencyNode);
                    });
                    this.makeImportedBOMsLast(dependencyManagementDependenciesNode);
                });
                versionCatalog.ifPresent(libsCatalog -> libsCatalog.getVersionAliases().forEach(alias -> {
                    if (alias.startsWith("managed.")) {
                        libsCatalog.findVersion(alias).ifPresent(version -> {
                            String propertyName = this.bomPropertyName(bomExtension, (String)alias);
                            pom.getProperties().put((Object)propertyName, (Object)version.getRequiredVersion());
                        });
                    }
                }));
                ((List)projectDescriptors.get()).forEach(p -> {
                    project.evaluationDependsOn(p.getPath());
                    String propertyName = "micronaut." + mainProjectId + ".version";
                    pom.getProperties().put((Object)propertyName, (Object)PomCheckerUtils.assertVersion(p.getVersion(), p.getPath()));
                });
                tasks.withType(GenerateMavenPom.class).configureEach(pomTask -> pomTask.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        System.out.println("Projects included into BOM:\n" + includedProjects.stream().map(p -> "    - " + p).collect(Collectors.joining("\n")));
                        if (!skippedProjects.isEmpty()) {
                            System.out.println("Skipped projects which do not apply the publishing plugin:\n" + skippedProjects.stream().map(p -> "    - " + p).collect(Collectors.joining("\n")));
                        }
                        System.out.println("Inlining log file: " + String.valueOf(logFile));
                    }
                }));
            });
        });
        Configuration api = project.getConfigurations().getByName("api");
        Configuration runtime = project.getConfigurations().getByName("runtime");
        Configuration catalogs = project.getConfigurations().getByName(CATALOGS_INLINING_CONFIGURATION_NAME);
        Configuration allBoms = project.getConfigurations().getByName(ALL_BOMS_CONFIGURATION_NAME);
        versionCatalog.ifPresent(libsCatalog -> libsCatalog.getLibraryAliases().forEach(alias -> {
            if (alias.startsWith("boms.")) {
                MinimalExternalModuleDependency catalogEntry = libsCatalog.findLibrary(alias).map(Provider::get).orElseThrow(() -> new RuntimeException("Unexpected missing alias in catalog: " + alias));
                Dependency catalog = project.getDependencies().platform((Object)catalogEntry);
                api.getDependencies().add((Object)catalog);
                catalogs.getDependencies().add((Object)catalog);
                Dependency bomDependency = project.getDependencies().create((Object)catalogEntry);
                if (bomDependency instanceof ExternalModuleDependency) {
                    ExternalModuleDependency emd = (ExternalModuleDependency)bomDependency;
                    emd.artifact(a -> a.setExtension("pom"));
                }
                allBoms.getDependencies().add((Object)bomDependency);
            } else if (alias.startsWith("managed.")) {
                api.getDependencyConstraints().add((Object)project.getDependencies().getConstraints().create((Object)libsCatalog.findLibrary(alias).map(Provider::get).orElseThrow(() -> new RuntimeException("Unexpected missing alias in catalog: " + alias))));
            }
        }));
        ArtifactView catalogArtifactView = catalogs.getIncoming().artifactView(spec -> spec.lenient(true));
        Set catalogArtifacts = catalogArtifactView.getArtifacts().getArtifacts();
        Set bomArtifacts = allBoms.getIncoming().artifactView(spec -> spec.lenient(true)).getArtifacts().getArtifacts();
        Property<Boolean> inlineNestedCatalogs = bomExtension.getInlineNestedCatalogs();
        Property<Boolean> inlineNestedBOMs = bomExtension.getInlineRegularBOMs();
        Provider excludedInlinedAliases = bomExtension.getExcludeFromInlining().zip(bomExtension.getExcludedInlinedAliases(), (excludeMap, simpleExcludes) -> {
            HashMap result = new HashMap(excludeMap);
            simpleExcludes.forEach(e -> result.computeIfAbsent("*", k -> new HashSet()).add(e));
            return result;
        });
        MapProperty<String, Set<String>> includedAliases = bomExtension.getInlinedAliases();
        ArrayList knownLibraries = new ArrayList();
        modelConverter.onLibrary(l -> knownLibraries.add(l.groupId() + ":" + l.artifactId()));
        modelConverter.afterBuildingModel(builderState -> {
            api.getAllDependencyConstraints().forEach(MicronautBomPlugin::checkVersionConstraint);
            runtime.getAllDependencyConstraints().forEach(MicronautBomPlugin::checkVersionConstraint);
            try (PrintWriter log = new PrintWriter(Files.newBufferedWriter(logFile, new OpenOption[0]));){
                this.maybeInlineNestedCatalogs(log, catalogArtifacts, bomArtifacts, (VersionCatalogConverter.BuilderState)builderState, inlineNestedCatalogs, inlineNestedBOMs, (Provider<Map<String, Set<String>>>)excludedInlinedAliases, includedAliases, inlinedPomProperties, inlinedMavenDependencies, project);
                MicronautBomPlugin.performVersionInference(log, project, bomExtension, builderState, libraryDefinitions, inlinedPomProperties, inlinedMavenDependencies, (Configuration)project.getConfigurations().findByName(BOM_VERSION_INFERENCE_CONFIGURATION_NAME), knownLibraries);
                LinkedHashSet unresolvedDependencies = new LinkedHashSet();
                catalogs.getIncoming().getResolutionResult().allDependencies(dep -> {
                    if (dep instanceof UnresolvedDependencyResult) {
                        UnresolvedDependencyResult unresolved = (UnresolvedDependencyResult)dep;
                        unresolvedDependencies.add(unresolved.getRequested());
                    }
                });
                allBoms.getIncoming().getResolutionResult().allDependencies(dep -> {
                    if (dep instanceof UnresolvedDependencyResult) {
                        UnresolvedDependencyResult unresolved = (UnresolvedDependencyResult)dep;
                        unresolvedDependencies.add(unresolved.getRequested());
                    }
                });
                if (!unresolvedDependencies.isEmpty()) {
                    log.println("[WARNING] There were unresolved dependencies during inlining! This may cause incomplete catalogs!");
                    for (ComponentSelector unresolvedDependency : unresolvedDependencies) {
                        log.println("   " + String.valueOf(unresolvedDependency));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        ((List)projectDescriptors.get()).forEach(p -> {
            String moduleGroup = p.getGroupId();
            String moduleName = p.getArtifactId();
            String moduleVersion = PomCheckerUtils.assertVersion(p.getVersion(), p.getPath());
            api.getDependencyConstraints().add((Object)project.getDependencies().getConstraints().create((Object)(moduleGroup + ":" + moduleName + ":" + moduleVersion)));
            String mainModuleName = MicronautPlugin.moduleNameOf(mainProjectId.replace('.', '-'));
            modelConverter.getExtraVersions().put(mainModuleName, moduleVersion);
            modelConverter.getExtraLibraries().put(moduleName, VersionCatalogConverter.library(moduleGroup, moduleName, mainModuleName));
        });
    }

    private static void performVersionInference(PrintWriter log, Project project, MicronautBomExtension bomExtension, VersionCatalogConverter.BuilderState builderState, List<InterceptedVersionCatalogBuilder.LibraryDefinition> libraryDefinitions, Map<String, String> inlinedPomProperties, List<InlinedDependency> inlinedMavenDependencies, Configuration versionInferenceConfiguration, List<String> knownLibrariesList) {
        Set knownLibraries = knownLibrariesList.stream().collect(Collectors.toUnmodifiableSet());
        Map inferredLibraries = (Map)bomExtension.getInferredManagedDependencies().getOrElse(Map.of());
        if (!inferredLibraries.isEmpty()) {
            HashSet found = new HashSet();
            libraryDefinitions.forEach(lib -> {
                if (lib.version() != null) {
                    versionInferenceConfiguration.getDependencies().add((Object)project.getDependencies().create((Object)lib.toString()));
                }
            });
            HashSet seen = new HashSet();
            versionInferenceConfiguration.getIncoming().getResolutionResult().allDependencies(dep -> {
                ModuleComponentIdentifier mid;
                String module;
                ResolvedDependencyResult resolved;
                ComponentIdentifier patt29097$temp;
                if (dep instanceof ResolvedDependencyResult && (patt29097$temp = (resolved = (ResolvedDependencyResult)dep).getSelected().getId()) instanceof ModuleComponentIdentifier && seen.add(module = (mid = (ModuleComponentIdentifier)patt29097$temp).getModuleIdentifier().toString()) && inferredLibraries.containsKey(module)) {
                    InlinedDependency inlinedMavenDep;
                    if (knownLibraries.contains(module)) {
                        found.add(module);
                        log.println("Library " + module + " is already present in the catalog, remove it from the inferred versions list");
                        return;
                    }
                    found.add(module);
                    String alias = (String)inferredLibraries.get(module);
                    if (!builderState.getKnownVersionAliases().containsKey(alias)) {
                        builderState.getBuilder().version(alias, mid.getVersion());
                    }
                    String mavenPropertyName = MicronautBomPlugin.toPropertyName(alias);
                    if (!inlinedPomProperties.containsKey(alias)) {
                        inlinedPomProperties.put(mavenPropertyName, mid.getVersion());
                    }
                    if (!builderState.getKnownAliases().containsKey(alias)) {
                        builderState.getBuilder().library(alias, mid.getGroup(), mid.getModule()).versionRef(alias);
                    }
                    if (!inlinedMavenDependencies.contains(inlinedMavenDep = new InlinedDependency(mid.getGroup(), mid.getModule(), mavenPropertyName + ".version"))) {
                        inlinedMavenDependencies.add(inlinedMavenDep);
                    }
                }
            });
            ArrayList missing = new ArrayList(inferredLibraries.keySet());
            missing.removeAll(found);
            if (!missing.isEmpty()) {
                throw new RuntimeException("Some dependencies were declared as inferred, but they don't appear in the dependency graph. You must use an explicit version for these : " + String.valueOf(missing));
            }
        }
    }

    @NotNull
    private static Path prepareLogFile(Project project) {
        Path logFile = ((RegularFile)project.getLayout().getBuildDirectory().file("logs/inlining-" + System.currentTimeMillis() + ".log").get()).getAsFile().toPath();
        try {
            Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return logFile;
    }

    private void makeImportedBOMsLast(Node dependencyManagementDependenciesNode) {
        dependencyManagementDependenciesNode.children().sort((o1, o2) -> {
            Node scope1 = this.childOf((Node)o1, "scope");
            Node scope2 = this.childOf((Node)o2, "scope");
            if (scope1 == null && scope2 == null) {
                return 0;
            }
            if (scope1 != null && scope2 == null) {
                return 1;
            }
            if (scope1 == null) {
                return -1;
            }
            return String.valueOf(scope1.value()).compareTo(String.valueOf(scope2.value()));
        });
    }

    private void maybeInlineNestedCatalogs(PrintWriter log, Set<ResolvedArtifactResult> catalogs, Set<ResolvedArtifactResult> bomArtifacts, VersionCatalogConverter.BuilderState builderState, Property<Boolean> inlineNestedCatalogs, Property<Boolean> inlineNestedBOMs, Provider<Map<String, Set<String>>> excludedInlinedAliases, MapProperty<String, Set<String>> inlinedAliases, Map<String, String> inlinedPomProperties, List<InlinedDependency> inlinedMavenDependencies, Project p) {
        if (Boolean.TRUE.equals(inlineNestedCatalogs.get())) {
            VersionCatalogBuilder builder = builderState.getBuilder();
            Map<String, VersionCatalogConverter.AliasRecord> knownAliases = builderState.getKnownAliases();
            Map<String, VersionCatalogConverter.AliasRecord> knownPluginAliases = builderState.getKnownPluginAliases();
            Map<String, VersionCatalogConverter.AliasRecord> knownVersionAliases = builderState.getKnownVersionAliases();
            HashSet<String> ignoredBomFiles = new HashSet<String>();
            Set knownCatalogModules = catalogs.stream().map(ResolvedArtifactResult::getVariant).map(ResolvedVariantResult::getOwner).filter(ModuleComponentIdentifier.class::isInstance).map(ModuleComponentIdentifier.class::cast).map(mci -> mci.getModuleIdentifier().toString()).collect(Collectors.toSet());
            ArrayList extraBomsToResolve = new ArrayList();
            catalogs.forEach(catalogArtifact -> {
                File catalogFile = catalogArtifact.getFile();
                Set<String> excludes = MicronautBomPlugin.determineExcludes(excludedInlinedAliases, catalogFile);
                Set<String> includes = ((Map)inlinedAliases.get()).getOrDefault(MicronautBomPlugin.baseNameOf(catalogFile), Set.of());
                Set<String> excludedAliases = MicronautBomPlugin.findRegularEntries(excludes);
                Set<String> excludedAliasesPrefixes = MicronautBomPlugin.findWildcardEntries(excludes);
                Set<String> includeAliases = MicronautBomPlugin.findRegularEntries(includes);
                Set<String> includedAliasesPrefixes = MicronautBomPlugin.findWildcardEntries(includes);
                MicronautBomPlugin.performSingleCatalogFileInclusion(log, inlinedPomProperties, catalogFile, ignoredBomFiles, includeAliases, includedAliasesPrefixes, excludedAliases, excludedAliasesPrefixes, knownAliases, knownVersionAliases, builder, knownPluginAliases, inlinedMavenDependencies, knownCatalogModules, extraBomsToResolve);
            });
            if (Boolean.TRUE.equals(inlineNestedBOMs.get())) {
                log.println("Regular BOMs (without version catalog) inlining is enabled");
                this.inlineRegularBoms(log, bomArtifacts, excludedInlinedAliases, inlinedAliases, inlinedPomProperties, inlinedMavenDependencies, ignoredBomFiles, knownAliases, knownVersionAliases, builder);
                if (!extraBomsToResolve.isEmpty()) {
                    log.println("Found the following BOMs to be recursively included: ");
                    extraBomsToResolve.forEach(bom -> log.println("    - " + bom));
                    Configuration extraBoms = p.getConfigurations().getByName(EXTRA_BOMS_INLINING_CONFIGURATION_NAME);
                    extraBoms.getDependencies().addAll(extraBomsToResolve.stream().map(bom -> p.getDependencies().create((Object)(bom + "@pom"))).toList());
                    this.inlineRegularBoms(log, extraBoms.getIncoming().getArtifacts().getArtifacts(), excludedInlinedAliases, inlinedAliases, inlinedPomProperties, inlinedMavenDependencies, ignoredBomFiles, knownAliases, knownVersionAliases, builder);
                }
            }
        }
    }

    private static Set<String> determineExcludes(Provider<Map<String, Set<String>>> excludedInlinedAliases, File catalogFile) {
        Set moduleExcludes = ((Map)excludedInlinedAliases.get()).getOrDefault(MicronautBomPlugin.baseNameOf(catalogFile), Set.of());
        Set starExcludes = ((Map)excludedInlinedAliases.get()).getOrDefault("*", Set.of());
        return Stream.concat(moduleExcludes.stream(), starExcludes.stream()).collect(Collectors.toSet());
    }

    private void inlineRegularBoms(PrintWriter log, Set<ResolvedArtifactResult> bomArtifacts, Provider<Map<String, Set<String>>> excludedInlinedAliases, MapProperty<String, Set<String>> inlinedAliases, Map<String, String> inlinedPomProperties, List<InlinedDependency> inlinedMavenDependencies, Set<String> ignoredBomFiles, Map<String, VersionCatalogConverter.AliasRecord> knownAliases, Map<String, VersionCatalogConverter.AliasRecord> knownVersionAliases, VersionCatalogBuilder builder) {
        bomArtifacts.forEach(bomArtifact -> {
            File bomFile = bomArtifact.getFile();
            Set<String> excludes = MicronautBomPlugin.determineExcludes(excludedInlinedAliases, bomFile);
            Set<String> includes = ((Map)inlinedAliases.get()).getOrDefault(MicronautBomPlugin.baseNameOf(bomFile), Set.of());
            Set<String> excludedAliases = MicronautBomPlugin.findRegularEntries(excludes);
            Set<String> excludedAliasesPrefixes = MicronautBomPlugin.findWildcardEntries(excludes);
            Set<String> includeAliases = MicronautBomPlugin.findRegularEntries(includes);
            Set<String> includedAliasesPrefixes = MicronautBomPlugin.findWildcardEntries(includes);
            this.performNestedBomsInclusion(log, bomFile, includeAliases, includedAliasesPrefixes, excludedAliases, excludedAliasesPrefixes, ignoredBomFiles, knownAliases, knownVersionAliases, builder, inlinedMavenDependencies, inlinedPomProperties);
        });
    }

    @NotNull
    private static Set<String> findWildcardEntries(Set<String> excludes) {
        return excludes.stream().filter(a -> a.endsWith("*")).map(a -> a.substring(0, a.length() - 1)).collect(Collectors.toSet());
    }

    private static Set<String> findRegularEntries(Set<String> items) {
        return items.stream().filter(a -> !a.endsWith("*")).collect(Collectors.toSet());
    }

    private static String baseNameOf(File file) {
        Matcher matcher = BASENAME_EXTRACTOR.matcher(file.getName());
        String baseName = file.getName();
        if (matcher.find()) {
            baseName = matcher.group(1);
        }
        return baseName;
    }

    private static void performSingleCatalogFileInclusion(PrintWriter log, Map<String, String> inlinedPomProperties, File catalogFile, Set<String> ignoredBomFiles, Set<String> includeAliases, Set<String> includeAliasesPrefixes, Set<String> excludeFromInlining, Set<String> excludeFromInliningPrefixes, Map<String, VersionCatalogConverter.AliasRecord> knownAliases, Map<String, VersionCatalogConverter.AliasRecord> knownVersionAliases, VersionCatalogBuilder builder, Map<String, VersionCatalogConverter.AliasRecord> knownPluginAliases, List<InlinedDependency> inlinedMavenDependencies, Set<String> knownCatalogModules, List<String> extraBomsToResolve) {
        String source = catalogFile.getName();
        log.println("Inlining catalog file: " + source);
        ignoredBomFiles.add(source.substring(0, source.lastIndexOf(".toml")) + ".pom");
        try (FileInputStream fis = new FileInputStream(catalogFile);){
            LenientVersionCatalogParser parser = new LenientVersionCatalogParser();
            parser.parse(fis);
            Set<Library> librariesTable = parser.getModel().getLibrariesTable();
            Set<Plugin> pluginsTable = parser.getModel().getPluginsTable();
            Set<VersionModel> versionsTable = parser.getModel().getVersionsTable();
            MicronautBomPlugin.performLibrariesInlining(log, catalogFile.getName(), inlinedPomProperties, includeAliases, includeAliasesPrefixes, excludeFromInlining, excludeFromInliningPrefixes, knownAliases, knownVersionAliases, builder, librariesTable, versionsTable, source, inlinedMavenDependencies, knownCatalogModules, extraBomsToResolve);
            MicronautBomPlugin.performPluginsInlining(log, catalogFile.getName(), inlinedPomProperties, includeAliases, includeAliasesPrefixes, excludeFromInlining, excludeFromInliningPrefixes, knownVersionAliases, builder, knownPluginAliases, pluginsTable, versionsTable, source);
        }
        catch (IOException e) {
            System.err.println("Unable to parse version catalog file: " + String.valueOf(catalogFile));
        }
    }

    private static void performLibrariesInlining(PrintWriter log, String catalogName, Map<String, String> inlinedPomProperties, Set<String> includeAliases, Set<String> includeAliasesPrefixes, Set<String> excludeFromInlining, Set<String> excludeFromInliningPrefixes, Map<String, VersionCatalogConverter.AliasRecord> knownAliases, Map<String, VersionCatalogConverter.AliasRecord> knownVersionAliases, VersionCatalogBuilder builder, Set<Library> librariesTable, Set<VersionModel> versionsTable, String source, List<InlinedDependency> inlinedMavenDependencies, Set<String> knownCatalogModules, List<String> extraBomsToResolve) {
        librariesTable.forEach(library -> {
            String alias = library.getAlias();
            IncludeExcludeReason includeExcludeReason = MicronautBomPlugin.shouldInclude(alias, includeAliases, includeAliasesPrefixes, excludeFromInlining, excludeFromInliningPrefixes);
            if (includeExcludeReason.included()) {
                if (!knownAliases.containsKey(alias)) {
                    String reference = library.getVersion().getReference();
                    String version = null;
                    if (reference != null) {
                        version = reference;
                        String requiredVersion = versionsTable.stream().filter(m -> reference.equals(m.getReference())).findFirst().get().getVersion().getRequire();
                        if (requiredVersion != null) {
                            String versionProperty = MicronautBomPlugin.toPropertyName(reference) + ".version";
                            inlinedMavenDependencies.add(new InlinedDependency(library.getGroup(), library.getName(), versionProperty));
                            MicronautBomPlugin.maybeAddExtraBomToResolve(log, catalogName, knownCatalogModules, extraBomsToResolve, library, alias, requiredVersion);
                            if (!knownVersionAliases.containsKey(reference)) {
                                builder.version(reference, requiredVersion);
                                inlinedPomProperties.put(reference, requiredVersion);
                            } else {
                                Set<String> sources = ((VersionCatalogConverter.AliasRecord)knownVersionAliases.get(reference)).getSources();
                                if (!sources.equals(Collections.singleton(source))) {
                                    log.println("    [" + catalogName + "] [Warning] While inlining " + source + ", version alias '" + alias + "' is already defined in the catalog by " + String.valueOf(sources) + " so it won't be imported");
                                }
                            }
                        }
                        ((VersionCatalogConverter.AliasRecord)knownVersionAliases.get(reference)).addSource(source);
                    }
                    VersionCatalogBuilder.LibraryAliasBuilder libraryBuilder = builder.library(alias, library.getGroup(), library.getName());
                    if (version != null) {
                        log.println("    [" + catalogName + "] Inlining '" + alias + "' with version '" + version + "' because " + includeExcludeReason.reason());
                        libraryBuilder.versionRef(reference);
                    } else {
                        log.println("    [" + catalogName + "] Inlining '" + alias + "' without version because " + includeExcludeReason.reason());
                        libraryBuilder.withoutVersion();
                    }
                } else {
                    MicronautBomPlugin.maybeWarn(knownAliases, alias, source);
                }
                ((VersionCatalogConverter.AliasRecord)knownAliases.get(alias)).addSource(source);
            } else {
                log.println("    [" + catalogName + "] Excluding '" + alias + "' from inlining because " + includeExcludeReason.reason());
            }
        });
    }

    private static void maybeAddExtraBomToResolve(PrintWriter log, String context, Set<String> knownCatalogModules, List<String> extraBomsToResolve, Library library, String alias, String requiredVersion) {
        String module;
        if (alias.startsWith("boms-") && !knownCatalogModules.contains(module = library.getModule())) {
            String gav = module + ":" + requiredVersion;
            log.println("    [" + context + "] Found extra BOM to inline: " + gav);
            extraBomsToResolve.add(gav);
        }
    }

    private static void performPluginsInlining(PrintWriter log, String catalogName, Map<String, String> inlinedPomProperties, Set<String> includeAliases, Set<String> includeAliasesPrefixes, Set<String> excludeFromInlining, Set<String> excludeFromInliningPrefixes, Map<String, VersionCatalogConverter.AliasRecord> knownVersionAliases, VersionCatalogBuilder builder, Map<String, VersionCatalogConverter.AliasRecord> knownPluginAliases, Set<Plugin> pluginsTable, Set<VersionModel> versionsTable, String source) {
        pluginsTable.forEach(plugin -> {
            String alias = plugin.alias();
            IncludeExcludeReason includeExcludeReason = MicronautBomPlugin.shouldInclude(alias, includeAliases, includeAliasesPrefixes, excludeFromInlining, excludeFromInliningPrefixes);
            if (includeExcludeReason.included()) {
                if (!knownPluginAliases.containsKey(alias)) {
                    String reference = plugin.version().getReference();
                    String version = null;
                    if (reference != null) {
                        version = reference;
                        if (!knownVersionAliases.containsKey(reference)) {
                            String requiredVersion = versionsTable.stream().filter(m -> reference.equals(m.getReference())).findFirst().get().getVersion().getRequire();
                            if (requiredVersion == null) throw new IllegalStateException("Version '" + reference + "' is not defined as a required version in the catalog");
                            builder.version(reference, requiredVersion);
                            inlinedPomProperties.put(reference, requiredVersion);
                        } else {
                            Set<String> sources = ((VersionCatalogConverter.AliasRecord)knownVersionAliases.get(reference)).getSources();
                            if (!sources.equals(Collections.singleton(source))) {
                                log.println("    [" + catalogName + "] [Warning] While inlining plugin " + source + ", version alias '" + alias + "' is already defined in the catalog by " + String.valueOf(sources) + " so it won't be imported");
                            }
                        }
                        ((VersionCatalogConverter.AliasRecord)knownVersionAliases.get(reference)).addSource(source);
                    }
                    VersionCatalogBuilder.PluginAliasBuilder pluginAliasBuilder = builder.plugin(alias, plugin.id());
                    if (version != null) {
                        pluginAliasBuilder.versionRef(reference);
                    } else {
                        pluginAliasBuilder.version(plugin.version().getVersion().getRequire());
                    }
                } else {
                    MicronautBomPlugin.maybeWarn(knownPluginAliases, alias, source);
                }
                ((VersionCatalogConverter.AliasRecord)knownPluginAliases.get(alias)).addSource(source);
                return;
            } else {
                log.println("    [" + catalogName + "] Excluding plugin '" + alias + "' from inlining because " + includeExcludeReason.reason());
            }
        });
    }

    private void performNestedBomsInclusion(PrintWriter log, File bomFile, Set<String> includeAliases, Set<String> includeAliasesPrefixes, Set<String> excludeFromInlining, Set<String> excludeFromInliningPrefixes, Set<String> ignoredBomFiles, Map<String, VersionCatalogConverter.AliasRecord> knownAliases, Map<String, VersionCatalogConverter.AliasRecord> knownVersionAliases, VersionCatalogBuilder builder, List<InlinedDependency> inlinedMavenDependencies, Map<String, String> inlinedPomProperties) {
        String bomFileName = bomFile.getName();
        if (!ignoredBomFiles.contains(bomFileName)) {
            log.println("Inlining external BOM: " + bomFileName);
            DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
            request.setProcessPlugins(false);
            request.setPomFile(bomFile);
            request.setValidationLevel(0);
            request.setModelResolver(this.mavenModelResolver);
            try {
                Set knownAliasesSnakeCase = knownAliases.keySet().stream().map(MicronautBomPlugin::convertToAlias).collect(Collectors.toSet());
                Set knownVersionAliasesSnakeCase = knownVersionAliases.keySet().stream().map(MicronautBomPlugin::convertToAlias).collect(Collectors.toSet());
                ModelBuilder modelBuilder = this.createMavenModelBuilder();
                Model model = modelBuilder.build((ModelBuildingRequest)request).getEffectiveModel();
                model.getDependencyManagement().getDependencies().forEach(dep -> {
                    String alias = MicronautBomPlugin.convertToAlias(dep.getArtifactId());
                    IncludeExcludeReason includeExcludeReason = MicronautBomPlugin.shouldInclude(alias, includeAliases, includeAliasesPrefixes, excludeFromInlining, excludeFromInliningPrefixes);
                    if (includeExcludeReason.included()) {
                        if (knownAliasesSnakeCase.contains(alias) || knownAliases.containsKey(alias)) {
                            MicronautBomPlugin.maybeWarn(knownAliases, alias, bomFileName);
                        } else if (knownVersionAliasesSnakeCase.contains(alias)) {
                            MicronautBomPlugin.maybeWarn(knownVersionAliases, alias, bomFileName);
                        } else {
                            builder.library(alias, dep.getGroupId(), dep.getArtifactId()).versionRef(alias);
                            builder.version(alias, dep.getVersion());
                            ((VersionCatalogConverter.AliasRecord)knownAliases.get(alias)).addSource(bomFileName);
                            ((VersionCatalogConverter.AliasRecord)knownVersionAliases.get(alias)).addSource(bomFileName);
                            String versionProperty = MicronautBomPlugin.toPropertyName(alias) + ".version";
                            inlinedMavenDependencies.add(new InlinedDependency(dep.getGroupId(), dep.getArtifactId(), versionProperty));
                            inlinedPomProperties.putIfAbsent(MicronautBomPlugin.toPropertyName(alias), dep.getVersion());
                            log.println("    [" + bomFileName + "] Inlining " + alias + " because " + includeExcludeReason.reason());
                        }
                    } else {
                        log.println("    [" + bomFileName + "] Excluding " + alias + " from regular BOM inlining because " + includeExcludeReason.reason());
                    }
                });
            }
            catch (ModelBuildingException e) {
                log.println("Unable to inline POM file " + String.valueOf(bomFile) + ": " + e.getMessage());
            }
        } else {
            log.println("Ignoring BOM file: " + bomFileName + " because we've already found a catalog for it");
        }
    }

    private static IncludeExcludeReason shouldInclude(String alias, Set<String> included, Set<String> includedPrefixes, Set<String> excluded, Set<String> excludePrefixes) {
        if (included.isEmpty() && excluded.isEmpty() && includedPrefixes.isEmpty() && excludePrefixes.isEmpty()) {
            return new IncludeExcludeReason(true, "no include or exclude pattern provided");
        }
        if (included.isEmpty() && includedPrefixes.isEmpty()) {
            if (excluded.contains(alias)) {
                return new IncludeExcludeReason(false, "alias is explicitly excluded.");
            }
            for (String prefix : excludePrefixes) {
                if (!alias.startsWith(prefix)) continue;
                return new IncludeExcludeReason(false, "alias matches excluded prefix: " + prefix);
            }
            return new IncludeExcludeReason(true, "alias is not explicitly excluded and does not match any excluded prefix.");
        }
        if (included.contains(alias)) {
            if (excluded.contains(alias)) {
                return new IncludeExcludeReason(false, "alias is explicitly included but also explicitly excluded.");
            }
            for (String prefix : excludePrefixes) {
                if (!alias.startsWith(prefix)) continue;
                return new IncludeExcludeReason(false, "alias is explicitly included but matches excluded prefix: " + prefix);
            }
            return new IncludeExcludeReason(true, "alias is explicitly included.");
        }
        for (String prefix : includedPrefixes) {
            if (!alias.startsWith(prefix)) continue;
            if (excluded.contains(alias)) {
                return new IncludeExcludeReason(false, "alias matches included prefix: " + prefix + " but is also explicitly excluded.");
            }
            for (String excludePrefix : excludePrefixes) {
                if (!alias.startsWith(excludePrefix)) continue;
                return new IncludeExcludeReason(false, "alias matches included prefix: " + prefix + " but also matches excluded prefix: " + excludePrefix);
            }
            return new IncludeExcludeReason(true, "alias matches included prefix: " + prefix);
        }
        if (excluded.contains(alias)) {
            return new IncludeExcludeReason(false, "alias is explicitly excluded.");
        }
        for (String prefix : excludePrefixes) {
            if (!alias.startsWith(prefix)) continue;
            return new IncludeExcludeReason(false, "alias matches excluded prefix: " + prefix);
        }
        return new IncludeExcludeReason(false, "alias is not included and does not match any included prefix.");
    }

    public static String convertToAlias(String artifactId) {
        return artifactId.replaceAll("[^a-zA-Z0-9-]", "-").replaceAll("([a-z])([A-Z]+)", "$1-$2").toLowerCase();
    }

    private ModelBuilder createMavenModelBuilder() {
        DefaultModelProcessor modelProcessor = new DefaultModelProcessor();
        DefaultModelReader reader = new DefaultModelReader();
        DefaultModelLocator locator = new DefaultModelLocator();
        StringVisitorModelInterpolator modelInterpolator = new StringVisitorModelInterpolator();
        DefaultModelVersionProcessor versionProcessor = new DefaultModelVersionProcessor();
        DefaultModelNormalizer modelNormalizer = new DefaultModelNormalizer();
        DefaultModelValidator modelValidator = new DefaultModelValidator((ModelVersionProcessor)versionProcessor);
        DefaultProfileSelector profileSelector = new DefaultProfileSelector();
        DefaultSuperPomProvider superPomProvider = new DefaultSuperPomProvider();
        DefaultInheritanceAssembler inheritanceAssembler = new DefaultInheritanceAssembler();
        DefaultPathTranslator pathTranslator = new DefaultPathTranslator();
        DefaultUrlNormalizer urlNormalizer = new DefaultUrlNormalizer();
        DefaultModelUrlNormalizer modelUrlNormalizer = new DefaultModelUrlNormalizer();
        modelUrlNormalizer.setUrlNormalizer((UrlNormalizer)urlNormalizer);
        modelInterpolator.setVersionPropertiesProcessor((ModelVersionProcessor)versionProcessor);
        modelInterpolator.setPathTranslator((PathTranslator)pathTranslator);
        modelInterpolator.setUrlNormalizer((UrlNormalizer)urlNormalizer);
        modelProcessor.setModelReader((ModelReader)reader);
        modelProcessor.setModelLocator((ModelLocator)locator);
        superPomProvider.setModelProcessor((ModelProcessor)modelProcessor);
        DefaultModelBuilder modelBuilder = new DefaultModelBuilder();
        modelBuilder.setModelProcessor((ModelProcessor)modelProcessor);
        modelBuilder.setModelInterpolator((ModelInterpolator)modelInterpolator);
        modelBuilder.setModelNormalizer((ModelNormalizer)modelNormalizer);
        modelBuilder.setModelValidator((ModelValidator)modelValidator);
        modelBuilder.setProfileSelector((ProfileSelector)profileSelector);
        modelBuilder.setSuperPomProvider((SuperPomProvider)superPomProvider);
        modelBuilder.setInheritanceAssembler((InheritanceAssembler)inheritanceAssembler);
        modelBuilder.setModelUrlNormalizer((ModelUrlNormalizer)modelUrlNormalizer);
        DefaultModelPathTranslator modelPathTranslator = new DefaultModelPathTranslator();
        modelPathTranslator.setPathTranslator((PathTranslator)pathTranslator);
        modelBuilder.setModelPathTranslator((ModelPathTranslator)modelPathTranslator);
        ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator = new ProfileActivationFilePathInterpolator();
        profileActivationFilePathInterpolator.setPathTranslator((PathTranslator)pathTranslator);
        modelBuilder.setProfileActivationFilePathInterpolator(profileActivationFilePathInterpolator);
        DefaultDependencyManagementImporter depMgmtImporter = new DefaultDependencyManagementImporter();
        modelBuilder.setDependencyManagementImporter((DependencyManagementImporter)depMgmtImporter);
        DefaultDependencyManagementInjector depMgmtInjector = new DefaultDependencyManagementInjector();
        modelBuilder.setDependencyManagementInjector((DependencyManagementInjector)depMgmtInjector);
        DefaultReportingConverter reportingConverter = new DefaultReportingConverter();
        modelBuilder.setReportingConverter((ReportingConverter)reportingConverter);
        DefaultPluginManagementInjector pluginManagementInjector = new DefaultPluginManagementInjector();
        modelBuilder.setPluginManagementInjector((PluginManagementInjector)pluginManagementInjector);
        return modelBuilder;
    }

    private static void maybeWarn(Map<String, VersionCatalogConverter.AliasRecord> knownPluginAliases, String alias, String source) {
        String shortName;
        VersionCatalogConverter.AliasRecord record = knownPluginAliases.get(alias);
        boolean warn = true;
        if (source.startsWith("micronaut-") && source.contains("-bom") && alias.equals(shortName = source.substring(0, source.indexOf("-bom"))) && record.getSources().equals(Collections.singleton("BOM build file or main version catalog"))) {
            warn = false;
        }
        if (warn) {
            System.err.println("[Warning] While inlining " + source + ", alias '" + alias + "' is already defined in the catalog by " + String.valueOf(record.getSources()) + " so it won't be imported");
        }
    }

    private void registerCheckBomTask(Project project, PublishingExtension publishing, MicronautBomExtension bomExtension) {
        TaskProvider<PomChecker> checkBom = PomCheckerUtils.registerPomChecker("checkBom", project, publishing, task -> task.getSuppressions().convention((Object)bomExtension.getSuppressions()));
        project.getTasks().register("checkPom", task -> task.dependsOn(new Object[]{checkBom}));
    }

    private static Optional<VersionCatalog> findVersionCatalog(Project project, MicronautBomExtension bomExtension) {
        if (!((Boolean)bomExtension.getImportProjectCatalog().get()).booleanValue()) {
            return Optional.empty();
        }
        VersionCatalogsExtension versionCatalogsExtension = (VersionCatalogsExtension)project.getExtensions().findByType(VersionCatalogsExtension.class);
        return Optional.ofNullable(versionCatalogsExtension).flatMap(e -> e.find((String)bomExtension.getCatalogName().get()));
    }

    private void configureVersionCatalog(Project project, MicronautBomExtension bomExtension, String publishedName, String group, String mainProjectId) {
        if (((Boolean)bomExtension.getIncludeBomInCatalog().get()).booleanValue()) {
            CatalogPluginExtension catalog = (CatalogPluginExtension)project.getExtensions().getByType(CatalogPluginExtension.class);
            catalog.versionCatalog(vc -> {
                String mainModuleName = MicronautPlugin.moduleNameOf(mainProjectId);
                String versionName = mainModuleName.replace('-', '.');
                vc.library(publishedName, group, publishedName).versionRef(versionName);
                vc.version(versionName, String.valueOf(project.getVersion()));
            });
        }
        AdhocComponentWithVariants javaPlatform = (AdhocComponentWithVariants)project.getComponents().getByName("javaPlatform");
        javaPlatform.addVariantsFromConfiguration(project.getConfigurations().getByName("versionCatalogElements"), details -> {
            details.mapToMavenScope("compile");
            details.mapToOptional();
        });
    }

    private static void checkVersionConstraint(DependencyConstraint constraint) {
        VersionConstraint versionConstraint = constraint.getVersionConstraint();
        if (versionConstraint.getRequiredVersion().isEmpty() && versionConstraint.getPreferredVersion().isEmpty() && versionConstraint.getStrictVersion().isEmpty() && versionConstraint.getRejectedVersions().isEmpty()) {
            throw new InvalidUserDataException("A dependency constraint was added on '" + String.valueOf(constraint.getModule()) + "' without a version. This is invalid: a constraint must specify a version.");
        }
    }

    static class ProjectDescriptor {
        private final String path;
        private final String groupId;
        private final String artifactId;
        private final String version;

        static ProjectDescriptor fromProject(Project project) {
            return new ProjectDescriptor(project.getPath(), String.valueOf(project.getGroup()), MicronautPlugin.moduleNameOf(project.getName()), String.valueOf(project.getVersion()));
        }

        private ProjectDescriptor(String path, String groupId, String artifactId, String version) {
            this.path = path;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getPath() {
            return this.path;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }
    }

    private record IncludeExcludeReason(boolean included, String reason) {
    }

    private record InlinedDependency(String groupId, String artifactId, String versionProperty) {
    }
}

