/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.compat;

import io.micronaut.build.MicronautBuildExtension;
import io.micronaut.build.MicronautBuildExtensionPlugin;
import io.micronaut.build.MicronautPlugin;
import io.micronaut.build.MicronautPublishingPlugin;
import io.micronaut.build.compat.AbstractBinaryCompatibilityExtension;
import io.micronaut.build.compat.AcceptedApiChangesRule;
import io.micronaut.build.compat.BinaryCompatibibilityExtension;
import io.micronaut.build.compat.FindBaselineTask;
import io.micronaut.build.compat.InternalAnnotationCollectorRule;
import io.micronaut.build.compat.InternalAnnotationPostProcessRule;
import io.micronaut.build.compat.InternalMicronautTypeRule;
import io.micronaut.build.compat.JavaBridgeAndSyntheticRule;
import io.micronaut.build.compat.VersionCatalogCompatibilityCheck;
import io.micronaut.build.pom.MicronautBomExtension;
import io.micronaut.build.utils.ExternalURLService;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.champeau.gradle.japicmp.JapicmpTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.catalog.internal.TomlFileGenerator;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class MicronautBinaryCompatibilityPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(MicronautBuildExtensionPlugin.class);
        MicronautBuildExtension extension = (MicronautBuildExtension)project.getExtensions().getByType(MicronautBuildExtension.class);
        BinaryCompatibibilityExtension binaryCompatibility = (BinaryCompatibibilityExtension)((ExtensionAware)extension).getExtensions().create(BinaryCompatibibilityExtension.class, "binaryCompatibility", AbstractBinaryCompatibilityExtension.class, new Object[]{project.getProviders().provider(() -> String.valueOf(project.getVersion()))});
        binaryCompatibility.getAcceptedRegressionsFile().convention(project.getRootProject().getLayout().getProjectDirectory().file("config/accepted-api-changes.json"));
        project.getPlugins().withType(MicronautPublishingPlugin.class, unused -> {
            TaskContainer tasks = project.getTasks();
            ProviderFactory providers = project.getProviders();
            ConfigurationContainer rootProjectConfigurations = project.getRootProject().getConfigurations();
            project.getPluginManager().withPlugin("java-library", alsoUnused -> {
                TaskProvider<FindBaselineTask> baselineTask = this.registerFindBaselineTask(project, binaryCompatibility, tasks, providers);
                Provider<String> baseline = this.createBaselineProvider(binaryCompatibility, providers, baselineTask);
                String groupAndArtifact = MicronautBinaryCompatibilityPlugin.findGroupOf(project) + ":" + MicronautPlugin.moduleNameOf(project.getName());
                Configuration oldClasspath = rootProjectConfigurations.detachedConfiguration(new Dependency[0]);
                Configuration oldJar = rootProjectConfigurations.detachedConfiguration(new Dependency[0]);
                oldClasspath.getDependencies().addLater(baseline.map(version -> project.getDependencies().create((Object)(groupAndArtifact + ":" + version))));
                oldJar.getDependencies().addLater(baseline.map(version -> project.getDependencies().create((Object)(groupAndArtifact + ":" + version + "@jar"))));
                TaskProvider japicmpTask = tasks.register("japiCmp", JapicmpTask.class, task -> {
                    task.onlyIf(t -> (Boolean)binaryCompatibility.getEnabled().getOrElse((Object)true));
                    task.dependsOn(new Object[]{baselineTask});
                    task.getNewClasspath().from(new Object[]{project.getConfigurations().getByName("runtimeClasspath")});
                    task.getOldClasspath().from(new Object[]{oldClasspath});
                    task.getOldArchives().from(new Object[]{oldJar});
                    task.richReport(report -> {
                        report.getReportName().set((Object)("binary-compatibility-" + project.getName() + ".html"));
                        report.getTitle().set(baseline.map(version -> "Binary compatibility report for Micronaut " + project.getName() + " " + String.valueOf(project.getVersion()) + " against " + version));
                        report.getAddDefaultRules().set((Object)true);
                        report.addViolationTransformer(InternalMicronautTypeRule.class);
                        report.addViolationTransformer(JavaBridgeAndSyntheticRule.class);
                        report.addRule(InternalAnnotationCollectorRule.class);
                        report.addPostProcessRule(InternalAnnotationPostProcessRule.class);
                    });
                    task.getIgnoreMissingClasses().set((Object)true);
                });
                tasks.named("check").configure(task -> task.dependsOn(new Object[]{japicmpTask}));
                project.afterEvaluate(p -> {
                    Task jar = (Task)tasks.findByName("shadowJar");
                    if (jar == null) {
                        jar = tasks.getByName("jar");
                    }
                    Task effectiveJar = jar;
                    japicmpTask.configure(task -> {
                        File changesFile = ((RegularFile)binaryCompatibility.getAcceptedRegressionsFile().get()).getAsFile();
                        String changesFileRelativePath = changesFile.toPath().relativize(p.getBuildFile().toPath()).toString();
                        if (changesFile.exists()) {
                            task.getInputs().file((Object)changesFile).withPropertyName("accepted-api-changes").withPathSensitivity(PathSensitivity.NONE).optional(true);
                        }
                        task.getNewArchives().from(new Object[]{effectiveJar});
                        task.richReport(report -> report.addViolationTransformer(AcceptedApiChangesRule.class, Collections.singletonMap("changesFile", changesFileRelativePath)));
                    });
                });
            });
            project.getPluginManager().withPlugin("io.micronaut.build.internal.bom", alsoUnused -> {
                TaskProvider<FindBaselineTask> baselineTask = this.registerFindBaselineTask(project, binaryCompatibility, tasks, providers);
                Provider<String> baseline = this.createBaselineProvider(binaryCompatibility, providers, baselineTask);
                Configuration baselineConfig = rootProjectConfigurations.detachedConfiguration(new Dependency[0]);
                baselineConfig.getDependencies().addLater(baseline.map(version -> project.getDependencies().create((Object)(MicronautBinaryCompatibilityPlugin.findGroupOf(project) + ":" + MicronautPlugin.moduleNameOf(project.getName()) + ":" + version + "@toml"))));
                TaskProvider compatibilityCheckTaskProvider = tasks.register("checkVersionCatalogCompatibility", VersionCatalogCompatibilityCheck.class, task -> {
                    task.onlyIf(t -> (Boolean)binaryCompatibility.getEnabled().getOrElse((Object)true));
                    if (binaryCompatibility.getBaselineVersion().isPresent()) {
                        task.getBaseline().fileProvider(providers.provider(() -> ((Configuration)baselineConfig).getSingleFile()));
                    } else {
                        task.getBaseline().fileProvider(baselineTask.map(b -> baselineConfig.getSingleFile()));
                    }
                    task.getCurrent().convention(tasks.named("generateCatalogAsToml", TomlFileGenerator.class).flatMap(TomlFileGenerator::getOutputFile));
                    task.getReportFile().convention(project.getLayout().getBuildDirectory().file("reports/version-catalog-compatibility.txt"));
                    MicronautBomExtension bomExtension = (MicronautBomExtension)project.getExtensions().findByType(MicronautBomExtension.class);
                    task.getAcceptedVersionRegressions().convention(bomExtension.getSuppressions().getAcceptedVersionRegressions());
                    task.getAcceptedLibraryRegressions().convention(bomExtension.getSuppressions().getAcceptedLibraryRegressions());
                });
                tasks.named("check").configure(task -> task.dependsOn(new Object[]{compatibilityCheckTaskProvider}));
            });
        });
    }

    private static String findGroupOf(Project project) {
        ProviderFactory providers = project.getProviders();
        return (String)providers.gradleProperty("projectGroupId").orElse(providers.gradleProperty("projectGroup")).getOrElse((Object)project.getGroup().toString());
    }

    private Provider<String> createBaselineProvider(BinaryCompatibibilityExtension binaryCompatibility, ProviderFactory providers, TaskProvider<FindBaselineTask> baselineTask) {
        return binaryCompatibility.getBaselineVersion().orElse(providers.fileContents(baselineTask.flatMap(FindBaselineTask::getPreviousVersion)).getAsText().map(MicronautBinaryCompatibilityPlugin::readBaseline));
    }

    private TaskProvider<FindBaselineTask> registerFindBaselineTask(Project project, BinaryCompatibibilityExtension binaryCompatibility, TaskContainer tasks, ProviderFactory providers) {
        Provider<ExternalURLService> downloader = ExternalURLService.registerOn(project);
        return tasks.register("findBaseline", FindBaselineTask.class, task -> {
            task.onlyIf(t -> (Boolean)binaryCompatibility.getEnabled().getOrElse((Object)true) != false && !binaryCompatibility.getBaselineVersion().isPresent());
            task.usesService(downloader);
            task.getDownloader().set(downloader);
            task.getBaseRepository().convention((Object)"https://repo1.maven.org/maven2");
            task.getGroupId().convention(providers.provider(() -> project.getGroup().toString()));
            task.getArtifactId().convention(providers.provider(() -> MicronautBinaryCompatibilityPlugin.artifactIdOf(project)));
            task.getCurrentVersion().convention(providers.provider(() -> project.getVersion().toString()));
            task.getPreviousVersion().convention(project.getLayout().getBuildDirectory().file("baseline.txt"));
        });
    }

    private static String readBaseline(String baselineText) {
        List<String> lines = Arrays.asList(baselineText.split("[\\r\\n]+"));
        if (!lines.isEmpty()) {
            String baseline = lines.get(0);
            return baseline;
        }
        return "+";
    }

    private static String artifactIdOf(Project project) {
        String name = project.getName();
        if (name.startsWith("micronaut-")) {
            return name;
        }
        return "micronaut-" + name;
    }
}

