/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.docs;

import io.micronaut.build.docs.JavadocAggregationUtils;
import io.micronaut.build.docs.PrepareJavadocAggregationTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.javadoc.Javadoc;

public class AggregatedJavadocParticipantPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().withPlugin("java", unused -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            Configuration internalJavadocElements = this.createFilteredJavadocSourcesElements(project);
            Configuration javadocElementClasspath = this.createJavadocElementClasspath(project);
            TaskProvider prepareTask = project.getTasks().register("prepareJavadocAggregation", PrepareJavadocAggregationTask.class, task -> {
                TaskProvider javadoc = project.getTasks().named("javadoc", Javadoc.class);
                SourceSet sourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
                task.getSources().from(new Object[]{sourceSet.getAllJava().getSourceDirectories()});
                task.getIncludes().set(javadoc.map(SourceTask::getIncludes));
                task.getExcludes().set(javadoc.map(SourceTask::getExcludes));
                task.getOutputDir().set(project.getLayout().getBuildDirectory().dir("aggregation/javadoc"));
            });
            internalJavadocElements.getOutgoing().artifact((Object)prepareTask);
        });
    }

    private Configuration createJavadocElementClasspath(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        ProviderFactory providers = project.getProviders();
        return (Configuration)configurations.create("internalJavadocClasspathElements", conf -> {
            conf.setCanBeResolved(false);
            conf.setCanBeConsumed(true);
            Configuration compileClasspath = configurations.getByName("compileClasspath");
            AttributeContainer compileClasspathAttrs = compileClasspath.getAttributes();
            conf.extendsFrom(new Configuration[]{compileClasspath});
            conf.attributes(attrs -> compileClasspathAttrs.keySet().forEach(key -> {
                Attribute o = key;
                attrs.attributeProvider(o, providers.provider(() -> compileClasspathAttrs.getAttribute(o)));
                attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "aggregatedJavadocParticipantDependencies")));
            }));
        });
    }

    private Configuration createFilteredJavadocSourcesElements(Project project) {
        return (Configuration)project.getConfigurations().create("internalJavadocElements", conf -> {
            conf.setCanBeConsumed(true);
            conf.setCanBeResolved(false);
            ObjectFactory objects = project.getObjects();
            JavadocAggregationUtils.configureJavadocSourcesAggregationAttributes(objects, conf);
        });
    }
}

