/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.docs;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class PrepareJavadocAggregationTask
extends DefaultTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getSources();

    @Input
    public abstract SetProperty<String> getIncludes();

    @Input
    public abstract SetProperty<String> getExcludes();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDir();

    @Inject
    public abstract FileOperations getFileOperations();

    @TaskAction
    public void prepareJavadocAggregation() {
        this.getFileOperations().sync(spec -> {
            spec.from((Object)this.getSources(), file -> {
                Set includes;
                Set excludes = (Set)this.getExcludes().get();
                if (!excludes.isEmpty()) {
                    file.exclude((Iterable)excludes);
                }
                if (!(includes = (Set)this.getIncludes().get()).isEmpty()) {
                    file.include((Iterable)includes);
                }
            });
            spec.exclude(f -> f.getFile().isFile() && !f.getName().endsWith(".java"));
            spec.into((Object)this.getOutputDir().getAsFile());
        });
    }
}

