/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.utils;

import io.micronaut.build.utils.ComparableVersion;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionParser {
    public static Pattern SEMANTIC_VERSION = Pattern.compile("(?<major>\\d+)[.]?((?<minor>\\d+)([.]?(?<patch>\\d+)(?<extra>([.]\\d+)+)?)?)?[-.]?((?<qualifier>\\p{Alpha}+)(-?(?<qualifierVersion>\\d+))?)?");

    public static ComparableVersion parse(String version) {
        try {
            Object matchVersion = version.startsWith(".") ? "0" + version : version;
            Matcher matcher = SEMANTIC_VERSION.matcher((CharSequence)matchVersion);
            if (matcher.find()) {
                String major = matcher.group("major");
                String minor = matcher.group("minor");
                String patch = matcher.group("patch");
                String qualifier = matcher.group("qualifier");
                String qualifierVersion = matcher.group("qualifierVersion");
                String extraVersion = matcher.group("extra");
                return new ComparableVersion(version, VersionParser.asInt(major), VersionParser.asInt(minor), VersionParser.asInt(patch), qualifier, VersionParser.asInt(qualifierVersion), VersionParser.asList(extraVersion));
            }
            return new ComparableVersion(version, null, null, null, null, null, List.of());
        }
        catch (Exception ex) {
            return new ComparableVersion(version, null, null, null, null, null, List.of());
        }
    }

    private static Integer asInt(String value) {
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    private static List<Integer> asList(String extraVersions) {
        if (extraVersions == null) {
            return List.of();
        }
        return Arrays.stream(extraVersions.split("[.]")).filter(s -> !s.isEmpty()).map(Integer::parseInt).toList();
    }
}

