/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Base64;
import java.util.UUID;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class MavenCentralPublishTask
extends DefaultTask {
    @InputFile
    public abstract RegularFileProperty getBundle();

    @Input
    public abstract Property<String> getUsername();

    @Input
    public abstract Property<String> getPassword();

    @Input
    @Optional
    @Option(option="publishing-type", description="Configures the Maven Central publishing type.")
    public abstract Property<PublishingType> getPublishingType();

    public MavenCentralPublishTask() {
        this.setDescription("Publishes a bundle using Maven Central's Publisher API");
    }

    private String getBearerToken() {
        String usernamePassword = String.format("%s:%s", this.getUsername().get(), this.getPassword().get());
        return Base64.getEncoder().encodeToString(usernamePassword.getBytes(StandardCharsets.UTF_8));
    }

    @TaskAction
    public void uploadBundle() throws URISyntaxException, IOException, InterruptedException {
        String deploymentId;
        HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(60L)).build();
        Path file = ((RegularFile)this.getBundle().get()).getAsFile().toPath();
        String fileName = file.getFileName().toString();
        byte[] fileBytes = Files.readAllBytes(file);
        String boundary = UUID.randomUUID().toString();
        String bodyBuilder = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"bundle\"; filename=\"" + fileName + "\"\r\nContent-Type: application/octet-stream\r\n\r\n";
        byte[] prefix = bodyBuilder.getBytes(StandardCharsets.UTF_8);
        byte[] suffix = ("\r\n--" + boundary + "--\r\n").getBytes(StandardCharsets.UTF_8);
        byte[] requestBody = ByteBuffer.allocate(prefix.length + fileBytes.length + suffix.length).put(prefix).put(fileBytes).put(suffix).array();
        String uriBuilder = "https://central.sonatype.com/api/v1/publisher/upload?publishingType=" + String.valueOf(this.getPublishingType().getOrElse((Object)PublishingType.USER_MANAGED));
        HttpRequest request = HttpRequest.newBuilder().uri(new URI(uriBuilder)).header("Authorization", "Bearer " + this.getBearerToken()).header("Content-Type", "multipart/form-data; boundary=" + boundary).POST(HttpRequest.BodyPublishers.ofByteArray(requestBody)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        this.getLogger().lifecycle("Upload response: {} {}", new Object[]{response.statusCode(), response.body()});
        if (response.statusCode() >= 200 && response.statusCode() < 300) {
            deploymentId = response.body();
            if (deploymentId == null || deploymentId.isEmpty()) {
                throw new GradleException("Could not extract deploymentId from response: " + response.body());
            }
        } else {
            throw new GradleException("Unexpected status code: " + response.statusCode() + " (" + response.body() + ")");
        }
        this.verifyDeploymentStatus(client, deploymentId);
    }

    private void verifyDeploymentStatus(HttpClient client, String deploymentId) throws IOException, InterruptedException {
        String statusUrl = "https://central.sonatype.com/api/v1/publisher/status?id=" + deploymentId;
        this.getLogger().lifecycle("Checking deployment status for {}", new Object[]{deploymentId});
        int maxLookups = 100;
        while (--maxLookups >= 0) {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(statusUrl)).header("Authorization", "Bearer " + this.getBearerToken()).POST(HttpRequest.BodyPublishers.noBody()).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            this.getLogger().lifecycle("Status check: {} {}", new Object[]{response.statusCode(), response.body()});
            String body = response.body();
            if (response.statusCode() == 200) {
                if (body.contains("\"deploymentState\":\"COMPLETE\"") || body.contains("\"deploymentState\":\"PUBLISHED\"")) {
                    this.getLogger().lifecycle("Deployment {} completed successfully!", new Object[]{deploymentId});
                    return;
                }
                if (body.contains("\"deploymentState\":\"FAILED\"")) {
                    throw new GradleException("Deployment " + deploymentId + " failed: " + body);
                }
            } else if (response.statusCode() < 200 || response.statusCode() > 300) {
                this.getLogger().warn("Status check for deployment " + deploymentId + " failed with: " + body + ". This doesn't necessarily mean that deployment failed, please check status on https://central.sonatype.com/publishing");
                break;
            }
            Thread.sleep(30000L);
        }
    }

    public static enum PublishingType {
        AUTOMATIC,
        USER_MANAGED;

    }
}

