/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import io.micronaut.build.MavenCentralPublishTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Compression;
import org.gradle.api.tasks.bundling.Tar;

public class MicronautParentPublishingPlugin
implements Plugin<Project> {
    public void apply(Project p) {
        Project rootProject = p.getRootProject();
        if (!p.equals(rootProject)) {
            throw new IllegalStateException("This plugin should only be applied to the root project");
        }
        String version = String.valueOf(p.getVersion());
        if (version.endsWith("-SNAPSHOT")) {
            return;
        }
        TaskContainer tasks = rootProject.getTasks();
        ProjectLayout layout = rootProject.getLayout();
        Provider buildRepoDirectory = layout.getBuildDirectory().dir("repo");
        TaskProvider cleanRepo = tasks.register("cleanRepo", Delete.class, t -> t.delete(new Object[]{buildRepoDirectory}));
        TaskProvider<Tar> prepareBundle = MicronautParentPublishingPlugin.registerPrepareBundleTask(tasks, (TaskProvider<Delete>)cleanRepo, rootProject, layout, (Provider<Directory>)buildRepoDirectory);
        ProviderFactory providers = rootProject.getProviders();
        TaskProvider mavenPublish = tasks.register("publishToMavenCentral", MavenCentralPublishTask.class, task -> {
            task.getBundle().convention(prepareBundle.flatMap(AbstractArchiveTask::getArchiveFile));
            task.getUsername().convention(MicronautParentPublishingPlugin.envVarOrSystemProp(providers, "SONATYPE_USERNAME", "sonatypeOssUsername"));
            task.getPassword().convention(MicronautParentPublishingPlugin.envVarOrSystemProp(providers, "SONATYPE_PASSWORD", "sonatypeOssPassword"));
            task.getPublishingType().convention((Object)MavenCentralPublishTask.PublishingType.USER_MANAGED);
        });
    }

    private static TaskProvider<Tar> registerPrepareBundleTask(TaskContainer tasks, TaskProvider<Delete> cleanRepo, Project rootProject, ProjectLayout layout, Provider<Directory> buildRepoDirectory) {
        return tasks.register("prepareBundle", Tar.class, config -> {
            config.dependsOn(new Object[]{cleanRepo});
            config.mustRunAfter(new Object[]{cleanRepo});
            config.setCompression(Compression.GZIP);
            rootProject.getSubprojects().forEach(subproject -> {
                if (subproject.getTasks().getNames().contains("publishAllPublicationsToBuildRepository")) {
                    config.dependsOn(new Object[]{subproject.getPath() + ":publishAllPublicationsToBuildRepository"});
                }
            });
            config.getDestinationDirectory().convention(layout.getBuildDirectory().dir("maven-bundle"));
            config.getArchiveBaseName().convention((Object)(rootProject.getName() + "-maven-bundle"));
            config.getArchiveVersion().convention(rootProject.provider(() -> String.valueOf(rootProject.getVersion())));
            config.from(new Object[]{buildRepoDirectory});
        });
    }

    public static Provider<String> envVarOrSystemProp(ProviderFactory providers, String envVarName, String systemPropName) {
        return providers.environmentVariable(envVarName).orElse(providers.systemProperty(systemPropName));
    }
}

