/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import io.github.gradlenexus.publishplugin.NexusPublishExtension;
import io.micronaut.build.InternalStateCheckingService;
import io.micronaut.build.MicronautBuildSettingsExtension;
import io.micronaut.build.MicronautBuildSettingsPlugin;
import io.micronaut.build.MicronautDevelocityPlugin;
import io.micronaut.build.MicronautPlugin;
import io.micronaut.build.utils.ProviderUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Project;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.slf4j.Logger;

public class MicronautSharedSettingsPlugin
implements MicronautPlugin<Settings> {
    private static final Logger LOGGER = Logging.getLogger(MicronautSharedSettingsPlugin.class);
    public static final String NEXUS_STAGING_PROFILE_ID = "11bd7bc41716aa";
    private static final String STANDARDIZED_PROJECT_NAMES_WARNING = "=========================================================\nStandardized project names are disabled.\nConsider enabling them with\n    micronautBuild.useStandardizedProjectNames=true\nin settings.gradle.\n\nThen you will need to replace project dependencies from\n   project(':foo')\nto\n   project(':micronaut-foo')\nin your build scripts\n=========================================================";

    public void apply(Settings settings) {
        PluginManager pluginManager = settings.getPluginManager();
        settings.getGradle().getSharedServices().registerIfAbsent("internalStateCheckingService", InternalStateCheckingService.class, spec -> spec.parameters(p -> p.getRegisteredByProjectPlugin().set((Object)false))).get();
        pluginManager.apply(MicronautBuildSettingsPlugin.class);
        pluginManager.apply(MicronautDevelocityPlugin.class);
        MicronautBuildSettingsExtension buildSettingsExtension = (MicronautBuildSettingsExtension)settings.getExtensions().findByType(MicronautBuildSettingsExtension.class);
        this.applyPublishingPlugin(settings);
        this.configureProjectNames(settings, buildSettingsExtension);
        this.assertUniqueProjectNames(settings);
        settings.getGradle().beforeProject(p -> {
            ExtraPropertiesExtension extraProperties = p.getExtensions().getExtraProperties();
            if (!extraProperties.has("micronautVersion")) {
                extraProperties.set("micronautVersion", (Object)buildSettingsExtension.getMicronautVersion());
            }
        });
    }

    private void configureProjectNames(Settings settings, MicronautBuildSettingsExtension buildSettings) {
        settings.getGradle().settingsEvaluated(unused -> {
            Boolean useStandardProjectNames = (Boolean)buildSettings.getUseStandardizedProjectNames().get();
            if (Boolean.TRUE.equals(useStandardProjectNames)) {
                HashSet<ProjectDescriptor> visited = new HashSet<ProjectDescriptor>();
                this.configureProjectName(settings.getRootProject(), visited, buildSettings);
            } else {
                LOGGER.warn(STANDARDIZED_PROJECT_NAMES_WARNING);
            }
        });
    }

    private void configureProjectName(ProjectDescriptor project, Set<ProjectDescriptor> visited, MicronautBuildSettingsExtension extension) {
        if (visited.add(project)) {
            String path = project.getPath();
            if (!":".equals(path)) {
                Object name = project.getName();
                List ignoredNamePrefixes = (List)extension.getNonStandardProjectNamePrefixes().getOrElse(Collections.emptyList());
                List ignoredPathPrefixes = (List)extension.getNonStandardProjectPathPrefixes().getOrElse(Collections.emptyList());
                boolean nameIsNotIgnored = ignoredNamePrefixes.stream().noneMatch(((String)name)::startsWith);
                boolean pathIsNotIgnored = ignoredPathPrefixes.stream().noneMatch(path::startsWith);
                LOGGER.debug("[Automatic project renaming] Project name: {}, path: {}, nameIsNotIgnored: {}, pathIsNotIgnored: {}", new Object[]{name, path, nameIsNotIgnored, pathIsNotIgnored});
                if (nameIsNotIgnored && pathIsNotIgnored) {
                    name = "micronaut-" + (String)name;
                    project.setName((String)name);
                }
            }
            for (ProjectDescriptor child : project.getChildren()) {
                this.configureProjectName(child, visited, extension);
            }
        }
    }

    private void assertUniqueProjectNames(Settings settings) {
        settings.getGradle().projectsLoaded(gradle -> {
            HashMap duplicates = new HashMap();
            gradle.getRootProject().getAllprojects().forEach(project -> {
                String name = project.getName();
                if (duplicates.containsKey(name)) {
                    throw new InvalidUserCodeException("Warning: Project name '" + name + "' with path '" + project.getPath() + "' has the same name as project path '" + (String)duplicates.get(name) + "'. Please use unique names for projects.");
                }
                duplicates.put(name, project.getPath());
            });
        });
    }

    private void applyPublishingPlugin(Settings settings) {
        ProviderFactory providers = settings.getProviders();
        String ossUser = ProviderUtils.envOrSystemProperty(providers, "SONATYPE_USERNAME", "sonatypeOssUsername", "");
        String ossPass = ProviderUtils.envOrSystemProperty(providers, "SONATYPE_PASSWORD", "sonatypeOssPassword", "");
        settings.getGradle().projectsLoaded(gradle -> {
            String projectVersion = (String)ProviderUtils.fromGradleProperty(providers, settings.getRootDir(), "projectVersion").getOrElse((Object)"undefined");
            Provider<String> projectGroup = ProviderUtils.fromGradleProperty(providers, settings.getRootDir(), "projectGroup");
            gradle.getRootProject().getAllprojects().forEach(project -> {
                project.setVersion((Object)projectVersion);
                if (projectGroup.isPresent()) {
                    project.setGroup(projectGroup.get());
                }
            });
            if (!ossUser.isEmpty() && !ossPass.isEmpty()) {
                this.configureNexusPublishing((Gradle)gradle, ossUser, ossPass);
            }
        });
    }

    private void configureNexusPublishing(Gradle gradle, String ossUser, String ossPass) {
        Project rootProject = gradle.getRootProject();
        rootProject.getPlugins().apply("io.github.gradle-nexus.publish-plugin");
        NexusPublishExtension nexusPublish = (NexusPublishExtension)rootProject.getExtensions().getByType(NexusPublishExtension.class);
        String version = String.valueOf(rootProject.getVersion());
        if ("unspecified".equals(version)) {
            throw new RuntimeException("The root project doesn't define a version. Please set the version in the root project.");
        }
        nexusPublish.getRepositoryDescription().set((Object)(String.valueOf(rootProject.getGroup()) + ":" + rootProject.getName() + ":" + version));
        nexusPublish.getUseStaging().convention((Object)(!version.endsWith("-SNAPSHOT") ? 1 : 0));
        nexusPublish.repositories(repos -> repos.create("sonatype", repo -> {
            repo.getAllowInsecureProtocol().convention(rootProject.getProviders().systemProperty("allowInsecurePublishing").map(Boolean::parseBoolean).orElse((Object)false));
            repo.getUsername().set((Object)ossUser);
            repo.getPassword().set((Object)ossPass);
            repo.getNexusUrl().set((Object)MicronautSharedSettingsPlugin.uri(ProviderUtils.envOrSystemProperty(rootProject.getProviders(), "SONATYPE_REPO_URI", "sonatypeRepoUri", "https://ossrh-staging-api.central.sonatype.com/service/local/")));
            repo.getSnapshotRepositoryUrl().set((Object)MicronautSharedSettingsPlugin.uri(ProviderUtils.envOrSystemProperty(rootProject.getProviders(), "SONATYPE_SNAPSHOT_REPO_URI", "sonatypeSnapshotsRepoUri", "https://central.sonatype.com/repository/maven-snapshots/")));
            repo.getStagingProfileId().set((Object)NEXUS_STAGING_PROFILE_ID);
        }));
    }

    private static URI uri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

