/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.sonatype.gradle.plugins.scan.ossindex.OssIndexPluginExtension;

public abstract class SonatypeConfigurationPlugin
implements Plugin<Project> {
    @Inject
    protected abstract ProviderFactory getProviders();

    public void apply(Project project) {
        project.getPluginManager().apply("org.sonatype.gradle.plugins.scan");
        Provider<String> ossIndexUsername = this.envVarOrSystemProperty("OSS_INDEX_USERNAME", "ossIndexUsername");
        Provider<String> ossIndexPassword = this.envVarOrSystemProperty("OSS_INDEX_PASSWORD", "ossIndexPassword");
        if (ossIndexUsername.isPresent() && ossIndexPassword.isPresent()) {
            OssIndexPluginExtension ossIndex = (OssIndexPluginExtension)project.getExtensions().getByType(OssIndexPluginExtension.class);
            ossIndex.setUsername((String)ossIndexUsername.get());
            ossIndex.setPassword((String)ossIndexPassword.get());
        }
    }

    private Provider<String> envVarOrSystemProperty(String envVar, String property) {
        return this.getProviders().environmentVariable(envVar).orElse(this.getProviders().systemProperty(property));
    }
}

