/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.catalogs.internal;

import io.micronaut.build.catalogs.internal.RichVersion;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserCodeException;

public class RichVersionParser {
    public RichVersion parse(@Nullable String version) {
        if (version == null) {
            return RichVersion.EMPTY;
        }
        int idx = version.indexOf("!!");
        if (idx == 0) {
            throw new InvalidUserCodeException("The strict version modifier (!!) must be appended to a valid version number");
        }
        if (idx > 0) {
            String strictly = version.substring(0, idx);
            String prefer = version.substring(idx + 2);
            return new RichVersion(null, strictly, prefer, null, false);
        }
        return new RichVersion(version, null, null, null, false);
    }
}

