/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.catalogs.tasks;

import io.micronaut.build.catalogs.internal.LenientVersionCatalogParser;
import io.micronaut.build.catalogs.internal.Library;
import io.micronaut.build.catalogs.internal.RichVersion;
import io.micronaut.build.catalogs.internal.Status;
import io.micronaut.build.catalogs.internal.VersionCatalogTomlModel;
import io.micronaut.build.catalogs.internal.VersionModel;
import io.micronaut.build.compat.MavenMetadataVersionHelper;
import io.micronaut.build.utils.ComparableVersion;
import io.micronaut.build.utils.Downloader;
import io.micronaut.build.utils.VersionParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class VersionCatalogUpdate
extends DefaultTask {
    @InputDirectory
    public abstract DirectoryProperty getCatalogsDirectory();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectory();

    @Input
    public abstract ListProperty<String> getRejectedQualifiers();

    @Input
    public abstract SetProperty<String> getIgnoredModules();

    @Input
    public abstract Property<Boolean> getAllowMajorUpdates();

    @Input
    public abstract Property<Boolean> getAllowMinorUpdates();

    @Input
    public abstract MapProperty<String, String> getRejectedVersionsPerModule();

    @Internal
    public abstract Property<Boolean> getFailWhenNoVersionFound();

    @Input
    public abstract ListProperty<URI> getRepositoryBaseUris();

    public VersionCatalogUpdate() {
        this.getRepositoryBaseUris().convention(this.getProject().getRepositories().stream().filter(MavenArtifactRepository.class::isInstance).map(MavenArtifactRepository.class::cast).map(MavenArtifactRepository::getUrl).toList());
    }

    protected void processCandidate(CandidateDetails details) {
    }

    @TaskAction
    void updateCatalogs() throws IOException, InterruptedException {
        Set catalogs = this.getCatalogsDirectory().getAsFileTree().matching(pattern -> pattern.include(new String[]{"*.versions.toml"})).getFiles();
        File outputDir = (File)this.getOutputDirectory().getAsFile().get();
        if (outputDir.isDirectory() || outputDir.mkdirs()) {
            if (catalogs.isEmpty()) {
                this.getLogger().info("Didn't find any version catalog to process");
            }
            for (File catalog : catalogs) {
                this.getLogger().info("Processing {}", (Object)catalog);
                this.updateCatalog(catalog, new File(outputDir, catalog.getName()), ((RegularFile)this.getOutputDirectory().file(catalog.getName() + "-updates.log").get()).getAsFile());
            }
        } else {
            throw new GradleException("Unable to create output directory " + String.valueOf(outputDir));
        }
    }

    private static boolean supportsUpdate(RichVersion richVersion) {
        return richVersion != null && richVersion.getRequire() != null && richVersion.getStrictly() == null && richVersion.getPrefer() == null && !richVersion.isRejectAll() && richVersion.getRejectedVersions() == null;
    }

    private void updateCatalog(File inputCatalog, File outputCatalog, File logFile) throws IOException, InterruptedException {
        try (PrintWriter log = VersionCatalogUpdate.newPrintWriter(logFile);){
            log.println("Processing catalog file " + String.valueOf(inputCatalog));
            LenientVersionCatalogParser parser = new LenientVersionCatalogParser();
            try (FileInputStream is = new FileInputStream(inputCatalog);){
                parser.parse(is);
            }
            List<String> lines = Files.readAllLines(inputCatalog.toPath(), StandardCharsets.UTF_8);
            boolean allowMajorUpdate = (Boolean)this.getAllowMajorUpdates().get();
            boolean allowMinorUpdate = (Boolean)this.getAllowMinorUpdates().get();
            VersionCatalogTomlModel model = parser.getModel();
            DependencyHandler dependencies = this.getProject().getDependencies();
            ConfigurationContainer configurations = this.getProject().getConfigurations();
            Configuration detachedConfiguration = configurations.detachedConfiguration(new Dependency[0]);
            detachedConfiguration.setCanBeConsumed(false);
            detachedConfiguration.setCanBeResolved(true);
            detachedConfiguration.setTransitive(false);
            detachedConfiguration.getResolutionStrategy().cacheDynamicVersionsFor(0, TimeUnit.MINUTES);
            List<Pattern> rejectedQualifiers = ((List)this.getRejectedQualifiers().get()).stream().map(qualifier -> Pattern.compile("(?i)" + qualifier + "[.\\d-+]*")).toList();
            Map rejectedVersionsPerModule = (Map)this.getRejectedVersionsPerModule().get();
            Set ignoredModules = (Set)this.getIgnoredModules().get();
            List<DefaultCandidateDetails> allDetails = ((Stream)model.getLibrariesTable().stream().filter(library -> !ignoredModules.contains(library.getModule())).filter(library -> library.getVersion().getReference() != null || !VersionCatalogUpdate.requiredVersionOf(library).isEmpty()).parallel()).map(library -> this.findBestVersion(model, log, (Library)library, rejectedQualifiers, rejectedVersionsPerModule, allowMajorUpdate, allowMinorUpdate)).filter(Optional::isPresent).map(Optional::get).toList();
            ArrayList<CallSite> unresolved = new ArrayList<CallSite>();
            for (DefaultCandidateDetails details : allDetails) {
                ComparableVersion latest;
                ComparableVersion comparableVersion = latest = details.acceptedVersion != null ? details.acceptedVersion : details.fallbackVersion;
                if (latest != null) {
                    Library library2 = details.library;
                    VersionModel version = library2.getVersion();
                    String reference = version.getReference();
                    if (reference != null) {
                        model.findVersion(reference).ifPresent(referencedVersion -> {
                            RichVersion richVersion = referencedVersion.getVersion();
                            if (VersionCatalogUpdate.supportsUpdate(richVersion)) {
                                String require = richVersion.getRequire();
                                if (!Objects.equals(require, latest.fullVersion())) {
                                    log.println("Updating required version from " + require + " to " + String.valueOf(latest));
                                    String lookup = "(" + reference + "\\s*=\\s*[\"'])(.+?)([\"'])";
                                    int lineNb = referencedVersion.getPosition().line() - 1;
                                    String line = (String)lines.get(lineNb);
                                    Matcher m = Pattern.compile(lookup).matcher(line);
                                    if (m.find()) {
                                        lines.set(lineNb, m.replaceAll("$1" + String.valueOf(latest) + "$3"));
                                    } else {
                                        log.println("Line " + lineNb + " contains unsupported notation, automatic updating failed");
                                    }
                                }
                            } else {
                                log.println("[" + details.module + "] version '" + reference + "' uses a notation which is not supported for automatic upgrades yet.");
                            }
                        });
                        continue;
                    }
                    Object lookup = "(version\\s*=\\s*[\"'])(.+?)([\"'])";
                    int lineNb = library2.getPosition().line() - 1;
                    String line = lines.get(lineNb);
                    Matcher m = Pattern.compile((String)lookup).matcher(line);
                    if (m.find()) {
                        lines.set(lineNb, m.replaceAll("$1" + String.valueOf(latest) + "$3"));
                        continue;
                    }
                    lookup = "(\\s*=\\s*[\"'])(" + library2.getGroup() + "):(" + library2.getName() + "):(.+?)([\"'])";
                    m = Pattern.compile((String)lookup).matcher(line);
                    if (m.find()) {
                        lines.set(lineNb, m.replaceAll("$1$2:$3:" + String.valueOf(latest) + "$5"));
                        continue;
                    }
                    log.println("Line " + lineNb + " contains unsupported notation, automatic updating failed");
                    continue;
                }
                unresolved.add((CallSite)((Object)("Cannot resolve module " + details.module)));
            }
            this.getLogger().lifecycle("Writing updated catalog at " + String.valueOf(outputCatalog));
            try (PrintWriter writer = VersionCatalogUpdate.newPrintWriter(outputCatalog);){
                lines.forEach(writer::println);
            }
            if (!unresolved.isEmpty()) {
                String errors = unresolved.stream().map(s -> "    - " + s).collect(Collectors.joining("\n"));
                boolean fail = (Boolean)this.getFailWhenNoVersionFound().getOrElse((Object)Boolean.TRUE);
                if (fail) {
                    throw new GradleException("Some modules couldn't be updated because of the following reasons:" + errors);
                }
                this.getLogger().lifecycle("Some modules had all versions rejected or no candidate, check the logs for details");
                log.println(errors);
            }
        }
    }

    private Optional<DefaultCandidateDetails> findBestVersion(VersionCatalogTomlModel model, PrintWriter log, Library library, List<Pattern> rejectedQualifiers, Map<String, String> rejectedVersionsPerModule, boolean allowMajorUpdates, boolean allowMinorUpdates) {
        String reference = library.getVersion().getReference();
        String version = reference != null ? (String)model.findVersion(reference).map(VersionModel::getVersion).map(RichVersion::getRequire).orElse(null) : library.getVersion().getVersion().getRequire();
        if (version != null) {
            String group = library.getGroup();
            String name = library.getName();
            ComparableVersion currentVersion = VersionParser.parse(version);
            String module = group + ":" + name;
            DefaultCandidateDetails candidateDetails = new DefaultCandidateDetails(log, library, currentVersion);
            List<ComparableVersion> comparableVersions = this.fetchVersions(group, name);
            for (ComparableVersion candidateVersion : comparableVersions) {
                Pattern exclusion;
                String rejected;
                candidateDetails.prepare(candidateVersion);
                Status candidateStatus = Status.detectStatus(candidateVersion.fullVersion());
                Status sourceStatus = Status.detectStatus(currentVersion.fullVersion());
                if (!candidateStatus.isAsStableOrMoreStableThan(sourceStatus)) {
                    candidateDetails.rejectCandidate("it's not as stable as " + String.valueOf((Object)sourceStatus));
                }
                if (candidateVersion.qualifier().isPresent()) {
                    String candidateQualifier = candidateVersion.qualifier().get();
                    rejectedQualifiers.forEach(qualifier -> {
                        if (qualifier.matcher(candidateQualifier).find()) {
                            candidateDetails.rejectCandidate("of qualifier '" + String.valueOf(qualifier) + "'");
                        }
                    });
                }
                if ((rejected = rejectedVersionsPerModule.get(module)) != null && (exclusion = Pattern.compile(rejected)).matcher(candidateVersion.fullVersion()).find()) {
                    candidateDetails.rejectCandidate("of configuration. It matches regular expression: " + rejected);
                }
                VersionCatalogUpdate.maybeRejectVersionByMinorMajor(allowMajorUpdates, allowMinorUpdates, currentVersion, candidateVersion, candidateDetails);
                if (!candidateDetails.isRejected()) {
                    this.processCandidate(candidateDetails);
                }
                if (candidateDetails.isAccepted()) break;
                if (candidateDetails.isRejected() || candidateDetails.hasFallback()) continue;
                candidateDetails.acceptCandidate();
                break;
            }
            return Optional.of(candidateDetails);
        }
        return Optional.empty();
    }

    public List<ComparableVersion> fetchVersions(String groupId, String artifactId) {
        List uris = (List)this.getRepositoryBaseUris().get();
        for (URI baseUrl : uris) {
            List<ComparableVersion> list;
            URI metadata = URI.create(baseUrl.toString() + "/" + groupId.replace('.', '/') + "/" + artifactId + "/maven-metadata.xml");
            byte[] data = Downloader.doDownload(metadata);
            if (data == null || (list = MavenMetadataVersionHelper.findReleasesFrom(data).stream().sorted(Collections.reverseOrder()).toList()).isEmpty()) continue;
            return list;
        }
        return List.of();
    }

    static void maybeRejectVersionByMinorMajor(boolean allowMajorUpdate, boolean allowMinorUpdate, ComparableVersion currentVersion, ComparableVersion candidateVersion, CandidateDetails details) {
        if (!allowMajorUpdate || !allowMinorUpdate) {
            int candidateMinor;
            int minor;
            int candidateMajor;
            int major = currentVersion.major().orElse(0);
            if (major != (candidateMajor = candidateVersion.major().orElse(0).intValue()) && !allowMajorUpdate) {
                details.rejectCandidate("it's not the same major version as current : " + String.valueOf(currentVersion) + " (current) vs " + String.valueOf(candidateVersion) + " (candidate)");
            } else if (major == candidateMajor && !allowMinorUpdate && (minor = currentVersion.minor().orElse(0).intValue()) != (candidateMinor = candidateVersion.minor().orElse(0).intValue())) {
                details.rejectCandidate("it's not the same minor version : " + String.valueOf(currentVersion) + " (current) vs " + String.valueOf(candidateVersion) + " (candidate)");
            }
        }
    }

    private static String requiredVersionOf(Library library) {
        String require;
        RichVersion version = library.getVersion().getVersion();
        if (version != null && (require = version.getRequire()) != null) {
            return require;
        }
        return "";
    }

    private static PrintWriter newPrintWriter(File file) throws FileNotFoundException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
    }

    private static class DefaultCandidateDetails
    implements CandidateDetails {
        private final Library library;
        private final PrintWriter log;
        private final String module;
        private final ComparableVersion currentVersion;
        private ComparableVersion candidateVersion;
        private ComparableVersion acceptedVersion;
        private ComparableVersion fallbackVersion;
        private boolean rejected;

        private DefaultCandidateDetails(PrintWriter log, Library library, ComparableVersion currentVersion) {
            this.log = log;
            this.library = library;
            this.module = library.getGroup() + ":" + library.getName();
            this.currentVersion = currentVersion;
        }

        @Override
        public String getModule() {
            return this.module;
        }

        @Override
        public ComparableVersion getCurrentVersion() {
            return this.currentVersion;
        }

        @Override
        public ComparableVersion getCandidateVersion() {
            return this.candidateVersion;
        }

        @Override
        public void acceptAsFallback() {
            if (this.fallbackVersion == null) {
                this.fallbackVersion = this.candidateVersion;
                String message = "[" + this.module + "] Accepting version '" + String.valueOf(this.candidateVersion) + "' as fallback in case no better match is found";
                this.log.println(message);
            }
            this.rejected = true;
        }

        @Override
        public void rejectCandidate(String reason) {
            this.rejected = true;
            String message = "[" + this.module + "] Rejecting version '" + String.valueOf(this.candidateVersion) + "' because " + reason;
            this.log.println(message);
        }

        @Override
        public void acceptCandidate() {
            this.acceptedVersion = this.candidateVersion;
            String message = this.currentVersion.equals(this.candidateVersion) ? "[" + this.module + "] Current version " + String.valueOf(this.currentVersion) + " is suitable" : "[" + this.module + "] Accepting candidate " + String.valueOf(this.candidateVersion) + " as replacement to " + String.valueOf(this.currentVersion);
            this.log.println(message);
        }

        public boolean isRejected() {
            return this.rejected;
        }

        public boolean hasFallback() {
            return this.fallbackVersion != null;
        }

        public boolean isAccepted() {
            return this.acceptedVersion != null;
        }

        public void prepare(ComparableVersion candidateVersion) {
            this.candidateVersion = candidateVersion;
            this.rejected = false;
        }
    }

    protected static interface CandidateDetails {
        public String getModule();

        public ComparableVersion getCurrentVersion();

        public ComparableVersion getCandidateVersion();

        public void acceptAsFallback();

        public void rejectCandidate(String var1);

        public void acceptCandidate();
    }
}

