/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.docs.props;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class MergeConfigurationReferenceTask
extends DefaultTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public abstract ConfigurableFileCollection getInputFiles();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @TaskAction
    protected void merge() throws FileNotFoundException, UnsupportedEncodingException {
        Set inputFiles = this.getInputFiles().getAsFileTree().getFiles();
        File outputFile = (File)this.getOutputFile().getAsFile().get();
        File parentFile = outputFile.getParentFile();
        parentFile.mkdirs();
        try (PrintWriter prn = new PrintWriter(outputFile, StandardCharsets.UTF_8.name());){
            inputFiles.stream().sorted(Comparator.comparing(File::getName)).forEachOrdered(file -> {
                String header = "=== " + Arrays.stream(file.getName().replace(".adoc", "").split("-")).map(token -> Character.toUpperCase(token.charAt(0)) + token.substring(1)).collect(Collectors.joining(" "));
                prn.print(header);
                prn.print('\n');
                try {
                    Files.readAllLines(file.toPath()).forEach(line -> {
                        prn.print((String)line);
                        prn.print('\n');
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                prn.write(10);
            });
        }
    }
}

