/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.graalvm;

import io.micronaut.build.MicronautBuildExtension;
import io.micronaut.build.MicronautBuildExtensionPlugin;
import io.micronaut.build.MicronautPlugin;
import io.micronaut.build.graalvm.NativeImagePropertiesExtension;
import io.micronaut.build.graalvm.NativePropertiesWriter;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;

public class NativeImageSupportPlugin
implements MicronautPlugin<Project> {
    public static final String NATIVE_IMAGE_PROPERTIES_EXTENSION_NAME = "nativeImageProperties";
    public static final String GENERATE_NATIVE_IMAGE_PROPERTIES_TASK_NAME = "generateNativeImageProperties";

    public void apply(Project project) {
        PluginManager pluginManager = project.getPluginManager();
        pluginManager.apply(MicronautBuildExtensionPlugin.class);
        MicronautBuildExtension micronautBuildExtension = (MicronautBuildExtension)project.getExtensions().findByType(MicronautBuildExtension.class);
        NativeImagePropertiesExtension nativeImageExtension = (NativeImagePropertiesExtension)((ExtensionAware)micronautBuildExtension).getExtensions().create(NATIVE_IMAGE_PROPERTIES_EXTENSION_NAME, NativeImagePropertiesExtension.class, new Object[0]);
        nativeImageExtension.getEnabled().convention((Object)false);
        TaskProvider generateNativeImageProperties = project.getTasks().register(GENERATE_NATIVE_IMAGE_PROPERTIES_TASK_NAME, NativePropertiesWriter.class, task -> {
            task.onlyIf(t -> (Boolean)nativeImageExtension.getEnabled().get());
            task.getOutputDirectory().convention(project.getLayout().getBuildDirectory().dir("generated/resources/native-image-properties"));
            task.getContents().convention(nativeImageExtension.getContents());
            task.getInitializeAtRuntime().convention(nativeImageExtension.getInitializeAtRuntime());
            task.getInitializeAtBuildtime().convention(nativeImageExtension.getInitializeAtBuildtime());
            task.getFeatures().convention(nativeImageExtension.getFeatures());
            task.getGroupId().convention(project.getProviders().provider(() -> String.valueOf(project.getGroup())));
            task.getArtifactId().convention(project.getProviders().provider(() -> MicronautPlugin.moduleNameOf(project.getName())));
        });
        pluginManager.withPlugin("java", unused -> {
            SourceSetContainer sourceSets = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
            ((SourceSet)sourceSets.getByName("main")).getResources().srcDir((Object)generateNativeImageProperties);
        });
    }
}

