/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.pom;

import io.micronaut.build.MicronautPlugin;
import io.micronaut.build.pom.PomChecker;
import java.util.function.Consumer;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public abstract class PomCheckerUtils {
    private PomCheckerUtils() {
    }

    public static TaskProvider<PomChecker> registerPomChecker(String taskName, Project project, PublishingExtension publishing, Consumer<? super PomChecker> configuration) {
        TaskContainer tasks = project.getTasks();
        TaskProvider pomChecker = tasks.register(taskName, PomChecker.class, task -> {
            String repoUrl = "https://repo.maven.apache.org/maven2/";
            ArtifactRepository repo = (ArtifactRepository)publishing.getRepositories().findByName("Build");
            if (repo instanceof MavenArtifactRepository) {
                repoUrl = ((MavenArtifactRepository)repo).getUrl().toString();
                try {
                    repoUrl = project.relativePath((Object)repoUrl);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            task.getRepositories().add((Object)repoUrl);
            project.getRepositories().forEach(r -> {
                if (r instanceof MavenArtifactRepository) {
                    task.getRepositories().add((Object)((MavenArtifactRepository)r).getUrl().toString());
                }
            });
            task.getPomFile().fileProvider(tasks.named("generatePomFileForMavenPublication", GenerateMavenPom.class).map(GenerateMavenPom::getDestination));
            String version = PomCheckerUtils.assertVersion(project);
            task.getPomCoordinates().set((Object)(String.valueOf(project.getGroup()) + ":" + MicronautPlugin.moduleNameOf(project.getName()) + ":" + version));
            task.getReportDirectory().set(project.getLayout().getBuildDirectory().dir("reports/" + taskName));
            task.getPomsDirectory().set(project.getLayout().getBuildDirectory().dir("poms"));
            ProviderFactory providers = project.getProviders();
            Provider failOnSnapshots = providers.systemProperty("micronaut.fail.on.snapshots").orElse(providers.environmentVariable("MICRONAUT_FAIL_ON_SNAPSHOTS")).map(Boolean::parseBoolean).orElse(providers.provider(() -> PomCheckerUtils.isPreReleaseCheck(project) || !version.endsWith("-SNAPSHOT")));
            task.getFailOnSnapshots().set(failOnSnapshots);
            task.getFailOnError().set((Object)true);
            configuration.accept((PomChecker)((Object)task));
        });
        tasks.named("check").configure(task -> task.dependsOn(new Object[]{pomChecker}));
        tasks.named("preReleaseCheck").configure(task -> task.dependsOn(new Object[]{pomChecker}));
        return pomChecker;
    }

    private static boolean isPreReleaseCheck(Project project) {
        return project.getGradle().getTaskGraph().getAllTasks().stream().anyMatch(t -> t.getName().equals("preReleaseCheck"));
    }

    public static String assertVersion(Project p) {
        String version = String.valueOf(p.getVersion());
        String path = p.getPath();
        return PomCheckerUtils.assertVersion(version, path);
    }

    public static String assertVersion(String version, String projectPath) {
        if (version.isEmpty() || "unspecified".equals(version)) {
            throw new GradleException("Version of " + projectPath + " is undefined!");
        }
        return version;
    }
}

