/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import me.champeau.gradle.igp.GitIncludeExtension;
import me.champeau.gradle.igp.IncludedGitRepo;
import org.gradle.api.file.RegularFile;
import org.gradle.process.ExecOperations;

public class IncludedBuildSupport {
    public static void configureIncludedBuildCatalogPublication(ExecOperations execOperations, IncludedGitRepo.CodeReadyEvent evt, GitIncludeExtension gitIncludeExtension, String githubProjectName) {
        File checkoutDirectory = evt.getCheckoutDirectory();
        Path digestFile = ((RegularFile)gitIncludeExtension.getCheckoutsDirectory().file("catalog-" + githubProjectName + ".sha1").get()).getAsFile().toPath();
        File catalogFile = new File(checkoutDirectory, "gradle/libs.versions.toml");
        if (catalogFile.exists()) {
            try {
                String previousDigest = Files.exists(digestFile, new LinkOption[0]) ? Files.readString(digestFile) : "";
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                try (DigestInputStream stream = new DigestInputStream(new FileInputStream(catalogFile), digest);){
                    byte[] bytes = new byte[1024];
                    while (stream.read(bytes) > 0) {
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                String newDigest = IncludedBuildSupport.toHex(digest.digest());
                Files.createDirectories(digestFile.getParent(), new FileAttribute[0]);
                Files.writeString(digestFile, (CharSequence)newDigest, new OpenOption[0]);
                if (!newDigest.equals(previousDigest)) {
                    System.out.println("Catalog changed for " + githubProjectName + ": triggering build.");
                    execOperations.exec(spec -> {
                        spec.workingDir((Object)checkoutDirectory);
                        spec.commandLine(new Object[]{System.getProperty("os.name").toLowerCase(Locale.US).contains("windows") ? "gradlew.bat" : "./gradlew"});
                        spec.args(new Object[]{"-q", "generateCatalogAsToml", "--no-daemon"});
                    });
                } else {
                    System.out.println("Catalog unchanged for " + githubProjectName + ".");
                }
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String toHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }
}

