/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import com.gradle.CommonCustomUserDataGradlePlugin;
import com.gradle.enterprise.gradleplugin.GradleEnterpriseExtension;
import com.gradle.enterprise.gradleplugin.GradleEnterprisePlugin;
import com.gradle.scan.plugin.BuildScanExtension;
import io.micronaut.build.BuildEnvironment;
import io.micronaut.build.MicronautBuildSettingsExtension;
import io.micronaut.build.MicronautBuildSettingsPlugin;
import io.micronaut.build.utils.ProviderUtils;
import java.lang.reflect.InvocationTargetException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.caching.configuration.BuildCacheConfiguration;
import org.gradle.caching.http.HttpBuildCache;
import org.nosphere.gradle.github.ActionsPlugin;

public class MicronautGradleEnterprisePlugin
implements Plugin<Settings> {
    private static final String[] SAFE_TO_LOG_ENV_VARIABLES = new String[]{"PREDICTIVE_TEST_SELECTION"};

    public void apply(Settings settings) {
        PluginManager pluginManager = settings.getPluginManager();
        pluginManager.apply(MicronautBuildSettingsPlugin.class);
        pluginManager.apply(GradleEnterprisePlugin.class);
        pluginManager.apply(CommonCustomUserDataGradlePlugin.class);
        Provider projectGroup = settings.getProviders().gradleProperty("projectGroup");
        if (projectGroup.isPresent() && !((String)projectGroup.get()).startsWith("io.micronaut")) {
            return;
        }
        GradleEnterpriseExtension ge = (GradleEnterpriseExtension)settings.getExtensions().getByType(GradleEnterpriseExtension.class);
        MicronautBuildSettingsExtension micronautBuildSettingsExtension = (MicronautBuildSettingsExtension)settings.getExtensions().getByType(MicronautBuildSettingsExtension.class);
        this.configureGradleEnterprise(settings, ge, micronautBuildSettingsExtension);
    }

    private void configureGradleEnterprise(Settings settings, GradleEnterpriseExtension ge, MicronautBuildSettingsExtension micronautBuildSettingsExtension) {
        ProviderFactory providers = settings.getProviders();
        Provider publishScanOnDemand = providers.gradleProperty("publishScanOnDemand").map(Boolean::parseBoolean).orElse((Object)false);
        boolean isCI = ProviderUtils.guessCI(providers);
        this.configureBuildScansPublishing(ge, isCI, (Provider<Boolean>)publishScanOnDemand);
        settings.getGradle().projectsLoaded(MicronautGradleEnterprisePlugin::applyGitHubActionsPlugin);
        this.tagWithJavaDetails(ge, providers);
        if (((Boolean)providers.gradleProperty("org.gradle.caching").map(Boolean::parseBoolean).orElse((Object)true).get()).booleanValue()) {
            settings.getGradle().settingsEvaluated(lateSettings -> {
                BuildCacheConfiguration buildCache = settings.getBuildCache();
                boolean localEnabled = (Boolean)micronautBuildSettingsExtension.getUseLocalCache().get();
                boolean remoteEnabled = (Boolean)micronautBuildSettingsExtension.getUseRemoteCache().get();
                boolean push = (Boolean)MicronautBuildSettingsExtension.booleanProvider(providers, "cachePush", isCI).get();
                if (isCI) {
                    System.out.println("Build cache     enabled     push");
                    System.out.println("    Local        " + (localEnabled ? "   Y   " : "   N   ") + "     N/A");
                    System.out.println("    Remote       " + (remoteEnabled ? "   Y   " : "   N   ") + "     " + (push ? " Y" : " N"));
                }
                buildCache.getLocal().setEnabled(localEnabled);
                if (remoteEnabled) {
                    buildCache.remote(HttpBuildCache.class, remote -> {
                        remote.setUrl("https://ge.micronaut.io/cache/");
                        remote.setEnabled(true);
                        if (push) {
                            String username = ProviderUtils.envOrSystemProperty(providers, "GRADLE_ENTERPRISE_CACHE_USERNAME", "gradleEnterpriseCacheUsername", "");
                            String password = ProviderUtils.envOrSystemProperty(providers, "GRADLE_ENTERPRISE_CACHE_PASSWORD", "gradleEnterpriseCachePassword", "");
                            if (!username.isEmpty() && !password.isEmpty()) {
                                remote.setPush(true);
                                remote.credentials(creds -> {
                                    creds.setUsername(username);
                                    creds.setPassword(password);
                                });
                            } else {
                                System.err.println("WARNING: No credentials for remote build cache, cannot configure push!");
                            }
                        }
                    });
                }
            });
            BuildEnvironment buildEnvironment = new BuildEnvironment(providers);
            if (Boolean.TRUE.equals(buildEnvironment.isTestSelectionEnabled().get())) {
                ge.getBuildScan().tag("Predictive Test Selection");
            }
            this.captureSafeEnvironmentVariables(ge);
        }
    }

    private void tagWithJavaDetails(GradleEnterpriseExtension ge, ProviderFactory providers) {
        Provider vendor = providers.systemProperty("java.vendor");
        if (vendor.isPresent()) {
            ge.getBuildScan().tag("vendor:" + ((String)vendor.get()).toLowerCase().replaceAll("\\W+", "_"));
        }
        ge.getBuildScan().tag("jdk:" + JavaVersion.current().getMajorVersion());
    }

    private void captureSafeEnvironmentVariables(GradleEnterpriseExtension ge) {
        for (String variable : SAFE_TO_LOG_ENV_VARIABLES) {
            String value = System.getenv(variable);
            ge.getBuildScan().value("env." + variable, value == null ? "<undefined>" : value);
        }
    }

    private void configureBuildScansPublishing(GradleEnterpriseExtension ge, boolean isCI, Provider<Boolean> publishScanOnDemand) {
        ge.setServer("https://ge.micronaut.io");
        ge.buildScan(buildScan -> {
            if (!((Boolean)publishScanOnDemand.get()).booleanValue()) {
                buildScan.publishAlways();
            }
            if (isCI) {
                buildScan.setUploadInBackground(false);
            } else {
                MicronautGradleEnterprisePlugin.publishIfAuthenticated(buildScan);
            }
            buildScan.capture(c -> c.setTaskInputFiles(true));
        });
    }

    private static void applyGitHubActionsPlugin(Gradle gradle) {
        gradle.getRootProject().getPluginManager().apply(ActionsPlugin.class);
    }

    private static void publishIfAuthenticated(BuildScanExtension ext) {
        try {
            ext.getClass().getMethod("publishIfAuthenticated", new Class[0]).invoke((Object)ext, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            System.err.println("Unable to set publish if authenticated on build scan extension");
        }
    }
}

