/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.catalogs.internal;

import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public enum Status {
    INTEGRATION("snapshot", "[a-f0-9]{6,}"),
    ALPHA("alpha", "a"),
    BETA("beta", "b"),
    MILESTONE("milestone", "m"),
    RELEASE_CANDIDATE("rc", "cr"),
    RELEASE(new String[0]);

    private final Pattern regex;

    private Status(String ... qualifiers) {
        this.regex = qualifiers.length == 0 ? null : Pattern.compile("(?i).*[.-](?:" + Arrays.stream(qualifiers).map(Pattern::quote).map(p -> "(?:" + p + ")").collect(Collectors.joining("|")) + ")[.\\d-+]*");
    }

    public boolean isAsStableOrMoreStableThan(Status other) {
        return this.ordinal() >= other.ordinal();
    }

    public static Status detectStatus(String version) {
        for (Status status : Status.values()) {
            Pattern regex = status.regex;
            if (regex == null || !regex.matcher(version).find()) continue;
            return status;
        }
        return RELEASE;
    }
}

