/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.catalogs.internal;

import io.micronaut.build.catalogs.internal.Library;
import io.micronaut.build.catalogs.internal.VersionModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class VersionCatalogTomlModel {
    private final Set<Library> libraries = new HashSet<Library>();
    private final Set<VersionModel> versions = new HashSet<VersionModel>();
    private final Map<String, Library> gaToLibrary = new HashMap<String, Library>();
    private final Map<String, VersionModel> versionAliasToVersion = new HashMap<String, VersionModel>();
    private final Map<String, Set<Library>> versionAliasToModules = new HashMap<String, Set<Library>>();

    public void addLibrary(Library library) {
        this.libraries.add(library);
        this.gaToLibrary.put(library.getModule(), library);
        String versionRef = library.getVersion().getReference();
        if (versionRef != null) {
            Set librariesByVersionRef = this.versionAliasToModules.computeIfAbsent(versionRef, e -> new HashSet());
            librariesByVersionRef.add(library);
        }
    }

    public void addVersion(VersionModel version) {
        assert (version.getReference() != null && version.getVersion() != null);
        this.versions.add(version);
        this.versionAliasToVersion.put(version.getReference(), version);
    }

    public Optional<Library> findLibrary(String group, String name) {
        return Optional.ofNullable(this.gaToLibrary.get(group + ":" + name));
    }

    public Optional<VersionModel> findVersion(String alias) {
        return Optional.ofNullable(this.versionAliasToVersion.get(alias));
    }

    public Set<Library> findLibrariesForVersionReference(String versionRef) {
        return this.versionAliasToModules.getOrDefault(versionRef, Collections.emptySet());
    }

    public Set<Library> getLibrariesTable() {
        return this.libraries;
    }

    public Set<VersionModel> getVersionsTable() {
        return this.versions;
    }
}

