/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.compat;

import io.micronaut.build.compat.InternalAnnotationCollectorRule;
import japicmp.model.JApiHasAnnotations;
import java.util.Optional;
import me.champeau.gradle.japicmp.report.Severity;
import me.champeau.gradle.japicmp.report.Violation;
import me.champeau.gradle.japicmp.report.ViolationTransformer;

public class InternalMicronautTypeRule
implements ViolationTransformer {
    private static boolean isInternalType(String className) {
        return className.startsWith("io.micronaut") && className.contains(".internal.");
    }

    public Optional<Violation> transform(String type, Violation violation) {
        JApiHasAnnotations member;
        if (InternalMicronautTypeRule.isInternalType(type) && violation.getSeverity() == Severity.error) {
            return Optional.of(violation.withSeverity(Severity.warning));
        }
        if (violation.getMember() instanceof JApiHasAnnotations && InternalAnnotationCollectorRule.isAnnotatedWithInternal(member = (JApiHasAnnotations)violation.getMember())) {
            return Optional.of(violation.withSeverity(Severity.warning));
        }
        return Optional.of(violation);
    }
}

