/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.compat;

import io.micronaut.build.compat.VersionModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;

public abstract class MavenMetadataVersionHelper {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+\\.\\d+\\.\\d+)([.-]\\w+)?$");
    private static final String VERSION_OPEN_TAG = "<version>";
    private static final String VERSION_CLOSE_TAG = "</version>";

    private MavenMetadataVersionHelper() {
    }

    public static List<VersionModel> findReleasesFrom(byte[] mavenMetadata) {
        List<VersionModel> list;
        ArrayList<String> allVersions = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(new String(mavenMetadata, StandardCharsets.UTF_8)));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(VERSION_OPEN_TAG)) continue;
                String version2 = line.substring(line.indexOf(VERSION_OPEN_TAG) + VERSION_OPEN_TAG.length(), line.indexOf(VERSION_CLOSE_TAG));
                allVersions.add(version2);
            }
            list = allVersions.stream().map(version -> {
                Matcher m = VERSION_PATTERN.matcher((CharSequence)version);
                if (m.find()) {
                    if (m.group(2) != null) {
                        return null;
                    }
                    return m.group(1);
                }
                return null;
            }).filter(Objects::nonNull).map(VersionModel::of).sorted().collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new GradleException("Error parsing maven-metadata.xml", (Throwable)e);
            }
        }
        reader.close();
        return list;
    }

    public static Optional<VersionModel> findPreviousReleaseFor(VersionModel version, List<VersionModel> releases) {
        return releases.stream().filter(v -> v.compareTo(version) < 0).reduce((a, b) -> b);
    }
}

