/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.graalvm;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class NativePropertiesWriter
extends DefaultTask {
    private static final String NEWLINE = " \\\n       ";

    @Input
    @Optional
    abstract Property<String> getContents();

    @Input
    @Optional
    abstract ListProperty<String> getInitializeAtRuntime();

    @Input
    @Optional
    abstract ListProperty<String> getInitializeAtBuildtime();

    @Input
    @Optional
    abstract ListProperty<String> getFeatures();

    @Input
    @Optional
    abstract MapProperty<String, List<String>> getExtraArguments();

    @Input
    abstract Property<String> getGroupId();

    @Input
    abstract Property<String> getArtifactId();

    @OutputDirectory
    abstract DirectoryProperty getOutputDirectory();

    @TaskAction
    public void generateFile() throws IOException {
        List initializeAtRuntime = (List)this.getInitializeAtRuntime().getOrElse(Collections.emptyList());
        List initializeAtBuildtime = (List)this.getInitializeAtBuildtime().getOrElse(Collections.emptyList());
        List features = (List)this.getFeatures().getOrElse(Collections.emptyList());
        Map extraArguments = (Map)this.getExtraArguments().getOrElse(Collections.emptyMap());
        Path outputPath = ((Directory)this.getOutputDirectory().get()).getAsFile().toPath();
        String nativePropertiesPath = "META-INF/native-image/" + (String)this.getGroupId().get() + "/" + (String)this.getArtifactId().get() + "/native-image.properties";
        Files.createDirectories(outputPath.resolve(nativePropertiesPath).getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(outputPath.resolve(nativePropertiesPath), new OpenOption[0]);){
            boolean hasContents = this.getContents().isPresent();
            if (hasContents) {
                writer.write((String)this.getContents().get());
                writer.write("\n");
                if (!initializeAtBuildtime.isEmpty()) {
                    throw new InvalidUserCodeException("You cannot use both explicit contents and initializeAtBuildtime properties to generate the native-image.properties file");
                }
                if (!initializeAtRuntime.isEmpty()) {
                    throw new InvalidUserCodeException("You cannot use both explicit contents and initializeAtRuntime properties to generate the native-image.properties file");
                }
                if (!features.isEmpty()) {
                    throw new InvalidUserCodeException("You cannot use both explicit contents and features properties to generate the native-image.properties file");
                }
                if (!extraArguments.isEmpty()) {
                    throw new InvalidUserCodeException("You cannot use both explicit contents and extraArguments properties to generate the native-image.properties file");
                }
            } else {
                StringBuilder args = new StringBuilder();
                if (!initializeAtBuildtime.isEmpty()) {
                    args.append("--initialize-at-build-time=");
                    args.append(String.join((CharSequence)",", initializeAtBuildtime));
                }
                if (!initializeAtRuntime.isEmpty()) {
                    if (args.length() > 0) {
                        args.append(NEWLINE);
                    }
                    args.append("--initialize-at-run-time=");
                    args.append(String.join((CharSequence)",", initializeAtRuntime));
                }
                if (!features.isEmpty()) {
                    if (args.length() > 0) {
                        args.append(NEWLINE);
                    }
                    args.append("--features=");
                    args.append(String.join((CharSequence)",", features));
                }
                if (!extraArguments.isEmpty()) {
                    for (Map.Entry entry : extraArguments.entrySet()) {
                        if (args.length() > 0) {
                            args.append(NEWLINE);
                        }
                        args.append((String)entry.getKey()).append("=");
                        args.append(String.join((CharSequence)",", (Iterable)entry.getValue()));
                    }
                }
                writer.write("Args = ");
                writer.write(args.toString());
                writer.write("\n");
            }
        }
    }
}

