/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.pom;

import groovy.json.JsonGenerator;
import groovy.json.JsonOutput;
import io.micronaut.build.pom.PomDependency;
import io.micronaut.build.pom.PomDownloader;
import io.micronaut.build.pom.PomFile;
import io.micronaut.build.pom.PomParser;
import io.micronaut.build.pom.PomValidation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;

public abstract class CheckPomAction
implements WorkAction<Parameters> {
    public void execute() {
        String dependencyPath = (String)((Parameters)this.getParameters()).getDependencyPath().get();
        File pomFile = (File)((Parameters)this.getParameters()).getPomFile().getAsFile().get();
        File reportFile = (File)((Parameters)this.getParameters()).getReportFile().getAsFile().get();
        String groupId = (String)((Parameters)this.getParameters()).getGroupId().get();
        String artifactId = (String)((Parameters)this.getParameters()).getArtifactId().get();
        String version = (String)((Parameters)this.getParameters()).getVersion().get();
        File pomDirectory = (File)((Parameters)this.getParameters()).getPomDirectory().getAsFile().get();
        List repositories = (List)((Parameters)this.getParameters()).getRepositories().get();
        PomDownloader downloader = new PomDownloader(repositories, pomDirectory);
        PomParser parser = new PomParser(downloader);
        PomFile pom = parser.parse(pomFile, groupId, artifactId, version);
        Map<String, String> foundDependencies = Collections.synchronizedMap(new LinkedHashMap());
        Set<String> missingDependencies = Collections.synchronizedSet(new LinkedHashSet());
        pom.getDependencies().parallelStream().forEach(dependency -> {
            String key = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
            Optional<File> downloadedFile = downloader.tryDownloadPom((PomDependency)dependency);
            if (downloadedFile.isPresent()) {
                foundDependencies.put(key, downloadedFile.get().getAbsolutePath());
            } else {
                missingDependencies.add(key);
            }
        });
        PomValidation validation = new PomValidation(dependencyPath, pom, foundDependencies, missingDependencies);
        JsonGenerator generator = new JsonGenerator.Options().excludeFieldsByName(new CharSequence[]{"import", "importingBom"}).build();
        String json = JsonOutput.prettyPrint((String)generator.toJson((Object)validation));
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), "UTF-8");){
            writer.write(json);
        }
        catch (IOException e) {
            throw new GradleException("Unable to write report", (Throwable)e);
        }
    }

    static interface Parameters
    extends WorkParameters {
        public Property<String> getDependencyPath();

        public ListProperty<String> getRepositories();

        public Property<String> getGroupId();

        public Property<String> getArtifactId();

        public Property<String> getVersion();

        public RegularFileProperty getPomFile();

        public RegularFileProperty getReportFile();

        public DirectoryProperty getPomDirectory();
    }
}

