/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.pom;

import io.micronaut.build.pom.PomDependency;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PomFile {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final boolean isBom;
    private final List<PomDependency> dependencies;
    private final Map<String, String> properties;

    public PomFile(String groupId, String artifactId, String version, boolean bom, List<PomDependency> dependencies, Map<String, String> properties) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.isBom = bom;
        this.dependencies = dependencies;
        this.properties = properties;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isBom() {
        return this.isBom;
    }

    public boolean isImportingBom() {
        return this.dependencies.stream().anyMatch(PomDependency::isImport);
    }

    public List<PomDependency> findImports() {
        return this.dependencies.stream().filter(PomDependency::isImport).collect(Collectors.toList());
    }

    public List<PomDependency> getDependencies() {
        return this.dependencies;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "PomFile{isBom=" + this.isBom + ", dependencies=" + this.dependencies + "}";
    }
}

