/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.docs.converter;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public interface ModelVisitor {
    public static final String NEWLINE = "\n";

    public void preVisitMap(Context var1, Map<String, Object> var2);

    public void postVisitMap(Context var1, Map<String, Object> var2);

    public void visitMap(Context var1, Map<String, Object> var2);

    public void visitMapEntry(Context var1, String var2, Object var3, boolean var4);

    public void postVisitMapEntry(Context var1, String var2, Object var3, boolean var4);

    public void preVisitMapEntry(Context var1, String var2, Object var3, boolean var4);

    public void preVisitList(Context var1, List<Object> var2);

    public void postVisitList(Context var1, List<Object> var2);

    public void preVisitListItem(Context var1, Object var2, boolean var3);

    public void postVisitListItem(Context var1, Object var2, boolean var3);

    public void visitListItem(Context var1, Object var2, boolean var3);

    public void visitList(Context var1, List<Object> var2);

    public void visitString(Context var1, String var2);

    public void visitNumber(Context var1, Number var2);

    public void visitObject(Context var1, Object var2);

    public void visit(Context var1, Object var2);

    public static NodeKind kindOf(Object object) {
        Class type;
        Class clazz = type = object == null ? Object.class : object.getClass();
        if (Map.class.isAssignableFrom(type)) {
            return NodeKind.MAP;
        }
        if (List.class.isAssignableFrom(type)) {
            return NodeKind.LIST;
        }
        if (String.class.isAssignableFrom(type)) {
            return NodeKind.STRING;
        }
        if (Number.class.isAssignableFrom(type)) {
            return NodeKind.NUMBER;
        }
        return NodeKind.OBJECT;
    }

    public static enum NodeKind {
        MAP,
        LIST,
        STRING,
        NUMBER,
        OBJECT;


        public boolean isComplex() {
            return this == MAP || this == LIST;
        }

        public boolean isMap() {
            return this == MAP;
        }
    }

    public static class Context {
        private final Context parent;
        private final String key;
        private final NodeKind parentKind;

        public Context(Context parent, String key, NodeKind parentKind) {
            this.parent = parent;
            this.key = key;
            this.parentKind = parentKind;
        }

        public int depth() {
            if (this.parent == null) {
                return 0;
            }
            return 1 + this.parent.depth();
        }

        public String key() {
            return this.key;
        }

        public NodeKind parentKind() {
            return this.parentKind;
        }

        public Context child(String childKey, NodeKind parentKind) {
            return new Context(this, childKey, parentKind);
        }

        public Stream<String> pathElements() {
            if (this.parent == null) {
                return Stream.of(new String[0]);
            }
            return Stream.concat(this.parent.pathElements(), Stream.of(this.key()));
        }

        public String path() {
            return this.pathElements().reduce("", (path, item) -> {
                if ("".equals(path)) {
                    return item;
                }
                if (item.startsWith("[")) {
                    return path + item;
                }
                return path + "." + item;
            });
        }
    }
}

