/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public class BuildEnvironment {
    public static final String PREDICTIVE_TEST_SELECTION_ENV_VAR = "PREDICTIVE_TEST_SELECTION";
    public static final String PREDICTIVE_TEST_SELECTION_SYSPROP = "predictiveTestSelection";
    private final ProviderFactory providers;
    private final Provider<Boolean> githubAction;
    private final boolean isMigrationActive;

    public BuildEnvironment(ProviderFactory providers) {
        this.providers = providers;
        this.githubAction = this.trueWhenEnvVarPresent("GITHUB_ACTIONS");
        this.isMigrationActive = !providers.systemProperty("strictBuild").isPresent();
    }

    public Provider<Boolean> isGithubAction() {
        return this.githubAction;
    }

    public Provider<Boolean> isNotGithubAction() {
        return this.githubAction.map(b -> b == false);
    }

    public Provider<Boolean> trueWhenEnvVarPresent(String envVar) {
        return this.providers.environmentVariable(envVar).map(s -> true).orElse((Object)false);
    }

    public Provider<Boolean> isTestSelectionEnabled() {
        Provider projectGroup = this.providers.gradleProperty("projectGroup");
        if (projectGroup.isPresent() && ((String)projectGroup.get()).startsWith("io.micronaut")) {
            return this.providers.environmentVariable(PREDICTIVE_TEST_SELECTION_ENV_VAR).orElse(this.providers.systemProperty(PREDICTIVE_TEST_SELECTION_SYSPROP)).map(it -> {
                if (it.trim().length() > 0) {
                    return Boolean.parseBoolean(it);
                }
                return false;
            }).orElse(this.isNotGithubAction());
        }
        return this.providers.provider(() -> false);
    }

    public void duringMigration(Runnable action) {
        if (this.isMigrationActive) {
            action.run();
        }
    }
}

