/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import groovy.namespace.QName;
import groovy.util.Node;
import io.micronaut.build.MicronautBuildExtensionPlugin;
import io.micronaut.build.MicronautDependencyResolutionConfigurationPlugin;
import io.micronaut.build.MicronautPlugin;
import io.micronaut.build.MicronautPublishingPlugin;
import io.micronaut.build.catalogs.internal.LenientVersionCatalogParser;
import io.micronaut.build.catalogs.internal.Library;
import io.micronaut.build.catalogs.internal.Plugin;
import io.micronaut.build.catalogs.internal.VersionCatalogTomlModel;
import io.micronaut.build.catalogs.internal.VersionModel;
import io.micronaut.build.compat.MicronautBinaryCompatibilityPlugin;
import io.micronaut.build.pom.MicronautBomExtension;
import io.micronaut.build.pom.PomChecker;
import io.micronaut.build.pom.PomCheckerUtils;
import io.micronaut.build.pom.VersionCatalogConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.VersionCatalog;
import org.gradle.api.artifacts.VersionCatalogsExtension;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.FileCollection;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.plugins.JavaPlatformExtension;
import org.gradle.api.plugins.JavaPlatformPlugin;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.plugins.catalog.CatalogPluginExtension;
import org.gradle.api.plugins.catalog.VersionCatalogPlugin;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public abstract class MicronautBomPlugin
implements MicronautPlugin<Project> {
    public static final List<String> DEPENDENCY_PATH = Arrays.asList("dependencyManagement", "dependencies", "dependency");

    public void apply(Project project) {
        PluginManager plugins = project.getPluginManager();
        plugins.apply(JavaPlatformPlugin.class);
        plugins.apply(VersionCatalogPlugin.class);
        plugins.apply(MicronautBuildExtensionPlugin.class);
        plugins.apply(MicronautPublishingPlugin.class);
        plugins.apply(MicronautDependencyResolutionConfigurationPlugin.class);
        plugins.apply(MicronautBinaryCompatibilityPlugin.class);
        MicronautBomExtension bomExtension = (MicronautBomExtension)project.getExtensions().create("micronautBom", MicronautBomExtension.class, new Object[0]);
        bomExtension.getPublishCatalog().convention((Object)true);
        bomExtension.getIncludeBomInCatalog().convention((Object)true);
        bomExtension.getImportProjectCatalog().convention((Object)true);
        bomExtension.getExcludeProject().convention(p -> p.getName().contains("bom") || p.getName().startsWith("test-suite") || !p.getSubprojects().isEmpty());
        bomExtension.getExtraExcludedProjects().add((Object)project.getName());
        bomExtension.getCatalogToPropertyNameOverrides().convention(Collections.emptyMap());
        bomExtension.getInlineNestedCatalogs().convention((Object)true);
        bomExtension.getExcludedInlinedAliases().convention(Collections.emptySet());
        bomExtension.getInferProjectsToInclude().convention((Object)true);
        this.configureBOM(project, bomExtension);
    }

    private static String nameOf(Node n) {
        Object name = n.name();
        if (name instanceof String) {
            return (String)name;
        }
        return ((QName)n.name()).getLocalPart();
    }

    private static Stream<Node> forEachNode(Node node, List<String> path) {
        if (path.isEmpty()) {
            return Stream.empty();
        }
        String child = path.get(0);
        List children = node.children();
        if (path.size() == 1) {
            return children.stream().filter(n -> MicronautBomPlugin.nameOf(n).equals(child));
        }
        return children.stream().filter(n -> MicronautBomPlugin.nameOf(n).equals(child)).flatMap(n -> MicronautBomPlugin.forEachNode(n, path.subList(1, path.size())));
    }

    private Node childOf(Node node, String name) {
        List children = node.children();
        return children.stream().filter(n -> MicronautBomPlugin.nameOf(n).equals(name)).findFirst().orElse(null);
    }

    private static String removePrefix(String str, String prefix) {
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    private static String toPropertyName(String alias) {
        return Arrays.stream(alias.split("(?=[A-Z])")).map(s -> s.toLowerCase(Locale.US)).collect(Collectors.joining("-")).replace('-', '.');
    }

    private String bomPropertyName(MicronautBomExtension ext, String alias) {
        alias = MicronautBomPlugin.removePrefix(alias, "managed.");
        alias = MicronautBomPlugin.removePrefix(alias, "boms.");
        String baseName = (String)ext.getCatalogToPropertyNameOverrides().getting((Object)alias).getOrElse((Object)MicronautBomPlugin.toPropertyName(alias));
        return baseName + ".version";
    }

    private static List<ProjectDescriptor> computeProjectDescriptors(MicronautBomExtension ext, Project project, Set<String> includedProjects, Set<String> skippedProjects) {
        ArrayList<ProjectDescriptor> result = new ArrayList<ProjectDescriptor>();
        boolean inferProjectsToInclude = (Boolean)ext.getInferProjectsToInclude().getOrElse((Object)true);
        Set excludedProjects = (Set)ext.getExtraExcludedProjects().get();
        Spec excludeSpec = (Spec)ext.getExcludeProject().get();
        for (Project p : project.getRootProject().getSubprojects()) {
            if (p.equals(project) || excludeSpec.isSatisfiedBy((Object)p) || excludedProjects.contains(p.getName())) continue;
            project.evaluationDependsOn(p.getPath());
            if (!inferProjectsToInclude || p.getPlugins().hasPlugin(MicronautPublishingPlugin.class)) {
                includedProjects.add(p.getPath());
                result.add(ProjectDescriptor.fromProject(p));
                continue;
            }
            skippedProjects.add(p.getPath());
        }
        return Collections.unmodifiableList(result);
    }

    private void configureBOM(Project project, MicronautBomExtension bomExtension) {
        PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
        JavaPlatformExtension javaPlatformExtension = (JavaPlatformExtension)project.getExtensions().getByType(JavaPlatformExtension.class);
        javaPlatformExtension.allowDependencies();
        TaskContainer tasks = project.getTasks();
        project.afterEvaluate(unused -> this.configureLate(project, bomExtension, publishing, tasks));
        this.registerCheckBomTask(project, publishing, bomExtension);
    }

    private void configureLate(Project project, MicronautBomExtension bomExtension, PublishingExtension publishing, TaskContainer tasks) {
        String mainProjectId = (String)bomExtension.getPropertyName().getOrElse((Object)project.getRootProject().getName().replace("-parent", "").replace('-', '.'));
        String publishedName = MicronautPlugin.moduleNameOf(project.getName());
        String group = String.valueOf(project.getGroup());
        Optional<VersionCatalog> versionCatalog = MicronautBomPlugin.findVersionCatalog(project, bomExtension);
        VersionCatalogConverter modelConverter = new VersionCatalogConverter(project.getRootProject().file((Object)"gradle/libs.versions.toml"), (CatalogPluginExtension)project.getExtensions().findByType(CatalogPluginExtension.class));
        tasks.named("generateCatalogAsToml", task -> modelConverter.populateModel());
        if (((Boolean)bomExtension.getPublishCatalog().get()).booleanValue()) {
            this.configureVersionCatalog(project, bomExtension, publishedName, group, mainProjectId);
        }
        Provider modelProvider = project.provider(modelConverter::getModel);
        final HashSet includedProjects = new HashSet();
        final HashSet skippedProjects = new HashSet();
        Provider projectDescriptors = project.provider(() -> MicronautBomPlugin.computeProjectDescriptors(bomExtension, project, includedProjects, skippedProjects));
        LinkedHashMap inlinedPomProperties = new LinkedHashMap();
        publishing.getPublications().named("maven", MavenPublication.class, pub -> {
            pub.setArtifactId(publishedName);
            pub.from((SoftwareComponent)project.getComponents().getByName("javaPlatform"));
            pub.pom(pom -> {
                pom.setPackaging("pom");
                pom.withXml(xml -> {
                    Node node = xml.asNode();
                    ((VersionCatalogTomlModel)modelProvider.get()).getLibrariesTable().forEach(library -> {
                        String alias = Optional.ofNullable(library.getVersion().getReference()).map(a -> a.replace('-', '.')).orElse("");
                        String libraryAlias = Optional.ofNullable(library.getAlias()).map(a -> a.replace('-', '.')).orElse("");
                        if (libraryAlias.startsWith("managed.") || libraryAlias.startsWith("boms.")) {
                            Optional<Node> pomDep = MicronautBomPlugin.forEachNode(node, DEPENDENCY_PATH).filter(n -> this.childOf((Node)n, "artifactId").text().equals(library.getName()) && this.childOf((Node)n, "groupId").text().equals(library.getGroup())).findFirst();
                            if (pomDep.isPresent()) {
                                String bomPropertyName = this.bomPropertyName(bomExtension, alias);
                                this.childOf(pomDep.get(), "version").setValue((Object)("${" + bomPropertyName + "}"));
                            } else {
                                System.err.println("[WARNING] Didn't find library " + library.getGroup() + ":" + library.getName() + " in BOM file");
                            }
                        }
                    });
                    ((List)projectDescriptors.get()).forEach(p -> {
                        String propertyName = "micronaut." + mainProjectId + ".version";
                        String projectGroup = p.getGroupId();
                        String moduleName = p.getArtifactId();
                        Optional<Node> pomDep = MicronautBomPlugin.forEachNode(node, DEPENDENCY_PATH).filter(n -> this.childOf((Node)n, "artifactId").text().equals(moduleName) && this.childOf((Node)n, "groupId").text().equals(projectGroup)).findFirst();
                        if (pomDep.isPresent()) {
                            this.childOf(pomDep.get(), "version").setValue((Object)("${" + propertyName + "}"));
                        } else {
                            System.err.println("[WARNING] Didn't find dependency " + projectGroup + ":" + moduleName + " in BOM file");
                        }
                    });
                    Node propertiesNode = this.childOf(node, "properties");
                    inlinedPomProperties.forEach((moduleName, version) -> {
                        String propertyName = this.bomPropertyName(bomExtension, (String)moduleName);
                        Node existingProperty = this.childOf(propertiesNode, propertyName);
                        if (existingProperty == null) {
                            propertiesNode.appendNode((Object)propertyName, version);
                        }
                    });
                    propertiesNode.children().sort((o1, o2) -> {
                        String name1 = MicronautBomPlugin.nameOf((Node)o1);
                        String name2 = MicronautBomPlugin.nameOf((Node)o2);
                        return name1.compareTo(name2);
                    });
                });
                versionCatalog.ifPresent(libsCatalog -> libsCatalog.getVersionAliases().forEach(alias -> {
                    if (alias.startsWith("managed.")) {
                        libsCatalog.findVersion(alias).ifPresent(version -> {
                            String propertyName = this.bomPropertyName(bomExtension, (String)alias);
                            pom.getProperties().put((Object)propertyName, (Object)version.getRequiredVersion());
                        });
                    }
                }));
                ((List)projectDescriptors.get()).forEach(p -> {
                    project.evaluationDependsOn(p.getPath());
                    String propertyName = "micronaut." + mainProjectId + ".version";
                    pom.getProperties().put((Object)propertyName, (Object)PomCheckerUtils.assertVersion(p.getVersion(), p.getPath()));
                });
                tasks.withType(GenerateMavenPom.class).configureEach(pomTask -> pomTask.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        System.out.println("Projects included into BOM:\n" + includedProjects.stream().map(p -> "    - " + p).collect(Collectors.joining("\n")));
                        if (!skippedProjects.isEmpty()) {
                            System.out.println("Skipped projects which do not apply the publishing plugin:\n" + skippedProjects.stream().map(p -> "    - " + p).collect(Collectors.joining("\n")));
                        }
                    }
                }));
            });
        });
        Configuration api = project.getConfigurations().getByName("api");
        Configuration runtime = project.getConfigurations().getByName("runtime");
        Configuration catalogs = project.getConfigurations().detachedConfiguration(new Dependency[0]);
        catalogs.attributes(attrs -> {
            attrs.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)project.getObjects().named(Category.class, "platform")));
            attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "version-catalog")));
        });
        versionCatalog.ifPresent(libsCatalog -> libsCatalog.getLibraryAliases().forEach(alias -> {
            if (alias.startsWith("boms.")) {
                Dependency bomDependency = project.getDependencies().platform((Object)libsCatalog.findLibrary(alias).map(Provider::get).orElseThrow(() -> new RuntimeException("Unexpected missing alias in catalog: " + alias)));
                api.getDependencies().add((Object)bomDependency);
                catalogs.getDependencies().add((Object)bomDependency);
            } else if (alias.startsWith("managed.")) {
                api.getDependencyConstraints().add((Object)project.getDependencies().getConstraints().create((Object)libsCatalog.findLibrary(alias).map(Provider::get).orElseThrow(() -> new RuntimeException("Unexpected missing alias in catalog: " + alias))));
            }
        }));
        FileCollection catalogFiles = catalogs.getIncoming().artifactView(spec -> spec.lenient(true)).getFiles();
        Property<Boolean> inlineNestedCatalogs = bomExtension.getInlineNestedCatalogs();
        SetProperty<String> excludedInlinedAliases = bomExtension.getExcludedInlinedAliases();
        modelConverter.afterBuildingModel(builderState -> {
            api.getAllDependencyConstraints().forEach(MicronautBomPlugin::checkVersionConstraint);
            runtime.getAllDependencyConstraints().forEach(MicronautBomPlugin::checkVersionConstraint);
            this.maybeInlineNestedCatalogs(catalogFiles, (VersionCatalogConverter.BuilderState)builderState, inlineNestedCatalogs, excludedInlinedAliases, inlinedPomProperties);
        });
        ((List)projectDescriptors.get()).forEach(p -> {
            String moduleGroup = p.getGroupId();
            String moduleName = p.getArtifactId();
            String moduleVersion = PomCheckerUtils.assertVersion(p.getVersion(), p.getPath());
            api.getDependencyConstraints().add((Object)project.getDependencies().getConstraints().create((Object)(moduleGroup + ":" + moduleName + ":" + moduleVersion)));
            String mainModuleName = MicronautPlugin.moduleNameOf(mainProjectId.replace('.', '-'));
            modelConverter.getExtraVersions().put(mainModuleName, moduleVersion);
            modelConverter.getExtraLibraries().put(moduleName, VersionCatalogConverter.library(moduleGroup, moduleName, mainModuleName));
        });
    }

    private void maybeInlineNestedCatalogs(FileCollection catalogs, VersionCatalogConverter.BuilderState builderState, Property<Boolean> inlineNestedCatalogs, SetProperty<String> excludedInlinedAliases, Map<String, String> inlinedPomProperties) {
        if (Boolean.TRUE.equals(inlineNestedCatalogs.get())) {
            VersionCatalogBuilder builder = builderState.getBuilder();
            Map<String, VersionCatalogConverter.AliasRecord> knownAliases = builderState.getKnownAliases();
            Map<String, VersionCatalogConverter.AliasRecord> knownPluginAliases = builderState.getKnownPluginAliases();
            Map<String, VersionCatalogConverter.AliasRecord> knownVersionAliases = builderState.getKnownVersionAliases();
            Set excludeFromInlining = (Set)excludedInlinedAliases.get();
            catalogs.forEach(catalogFile -> {
                try (FileInputStream fis = new FileInputStream((File)catalogFile);){
                    LenientVersionCatalogParser parser = new LenientVersionCatalogParser();
                    parser.parse(fis);
                    Set<Library> librariesTable = parser.getModel().getLibrariesTable();
                    Set<Plugin> pluginsTable = parser.getModel().getPluginsTable();
                    Set<VersionModel> versionsTable = parser.getModel().getVersionsTable();
                    librariesTable.forEach(library -> {
                        String alias = library.getAlias();
                        if (excludeFromInlining.contains(alias)) return;
                        String source = catalogFile.getName();
                        if (!knownAliases.containsKey(alias)) {
                            String reference = library.getVersion().getReference();
                            String version = null;
                            if (reference != null) {
                                version = reference;
                                if (!knownVersionAliases.containsKey(reference)) {
                                    String requiredVersion = versionsTable.stream().filter(m -> reference.equals(m.getReference())).findFirst().get().getVersion().getRequire();
                                    if (requiredVersion == null) throw new IllegalStateException("Version '" + reference + "' is not defined as a required version in the catalog");
                                    builder.version(reference, requiredVersion);
                                    inlinedPomProperties.put(reference, requiredVersion);
                                } else {
                                    Set<String> sources = ((VersionCatalogConverter.AliasRecord)knownVersionAliases.get(reference)).getSources();
                                    if (!sources.equals(Collections.singleton(source))) {
                                        System.err.println("[Warning] While inlining " + source + ", version alias '" + alias + "' is already defined in the catalog by " + sources + " so it won't be imported");
                                    }
                                }
                                ((VersionCatalogConverter.AliasRecord)knownVersionAliases.get(reference)).addSource(source);
                            }
                            VersionCatalogBuilder.LibraryAliasBuilder libraryBuilder = builder.library(alias, library.getGroup(), library.getName());
                            if (version != null) {
                                libraryBuilder.versionRef(reference);
                            } else {
                                libraryBuilder.withoutVersion();
                            }
                        } else {
                            MicronautBomPlugin.maybeWarn(knownAliases, alias, source);
                        }
                        ((VersionCatalogConverter.AliasRecord)knownAliases.get(alias)).addSource(source);
                    });
                    pluginsTable.forEach(plugin -> {
                        String alias = plugin.alias();
                        if (excludeFromInlining.contains(alias)) return;
                        String source = catalogFile.getName();
                        if (!knownPluginAliases.containsKey(alias)) {
                            String reference = plugin.version().getReference();
                            String version = null;
                            if (reference != null) {
                                version = reference;
                                if (!knownVersionAliases.containsKey(reference)) {
                                    String requiredVersion = versionsTable.stream().filter(m -> reference.equals(m.getReference())).findFirst().get().getVersion().getRequire();
                                    if (requiredVersion == null) throw new IllegalStateException("Version '" + reference + "' is not defined as a required version in the catalog");
                                    builder.version(reference, requiredVersion);
                                    inlinedPomProperties.put(reference, requiredVersion);
                                } else {
                                    Set<String> sources = ((VersionCatalogConverter.AliasRecord)knownVersionAliases.get(reference)).getSources();
                                    if (!sources.equals(Collections.singleton(source))) {
                                        System.err.println("[Warning] While inlining " + source + ", version alias '" + alias + "' is already defined in the catalog by " + sources + " so it won't be imported");
                                    }
                                }
                                ((VersionCatalogConverter.AliasRecord)knownVersionAliases.get(reference)).addSource(source);
                            }
                            VersionCatalogBuilder.PluginAliasBuilder pluginAliasBuilder = builder.plugin(alias, plugin.id());
                            if (version != null) {
                                pluginAliasBuilder.versionRef(reference);
                            } else {
                                pluginAliasBuilder.version(plugin.version().getVersion().getRequire());
                            }
                        } else {
                            MicronautBomPlugin.maybeWarn(knownPluginAliases, alias, source);
                        }
                        ((VersionCatalogConverter.AliasRecord)knownPluginAliases.get(alias)).addSource(source);
                    });
                }
                catch (IOException e) {
                    System.err.println("Unable to parse version catalog file: " + catalogFile);
                }
            });
        }
    }

    private static void maybeWarn(Map<String, VersionCatalogConverter.AliasRecord> knownPluginAliases, String alias, String source) {
        String shortName;
        VersionCatalogConverter.AliasRecord record = knownPluginAliases.get(alias);
        boolean warn = true;
        if (source.startsWith("micronaut-") && source.contains("-bom") && alias.equals(shortName = source.substring(0, source.indexOf("-bom"))) && record.getSources().equals(Collections.singleton("BOM build file or main version catalog"))) {
            warn = false;
        }
        if (warn) {
            System.err.println("[Warning] While inlining " + source + ", alias '" + alias + "' is already defined in the catalog by " + record.getSources() + " so it won't be imported");
        }
    }

    private void registerCheckBomTask(Project project, PublishingExtension publishing, MicronautBomExtension bomExtension) {
        TaskProvider<PomChecker> checkBom = PomCheckerUtils.registerPomChecker("checkBom", project, publishing, task -> task.getSuppressions().convention((Object)bomExtension.getSuppressions()));
        project.getTasks().register("checkPom", task -> task.dependsOn(new Object[]{checkBom}));
    }

    private static Optional<VersionCatalog> findVersionCatalog(Project project, MicronautBomExtension bomExtension) {
        if (!((Boolean)bomExtension.getImportProjectCatalog().get()).booleanValue()) {
            return Optional.empty();
        }
        VersionCatalogsExtension versionCatalogsExtension = (VersionCatalogsExtension)project.getExtensions().findByType(VersionCatalogsExtension.class);
        return Optional.ofNullable(versionCatalogsExtension).flatMap(e -> e.find("libs"));
    }

    private void configureVersionCatalog(Project project, MicronautBomExtension bomExtension, String publishedName, String group, String mainProjectId) {
        if (((Boolean)bomExtension.getIncludeBomInCatalog().get()).booleanValue()) {
            CatalogPluginExtension catalog = (CatalogPluginExtension)project.getExtensions().getByType(CatalogPluginExtension.class);
            catalog.versionCatalog(vc -> {
                String mainModuleName = MicronautPlugin.moduleNameOf(mainProjectId);
                String versionName = mainModuleName.replace('-', '.');
                vc.library(publishedName, group, publishedName).versionRef(versionName);
                vc.version(versionName, String.valueOf(project.getVersion()));
            });
        }
        AdhocComponentWithVariants javaPlatform = (AdhocComponentWithVariants)project.getComponents().getByName("javaPlatform");
        javaPlatform.addVariantsFromConfiguration(project.getConfigurations().getByName("versionCatalogElements"), details -> {
            details.mapToMavenScope("compile");
            details.mapToOptional();
        });
    }

    private static void checkVersionConstraint(DependencyConstraint constraint) {
        VersionConstraint versionConstraint = constraint.getVersionConstraint();
        if (versionConstraint.getRequiredVersion().isEmpty() && versionConstraint.getPreferredVersion().isEmpty() && versionConstraint.getStrictVersion().isEmpty() && versionConstraint.getRejectedVersions().isEmpty()) {
            throw new InvalidUserDataException("A dependency constraint was added on '" + constraint.getModule() + "' without a version. This is invalid: a constraint must specify a version.");
        }
    }

    static class ProjectDescriptor {
        private final String path;
        private final String groupId;
        private final String artifactId;
        private final String version;

        static ProjectDescriptor fromProject(Project project) {
            return new ProjectDescriptor(project.getPath(), String.valueOf(project.getGroup()), MicronautPlugin.moduleNameOf(project.getName()), String.valueOf(project.getVersion()));
        }

        private ProjectDescriptor(String path, String groupId, String artifactId, String version) {
            this.path = path;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getPath() {
            return this.path;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

