/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import io.github.gradlenexus.publishplugin.InitializeNexusStagingRepository;
import io.micronaut.build.MicronautBuildExtension;
import io.micronaut.build.MicronautBuildExtensionPlugin;
import io.micronaut.build.MicronautPlugin;
import io.micronaut.build.utils.ProviderUtils;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.VariantVersionMappingStrategy;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.plugins.signing.Sign;
import org.gradle.plugins.signing.SigningExtension;

public abstract class MicronautPublishingPlugin
implements Plugin<Project> {
    private static final String[] EXTRA_JAR_TASKS = new String[]{"javadocJar", "sourcesJar"};
    private static final Set<String> JARS_TO_EMBED_POM = new HashSet<String>(Arrays.asList("jar", "shadowJar"));

    public void apply(Project project) {
        PluginManager plugins = project.getPluginManager();
        ProviderFactory providers = project.getProviders();
        TaskContainer tasks = project.getTasks();
        ExtensionContainer extensions = project.getExtensions();
        if (MicronautPublishingPlugin.isPublishingDisabledFor(project)) {
            return;
        }
        plugins.apply(MicronautBuildExtensionPlugin.class);
        MicronautBuildExtension micronautBuild = (MicronautBuildExtension)project.getExtensions().getByType(MicronautBuildExtension.class);
        this.configurePreReleaseCheck(project);
        plugins.apply(MavenPublishPlugin.class);
        String ossUser = ProviderUtils.envOrSystemProperty(providers, "SONATYPE_USERNAME", "sonatypeOssUsername", "");
        String ossPass = ProviderUtils.envOrSystemProperty(providers, "SONATYPE_PASSWORD", "sonatypeOssPassword", "");
        plugins.withPlugin("java-base", unused -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
            javaPluginExtension.withSourcesJar();
            javaPluginExtension.withJavadocJar();
            micronautBuild.getEnvironment().duringMigration(() -> tasks.withType(Javadoc.class).configureEach(task -> task.setFailOnError(false)));
            for (String taskName : EXTRA_JAR_TASKS) {
                tasks.named(taskName, Jar.class).configure(jar -> jar.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE));
            }
        });
        ExtraPropertiesExtension ext = (ExtraPropertiesExtension)extensions.getByType(ExtraPropertiesExtension.class);
        ext.set("signing.keyId", (Object)ProviderUtils.envOrSystemProperty(providers, "GPG_KEY_ID", "signing.keyId", null));
        ext.set("signing.password", (Object)ProviderUtils.envOrSystemProperty(providers, "GPG_PASSWORD", "signing.password", null));
        Provider githubSlug = providers.gradleProperty("githubSlug");
        PublishingExtension publishing = (PublishingExtension)extensions.getByType(PublishingExtension.class);
        publishing.getPublications().configureEach(publication -> {
            if (!(publication instanceof MavenPublication)) {
                throw new UnsupportedOperationException("Unsupported publication type: " + publication.getClass().getName());
            }
            MavenPublication mavenPublication = (MavenPublication)publication;
            mavenPublication.pom(pom -> {
                pom.getName().set(providers.gradleProperty("title"));
                pom.getDescription().set(providers.gradleProperty("projectDesc"));
                pom.getUrl().set(providers.gradleProperty("projectUrl"));
                pom.licenses(licenses -> licenses.license(license -> {
                    license.getName().set((Object)"The Apache Software License, Version 2.0");
                    license.getUrl().set((Object)"http://www.apache.org/licenses/LICENSE-2.0.txt");
                    license.getDistribution().set((Object)"repo");
                }));
                pom.scm(scm -> {
                    scm.getUrl().set(githubSlug.map(s -> "scm:git@github.com:" + s + ".git"));
                    scm.getConnection().set(githubSlug.map(s -> "scm:git@github.com:" + s + ".git"));
                    scm.getDeveloperConnection().set(githubSlug.map(s -> "scm:git@github.com:" + s + ".git"));
                });
                pom.developers(developers -> {
                    String devs = (String)providers.gradleProperty("developers").getOrNull();
                    if (devs != null) {
                        for (String dev : devs.split(",")) {
                            developers.developer(developer -> {
                                developer.getId().set((Object)dev.toLowerCase(Locale.ENGLISH).replace(" ", ""));
                                developer.getName().set((Object)dev);
                            });
                        }
                    }
                });
            });
        });
        publishing.repositories(repositories -> {
            Provider externalRepoUri = providers.systemProperty("io.micronaut.publishing.uri");
            if (externalRepoUri.isPresent()) {
                repositories.maven(maven -> {
                    maven.setName("External");
                    maven.setUrl((Object)externalRepoUri);
                    Provider externalRepoUsername = providers.systemProperty("io.micronaut.publishing.username");
                    Provider externalRepoPassword = providers.systemProperty("io.micronaut.publishing.password");
                    if (externalRepoUsername.isPresent() && externalRepoPassword.isPresent()) {
                        maven.credentials(credentials -> {
                            credentials.setUsername((String)externalRepoUsername.get());
                            credentials.setPassword((String)externalRepoPassword.get());
                        });
                    }
                });
            }
            repositories.maven(maven -> {
                maven.setName("Build");
                maven.setUrl((Object)project.getRootProject().getLayout().getBuildDirectory().dir("repo"));
            });
        });
        publishing.publications(publications -> {
            String aid = MicronautPlugin.moduleNameOf(project.getName());
            publications.create("maven", MavenPublication.class, pub -> {
                pub.setArtifactId(aid);
                plugins.withPlugin("java", unused -> {
                    pub.from((SoftwareComponent)project.getComponents().getByName("java"));
                    pub.versionMapping(mapping -> {
                        mapping.usage("java-api", usage -> usage.fromResolutionOf("runtimeClasspath"));
                        mapping.usage("java-runtime", VariantVersionMappingStrategy::fromResolutionResult);
                    });
                });
            });
        });
        tasks.withType(Jar.class).configureEach(jar -> {
            if (JARS_TO_EMBED_POM.contains(jar.getName())) {
                String aid = MicronautPlugin.moduleNameOf(project.getName());
                jar.into((Object)("META-INF/maven/" + project.getGroup() + "/" + aid), spec -> spec.from((Object)tasks.named("generatePomFileForMavenPublication"), it -> it.rename("pom-default.xml", "pom.xml")));
            }
        });
        tasks.withType(InitializeNexusStagingRepository.class).configureEach(t -> t.shouldRunAfter(new Object[]{tasks.withType(Sign.class)}));
        File secRingFile = new File(project.getRootDir(), "secring.gpg");
        if (!secRingFile.exists()) {
            secRingFile = new File(System.getenv("HOME") + "/.gnupg/secring.gpg");
        }
        if (secRingFile.exists()) {
            ext.set("signing.secretKeyRingFile", (Object)secRingFile.getAbsolutePath());
        }
        if (!ossUser.isEmpty() && !ossPass.isEmpty()) {
            boolean hasKeyId;
            boolean bl = hasKeyId = ext.getProperties().get("signing.keyId") != null;
            if (hasKeyId) {
                plugins.apply("signing");
                SigningExtension signing = (SigningExtension)extensions.getByType(SigningExtension.class);
                signing.setRequired(MicronautPublishingPlugin.shouldSign(project));
                signing.sign(new Publication[]{(Publication)publishing.getPublications().getByName("maven")});
                project.getTasks().withType(Sign.class, sign -> sign.onlyIf(t -> MicronautPublishingPlugin.shouldSign(project)));
            }
        }
    }

    private static boolean isPublishingDisabledFor(Project project) {
        Object p = project.findProperty("micronautPublish");
        if (p == null) {
            if (project.getName().contains("doc") && !project.getName().contains("adoc") || project.getName().contains("example")) {
                project.getLogger().info("Publishing is disabled for project {}", (Object)project.getName());
                return true;
            }
        } else {
            boolean doPublish;
            boolean bl = doPublish = Boolean.valueOf(p.toString()) == Boolean.TRUE;
            if (!doPublish) {
                project.getLogger().info("Publishing is explicitly disabled for project {}", (Object)project.getName());
                return true;
            }
        }
        return false;
    }

    private static boolean shouldSign(Project project) {
        return !project.getVersion().toString().endsWith("-SNAPSHOT") && !project.hasProperty("skipSigning");
    }

    private void configurePreReleaseCheck(Project project) {
        project.getTasks().register("preReleaseCheck", task -> task.setDescription("Performs pre-release checks"));
    }
}

