/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.compat;

import japicmp.model.JApiClass;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiHasAnnotations;
import java.util.HashSet;
import me.champeau.gradle.japicmp.report.AbstractContextAwareViolationRule;
import me.champeau.gradle.japicmp.report.Violation;

public class InternalAnnotationCollectorRule
extends AbstractContextAwareViolationRule {
    public static final String INTERNAL_TYPES = "micronaut.internal.types";

    public Violation maybeViolation(JApiCompatibility member) {
        if (member instanceof JApiClass) {
            JApiClass jApiClass = (JApiClass)member;
            this.maybeRecord((JApiHasAnnotations)member, jApiClass.getFullyQualifiedName());
        }
        return null;
    }

    private void maybeRecord(JApiHasAnnotations member, String name) {
        if (InternalAnnotationCollectorRule.isAnnotatedWithInternal(member)) {
            HashSet<String> types = (HashSet<String>)this.getContext().getUserData(INTERNAL_TYPES);
            if (types == null) {
                types = new HashSet<String>();
                this.getContext().putUserData(INTERNAL_TYPES, types);
            }
            types.add(name);
        }
    }

    static boolean isAnnotatedWithInternal(JApiHasAnnotations member) {
        return member.getAnnotations().stream().anyMatch(ann -> ann.getFullyQualifiedName().equals("io.micronaut.core.annotation.Internal"));
    }
}

