/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.docs;

import io.micronaut.build.docs.props.JavaDocAtValueReplacementTask;
import io.micronaut.build.docs.props.ProcessConfigPropsTask;
import io.micronaut.build.docs.props.ReplaceAtLinkTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public abstract class ConfigurationPropertiesPlugin
implements Plugin<Project> {
    private static final String DOCUMENTATION_GROUP = "mndocs";
    public static final String CONFIGURATION_PROPERTIES = "configuration-properties";
    public static final String INDIVIDUAL_CONFIGURATION_PROPERTIES = "individual-configuration-properties";

    public void apply(Project project) {
        project.getPluginManager().withPlugin("java", plugin -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            TaskContainer tasks = project.getTasks();
            DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
            Provider genDir = buildDirectory.dir("config-properties");
            SourceSet mainSourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
            TaskProvider javaDocAtReplacement = tasks.register("javaDocAtReplacement", JavaDocAtValueReplacementTask.class, task -> {
                task.setGroup(DOCUMENTATION_GROUP);
                task.getSourceFiles().from(new Object[]{mainSourceSet.getAllJava()});
                task.getInputFiles().from(new Object[]{mainSourceSet.getOutput().getAsFileTree().filter(f -> "config-properties.adoc".equals(f.getName()))});
                task.getOutputFile().convention(genDir.map(dir -> dir.file("config-properties-javadocat-replaced.adoc")));
            });
            TaskProvider replaceAtLink = tasks.register("replaceAtLink", ReplaceAtLinkTask.class, task -> {
                task.setGroup(DOCUMENTATION_GROUP);
                task.getInputFiles().from(new Object[]{javaDocAtReplacement});
                task.getOutputFile().convention(genDir.map(dir -> dir.file(project.getName() + "-config-properties.adoc")));
            });
            TaskProvider processConfigurationProperties = tasks.register("processConfigProps", ProcessConfigPropsTask.class, task -> {
                task.setGroup(DOCUMENTATION_GROUP);
                task.getInputFiles().from(new Object[]{replaceAtLink});
                task.getOutputDirectory().convention(genDir.map(d -> d.dir("processed")));
            });
            Configuration singleConfigPropertiesElements = this.createConfigurationPropertiesOutgoingConfiguration(project, "configurationPropertiesElements", CONFIGURATION_PROPERTIES);
            singleConfigPropertiesElements.getOutgoing().artifact((Object)replaceAtLink);
            Configuration individualConfigurationPropertiesElements = this.createConfigurationPropertiesOutgoingConfiguration(project, "individualConfigurationPropertiesElements", INDIVIDUAL_CONFIGURATION_PROPERTIES);
            individualConfigurationPropertiesElements.getOutgoing().artifact((Object)processConfigurationProperties);
        });
    }

    private Configuration createConfigurationPropertiesOutgoingConfiguration(Project project, String name, String usage) {
        return (Configuration)project.getConfigurations().create(name, conf -> {
            conf.setDescription("Configuration properties adoc files");
            conf.setCanBeConsumed(true);
            conf.setCanBeResolved(false);
            conf.attributes(attrs -> ConfigurationPropertiesPlugin.configureAttributes(attrs, project.getObjects(), usage));
        });
    }

    public static void configureAttributes(AttributeContainer attrs, ObjectFactory objects, String usage) {
        attrs.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objects.named(Category.class, "documentation")));
        attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objects.named(Usage.class, usage)));
    }
}

