/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.docs;

import io.micronaut.build.MicronautBuildExtension;
import io.micronaut.build.MicronautBuildExtensionPlugin;
import io.micronaut.build.MicronautDependencyResolutionConfigurationPlugin;
import io.micronaut.build.docs.AggregatedJavadocParticipantPlugin;
import io.micronaut.build.docs.JavadocAggregationUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;

@CacheableTask
public abstract class JavadocAggregatorPlugin
implements Plugin<Project> {
    private static final Pattern MICRONAUT_DOCS_URI_PATTERN = Pattern.compile("^(https?://micronaut-projects\\.github\\.io/micronaut-(?:[a-z-A-Z0-9]-?)+/latest/api/)(.*)$");

    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        project.getPluginManager().apply(MicronautBuildExtensionPlugin.class);
        project.getPluginManager().apply(MicronautDependencyResolutionConfigurationPlugin.class);
        MicronautBuildExtension micronautBuildExtension = (MicronautBuildExtension)project.getExtensions().getByType(MicronautBuildExtension.class);
        project.getDependencies().getAttributesSchema().attribute(Usage.USAGE_ATTRIBUTE).getCompatibilityRules().add(AggregationCompatibilityRule.class);
        project.getDependencies().getAttributesSchema().attribute(Usage.USAGE_ATTRIBUTE).getDisambiguationRules().add(AggregationDisambiguationRule.class);
        Configuration javadocAggregatorBase = this.createAggregationConfigurationBase(project);
        Configuration javadocAggregator = this.createAggregationConfiguration(project, javadocAggregatorBase);
        Configuration javadocAggregatorClasspath = this.createAggregationConfigurationClasspath(project, javadocAggregatorBase);
        project.getSubprojects().forEach(subproject -> {
            project.evaluationDependsOn(subproject.getPath());
            subproject.getPlugins().withType(AggregatedJavadocParticipantPlugin.class, plugin -> javadocAggregatorBase.getDependencies().add((Object)project.getDependencies().create(subproject)));
        });
        JavaToolchainService toolchains = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        project.getTasks().register("javadoc", Javadoc.class, javadoc -> {
            javadoc.setDescription("Generate javadocs from all child projects as if it was a single project");
            javadoc.setGroup("Documentation");
            javadoc.setDestinationDir(((Directory)project.getLayout().getBuildDirectory().dir("working/00-api").get()).getAsFile());
            javadoc.setTitle(project.getName() + " " + project.getVersion() + " API");
            StandardJavadocDocletOptions options = (StandardJavadocDocletOptions)javadoc.getOptions();
            options.author(true);
            javadoc.exclude(new String[]{"example/**"});
            javadoc.getJavadocTool().convention(toolchains.javadocToolFor(spec -> spec.getLanguageVersion().set(micronautBuildExtension.getJavaVersion().map(JavaLanguageVersion::of))));
            if (micronautBuildExtension.getSourceCompatibility().isPresent()) {
                options.setSource((String)micronautBuildExtension.getSourceCompatibility().get());
            } else {
                options.setSource((String)micronautBuildExtension.getJavaVersion().map(String::valueOf).get());
            }
            options.links((String[])project.getProperties().entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith("api")).map(Map.Entry::getValue).map(String::valueOf).filter(link -> link.startsWith("http")).map(link -> {
                Matcher m = MICRONAUT_DOCS_URI_PATTERN.matcher((CharSequence)link);
                if (m.matches() && !m.group(2).isEmpty()) {
                    project.getLogger().warn("[javadocs] gradle.properties file declares entry {} with should stop at /api. Automatically truncated to {}", link, (Object)m.group(1));
                    return m.group(1);
                }
                return link;
            }).toArray(String[]::new));
            options.addStringOption("Xdoclint:none", "-quiet");
            options.addBooleanOption("notimestamp", true);
            javadoc.setSource((Object)javadocAggregator);
            javadoc.setClasspath((FileCollection)javadocAggregatorClasspath);
        });
    }

    private Configuration createAggregationConfiguration(Project project, Configuration javadocAggregatorBase) {
        return (Configuration)project.getConfigurations().create("javadocAggregator", conf -> {
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(true);
            conf.extendsFrom(new Configuration[]{javadocAggregatorBase});
            JavadocAggregationUtils.configureJavadocSourcesAggregationAttributes(project.getObjects(), conf);
        });
    }

    private Configuration createAggregationConfigurationClasspath(Project project, Configuration javadocAggregatorBase) {
        return (Configuration)project.getConfigurations().create("javadocAggregatorClasspath", conf -> {
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(true);
            conf.extendsFrom(new Configuration[]{javadocAggregatorBase});
            conf.attributes(attrs -> {
                attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)project.getObjects().named(Usage.class, "aggregatedJavadocParticipantDependencies")));
                attrs.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)project.getObjects().named(Category.class, "library")));
                attrs.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)project.getObjects().named(Bundling.class, "external")));
            });
        });
    }

    private Configuration createAggregationConfigurationBase(Project project) {
        return (Configuration)project.getConfigurations().create("javadocAggregatorBase", conf -> {
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(false);
        });
    }

    public static class AggregationCompatibilityRule
    implements AttributeCompatibilityRule<Usage> {
        private static final Set<String> COMPATIBLE_VALUES = Collections.unmodifiableSet(new HashSet<String>(){
            {
                this.add("java-api");
                this.add("java-runtime");
            }
        });

        public void execute(CompatibilityCheckDetails<Usage> details) {
            Usage producerValue;
            Usage consumerValue = (Usage)details.getConsumerValue();
            if (consumerValue != null && consumerValue.getName().equals("aggregatedJavadocParticipantDependencies") && (producerValue = (Usage)details.getProducerValue()) != null && COMPATIBLE_VALUES.contains(producerValue.getName())) {
                details.compatible();
            }
        }
    }

    public static class AggregationDisambiguationRule
    implements AttributeDisambiguationRule<Usage> {
        public void execute(MultipleCandidatesDetails<Usage> details) {
            for (Usage candidateValue : details.getCandidateValues()) {
                if (!candidateValue.getName().equals("java-runtime")) continue;
                details.closestMatch((Object)candidateValue);
                return;
            }
            for (Usage candidateValue : details.getCandidateValues()) {
                if (!candidateValue.getName().equals("java-api")) continue;
                details.closestMatch((Object)candidateValue);
                return;
            }
        }
    }
}

