/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.pom;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.micronaut.build.pom.BomSuppressions;
import io.micronaut.build.pom.CheckPomAction;
import io.micronaut.build.pom.PomDependency;
import io.micronaut.build.pom.PomFileAdapter;
import io.micronaut.build.pom.PomValidation;
import java.beans.Transient;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.GeneratedLambda;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class PomChecker
extends DefaultTask
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public PomChecker() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        String string = "Verifies a POM file";
        this.setDescription(string);
        String string2 = LifecycleBasePlugin.VERIFICATION_GROUP;
        this.setGroup(string2);
        this.getFailOnError().convention((Object)true);
        this.getFailOnSnapshots().convention(this.getPomCoordinates().map(new _lambda1(PomChecker.class, PomChecker.class)::doCall));
        this.getProjectGroup().convention(this.getProject().getProviders().gradleProperty("projectGroup").orElse(this.getProject().getProviders().gradleProperty("projectGroupId").orElse(this.getProject().provider((Callable)((Object)new _closure2((Object)this, (Object)this))))));
    }

    @Input
    public abstract ListProperty<String> getRepositories();

    @Input
    public abstract Property<String> getPomCoordinates();

    @Input
    public abstract Property<Boolean> getFailOnSnapshots();

    @Input
    public abstract Property<Boolean> getFailOnError();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    public abstract RegularFileProperty getPomFile();

    @Input
    @Optional
    public abstract Property<String> getProjectGroup();

    @Nested
    public abstract Property<BomSuppressions> getSuppressions();

    @OutputDirectory
    public abstract DirectoryProperty getReportDirectory();

    @org.gradle.api.tasks.Internal
    public abstract DirectoryProperty getPomsDirectory();

    @Inject
    public abstract WorkerExecutor getWorkerExecutor();

    @TaskAction
    public void verifyBom() {
        Set silencedDeps = (Set)ScriptBytecodeAdapter.castToType((Object)((BomSuppressions)this.getSuppressions().get()).getDependencies().get(), Set.class);
        Reference bomAuthorizedGroupIds = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)((BomSuppressions)this.getSuppressions().get()).getBomAuthorizedGroupIds().get(), Map.class)));
        Reference errorCollector = new Reference((Object)new ErrorCollector(silencedDeps));
        Object[] coordinates = ((String)this.getPomCoordinates().get()).split(":");
        if (coordinates.length != 3) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getPomCoordinates().get()}, new String[]{"Incorrect POM coordinates '", "': should be of the form group:artifact:version "})));
        }
        Reference queue = new Reference(new ArrayDeque());
        ((ArrayDeque)queue.get()).add(ScriptBytecodeAdapter.createList((Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])coordinates, (int)0), BytecodeInterface8.objectArrayGet((Object[])coordinates, (int)1), BytecodeInterface8.objectArrayGet((Object[])coordinates, (int)2), ((RegularFile)this.getPomFile().get()).getAsFile(), this.getPomCoordinates().get()}));
        Reference workQueue = new Reference((Object)this.getWorkerExecutor().noIsolation());
        Reference seen = new Reference((Object)((LinkedHashSet)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), LinkedHashSet.class)));
        while (!((ArrayDeque)queue.get()).isEmpty()) {
            Reference reports = new Reference((Object)((ArrayList)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), ArrayList.class)));
            public final class _verifyBom_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference seen;
                private /* synthetic */ Reference workQueue;
                private /* synthetic */ Reference reports;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _verifyBom_closure3(Object _outerInstance, Object _thisObject, Reference seen, Reference workQueue, Reference reports) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.seen = reference3 = seen;
                    this.workQueue = reference2 = workQueue;
                    this.reports = reference = reports;
                }

                public Object doCall(Object item) {
                    Reference group = new Reference(DefaultGroovyMethods.getAt((List)((List)ScriptBytecodeAdapter.castToType((Object)item, List.class)), (int)0));
                    Reference artifact = new Reference(DefaultGroovyMethods.getAt((List)((List)ScriptBytecodeAdapter.castToType((Object)item, List.class)), (int)1));
                    Reference version = new Reference(DefaultGroovyMethods.getAt((List)((List)ScriptBytecodeAdapter.castToType((Object)item, List.class)), (int)2));
                    Reference pomFile = new Reference(DefaultGroovyMethods.getAt((List)((List)ScriptBytecodeAdapter.castToType((Object)item, List.class)), (int)3));
                    Reference path = new Reference(DefaultGroovyMethods.getAt((List)((List)ScriptBytecodeAdapter.castToType((Object)item, List.class)), (int)4));
                    String key = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{group.get(), artifact.get(), version.get()}, new String[]{"", ":", ":", ""}));
                    if (((LinkedHashSet)this.seen.get()).add(key)) {
                        public final class _closure8
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference pomFile;
                            private /* synthetic */ Reference group;
                            private /* synthetic */ Reference artifact;
                            private /* synthetic */ Reference version;
                            private /* synthetic */ Reference path;
                            private /* synthetic */ Reference reports;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure8(Object _outerInstance, Object _thisObject, Reference pomFile, Reference group, Reference artifact, Reference version, Reference path, Reference reports) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                Reference reference5;
                                Reference reference6;
                                this.pomFile = reference6 = pomFile;
                                this.group = reference5 = group;
                                this.artifact = reference4 = artifact;
                                this.version = reference3 = version;
                                this.path = reference2 = path;
                                this.reports = reference = reports;
                            }

                            public Void doCall(CheckPomAction.Parameters params) {
                                params.getPomFile().set((File)ScriptBytecodeAdapter.castToType((Object)this.pomFile.get(), File.class));
                                params.getGroupId().set((Object)ShortTypeHandling.castToString((Object)this.group.get()));
                                params.getArtifactId().set((Object)ShortTypeHandling.castToString((Object)this.artifact.get()));
                                params.getVersion().set((Object)ShortTypeHandling.castToString((Object)this.version.get()));
                                params.getRepositories().set(((PomChecker)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PomChecker.class))).getRepositories());
                                params.getDependencyPath().set((Object)ShortTypeHandling.castToString((Object)this.path.get()));
                                Provider reportFile = ((PomChecker)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PomChecker.class))).getReportDirectory().file(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.group.get(), this.artifact.get(), this.version.get()}, new String[]{"", "-", "-", ".json"})));
                                ((ArrayList)this.reports.get()).add(((RegularFile)reportFile.get()).getAsFile());
                                params.getReportFile().set(reportFile);
                                params.getPomDirectory().set((Provider)((PomChecker)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PomChecker.class))).getPomsDirectory());
                                return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
                            }

                            @Generated
                            public Void call(CheckPomAction.Parameters params) {
                                return this.doCall(params);
                            }

                            @Generated
                            public Object getPomFile() {
                                return this.pomFile.get();
                            }

                            @Generated
                            public Object getGroup() {
                                return this.group.get();
                            }

                            @Generated
                            public Object getArtifact() {
                                return this.artifact.get();
                            }

                            @Generated
                            public Object getVersion() {
                                return this.version.get();
                            }

                            @Generated
                            public Object getPath() {
                                return this.path.get();
                            }

                            @Generated
                            public List getReports() {
                                return (List)ScriptBytecodeAdapter.castToType((Object)this.reports.get(), List.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure8.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        ((WorkQueue)this.workQueue.get()).submit(CheckPomAction.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure8((Object)this, this.getThisObject(), pomFile, group, artifact, version, path, this.reports)), Action.class));
                        return null;
                    }
                    return null;
                }

                @Generated
                public Set getSeen() {
                    return (Set)ScriptBytecodeAdapter.castToType((Object)this.seen.get(), Set.class);
                }

                @Generated
                public Object getWorkQueue() {
                    return this.workQueue.get();
                }

                @Generated
                public List getReports() {
                    return (List)ScriptBytecodeAdapter.castToType((Object)this.reports.get(), List.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _verifyBom_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((Collection)((ArrayDeque)queue.get()), (Closure)new _verifyBom_closure3((Object)this, (Object)this, seen, workQueue, reports));
            ((WorkQueue)workQueue.get()).await();
            ((ArrayDeque)queue.get()).clear();
            public final class _verifyBom_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference errorCollector;
                private /* synthetic */ Reference queue;
                private /* synthetic */ Reference bomAuthorizedGroupIds;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _verifyBom_closure4(Object _outerInstance, Object _thisObject, Reference errorCollector, Reference queue, Reference bomAuthorizedGroupIds) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.errorCollector = reference3 = errorCollector;
                    this.queue = reference2 = queue;
                    this.bomAuthorizedGroupIds = reference = bomAuthorizedGroupIds;
                }

                public List<PomDependency> doCall(Object it) {
                    Reference projectGroupId = new Reference((Object)ShortTypeHandling.castToString((Object)((PomChecker)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PomChecker.class))).getProjectGroup().getOrElse((Object)"io.micronaut")));
                    PomValidation validation = PomFileAdapter.parseFromFile((File)ScriptBytecodeAdapter.castToType((Object)it, File.class));
                    Reference bomPrefix = new Reference((Object)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{validation.getPomFile().getGroupId(), validation.getPomFile().getArtifactId(), validation.getPomFile().getVersion(), validation.getDependencyPath()}, new String[]{"POM ", ":", ":", " (via ", ")"})));
                    PomChecker.assertThatImportingBomIsAllowed(validation, (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)this.errorCollector.get(), ErrorCollector.class));
                    if (validation.getPomFile().isBom()) {
                        PomChecker.addTransitiveBomsToQueue(validation, (Deque)ScriptBytecodeAdapter.castToType((Object)this.queue.get(), Deque.class));
                        public final class _closure9
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure9(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Boolean doCall(Object it) {
                                return !((PomDependency)it).isManaged();
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Boolean doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure9.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        if (DefaultGroovyMethods.any(validation.getPomFile().getDependencies(), (Closure)new _closure9((Object)this, this.getThisObject()))) {
                            ((ErrorCollector)this.errorCollector.get()).getErrors().add(new GStringImpl(new Object[]{(String)bomPrefix.get()}, new String[]{"", " has dependencies outside of <dependencyManagement> block."}).toString());
                        }
                        Reference groupId = new Reference((Object)validation.getPomFile().getGroupId());
                        String artifactId = validation.getPomFile().getArtifactId();
                        String version = validation.getPomFile().getVersion();
                        Reference allowedGroups = new Reference((Object)((Set)ScriptBytecodeAdapter.castToType(((Map)this.bomAuthorizedGroupIds.get()).get(new GStringImpl(new Object[]{(String)groupId.get(), artifactId}, new String[]{"", ":", ""}).toString()), Set.class)));
                        if ((Set)allowedGroups.get() == null) {
                            allowedGroups.set((Object)((Set)ScriptBytecodeAdapter.castToType((Object)((Map)this.bomAuthorizedGroupIds.get()).getOrDefault(new GStringImpl(new Object[]{(String)groupId.get(), artifactId, version}, new String[]{"", ":", ":", ""}).toString(), (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)), Set.class)));
                        }
                        if (!((String)groupId.get()).startsWith((String)projectGroupId.get()) && !PomChecker.isMicronautBom((String)groupId.get(), artifactId)) {
                            public final class _closure10
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference groupId;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure10(Object _outerInstance, Object _thisObject, Reference groupId) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.groupId = reference = groupId;
                                }

                                public Boolean doCall(Object it) {
                                    return ((PomDependency)it).isManaged() && !((PomDependency)it).getGroupId().startsWith(ShortTypeHandling.castToString((Object)this.groupId.get()));
                                }

                                @Generated
                                public Object getGroupId() {
                                    return this.groupId.get();
                                }

                                @Generated
                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                @Generated
                                public Object call() {
                                    return this.doCall(null);
                                }

                                @Generated
                                public Boolean doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure10.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            public final class _closure11
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference bomPrefix;
                                private /* synthetic */ Reference groupId;
                                private /* synthetic */ Reference allowedGroups;
                                private /* synthetic */ Reference errorCollector;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure11(Object _outerInstance, Object _thisObject, Reference bomPrefix, Reference groupId, Reference allowedGroups, Reference errorCollector) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    Reference reference2;
                                    Reference reference3;
                                    Reference reference4;
                                    this.bomPrefix = reference4 = bomPrefix;
                                    this.groupId = reference3 = groupId;
                                    this.allowedGroups = reference2 = allowedGroups;
                                    this.errorCollector = reference = errorCollector;
                                }

                                public Object doCall(Object it) {
                                    String dependency = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((PomDependency)it).getGroupId(), ((PomDependency)it).getArtifactId(), ((PomDependency)it).getVersion()}, new String[]{"", ":", ":", ""}));
                                    String message = new GStringImpl(new Object[]{this.bomPrefix.get(), dependency, this.groupId.get()}, new String[]{"", " declares dependency on ", " which doesn't belong to group ", "."}).toString();
                                    if (((Set)this.allowedGroups.get()).contains(((PomDependency)it).getGroupId())) {
                                        ((ErrorCollector)this.errorCollector.get()).silenced(message);
                                        return null;
                                    }
                                    ((ErrorCollector)this.errorCollector.get()).error(dependency, message);
                                    return null;
                                }

                                @Generated
                                public String getBomPrefix() {
                                    return ShortTypeHandling.castToString((Object)this.bomPrefix.get());
                                }

                                @Generated
                                public Object getGroupId() {
                                    return this.groupId.get();
                                }

                                @Generated
                                public Set getAllowedGroups() {
                                    return (Set)ScriptBytecodeAdapter.castToType((Object)this.allowedGroups.get(), Set.class);
                                }

                                @Generated
                                public ErrorCollector getErrorCollector() {
                                    return (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)this.errorCollector.get(), ErrorCollector.class);
                                }

                                @Generated
                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                @Generated
                                public Object call() {
                                    return this.doCall(null);
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure11.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            DefaultGroovyMethods.each((List)DefaultGroovyMethods.findAll(validation.getPomFile().getDependencies(), (Closure)new _closure10((Object)this, this.getThisObject(), groupId)), (Closure)new _closure11((Object)this, this.getThisObject(), bomPrefix, groupId, allowedGroups, this.errorCollector));
                        }
                    }
                    public final class _closure12
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference projectGroupId;
                        private /* synthetic */ Reference errorCollector;
                        private /* synthetic */ Reference bomPrefix;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure12(Object _outerInstance, Object _thisObject, Reference projectGroupId, Reference errorCollector, Reference bomPrefix) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            this.projectGroupId = reference3 = projectGroupId;
                            this.errorCollector = reference2 = errorCollector;
                            this.bomPrefix = reference = bomPrefix;
                        }

                        public Object doCall(Object it) {
                            if (!((String)it).startsWith(ShortTypeHandling.castToString((Object)this.projectGroupId.get())) && !((String)it).endsWith("-SNAPSHOT")) {
                                ((ErrorCollector)this.errorCollector.get()).error(ShortTypeHandling.castToString((Object)it), new GStringImpl(new Object[]{this.bomPrefix.get(), it}, new String[]{"", " declares a non-resolvable dependency: ", ""}).toString());
                                return null;
                            }
                            return null;
                        }

                        @Generated
                        public String getProjectGroupId() {
                            return ShortTypeHandling.castToString((Object)this.projectGroupId.get());
                        }

                        @Generated
                        public ErrorCollector getErrorCollector() {
                            return (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)this.errorCollector.get(), ErrorCollector.class);
                        }

                        @Generated
                        public String getBomPrefix() {
                            return ShortTypeHandling.castToString((Object)this.bomPrefix.get());
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure12.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    DefaultGroovyMethods.each(validation.getInvalidDependencies(), (Closure)new _closure12((Object)this, this.getThisObject(), projectGroupId, this.errorCollector, bomPrefix));
                    Object object = ((PomChecker)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), PomChecker.class))).getFailOnSnapshots().get();
                    if (object == null ? false : (Boolean)object) {
                        public final class _closure13
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference projectGroupId;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure13(Object _outerInstance, Object _thisObject, Reference projectGroupId) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.projectGroupId = reference = projectGroupId;
                            }

                            public Boolean doCall(Object it) {
                                return !((PomDependency)it).getGroupId().equals(this.projectGroupId.get()) && ((PomDependency)it).getVersion().endsWith("-SNAPSHOT");
                            }

                            @Generated
                            public String getProjectGroupId() {
                                return ShortTypeHandling.castToString((Object)this.projectGroupId.get());
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Boolean doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure13.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        public final class _closure14
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference errorCollector;
                            private /* synthetic */ Reference bomPrefix;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure14(Object _outerInstance, Object _thisObject, Reference errorCollector, Reference bomPrefix) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                this.errorCollector = reference2 = errorCollector;
                                this.bomPrefix = reference = bomPrefix;
                            }

                            public Object doCall(Object it) {
                                String dependency = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((PomDependency)it).getGroupId(), ((PomDependency)it).getArtifactId(), ((PomDependency)it).getVersion()}, new String[]{"", ":", ":", ""}));
                                ((ErrorCollector)this.errorCollector.get()).error(dependency, new GStringImpl(new Object[]{this.bomPrefix.get(), dependency}, new String[]{"", " declares a SNAPSHOT dependency on ", ""}).toString());
                                return null;
                            }

                            @Generated
                            public ErrorCollector getErrorCollector() {
                                return (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)this.errorCollector.get(), ErrorCollector.class);
                            }

                            @Generated
                            public String getBomPrefix() {
                                return ShortTypeHandling.castToString((Object)this.bomPrefix.get());
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure14.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        return DefaultGroovyMethods.each((List)DefaultGroovyMethods.findAll(validation.getPomFile().getDependencies(), (Closure)new _closure13((Object)this, this.getThisObject(), projectGroupId)), (Closure)new _closure14((Object)this, this.getThisObject(), this.errorCollector, bomPrefix));
                    }
                    return (List)ScriptBytecodeAdapter.castToType(null, List.class);
                }

                @Generated
                public ErrorCollector getErrorCollector() {
                    return (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)this.errorCollector.get(), ErrorCollector.class);
                }

                @Generated
                public Object getQueue() {
                    return this.queue.get();
                }

                @Generated
                public Map getBomAuthorizedGroupIds() {
                    return (Map)ScriptBytecodeAdapter.castToType((Object)this.bomAuthorizedGroupIds.get(), Map.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public List<PomDependency> doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _verifyBom_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((List)((ArrayList)reports.get()), (Closure)new _verifyBom_closure4((Object)this, (Object)this, errorCollector, queue, bomAuthorizedGroupIds));
        }
        File reportFile = this.writeReport(((ErrorCollector)errorCollector.get()).getErrors());
        if (DefaultTypeTransformation.booleanUnbox((Object)this.getFailOnError().get()) && DefaultTypeTransformation.booleanUnbox(((ErrorCollector)errorCollector.get()).getErrors())) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{reportFile}, new String[]{"POM verification failed. See report in ", ""})));
        }
    }

    private static boolean isMicronautBom(String groupId, String artifactId) {
        return groupId.startsWith("io.micronaut") && artifactId.contains("bom");
    }

    private File writeReport(List<String> errors) {
        Reference errors2 = new Reference(errors);
        File reportFile = ((RegularFile)this.getReportDirectory().file(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getName()}, new String[]{"report-", ".txt"}))).get()).getAsFile();
        public final class _writeReport_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference errors;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _writeReport_closure5(Object _outerInstance, Object _thisObject, Reference errors) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.errors = reference = errors;
            }

            public List<String> doCall(Object writer) {
                Reference writer2 = new Reference(writer);
                public final class _closure15
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference writer;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure15(Object _outerInstance, Object _thisObject, Reference writer) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.writer = reference = writer;
                    }

                    public Object doCall(Object it) {
                        DefaultGroovyMethods.println((Object)this.getThisObject(), (Object)it);
                        DefaultGroovyMethods.println((Object)this.writer.get(), (Object)it);
                        return null;
                    }

                    @Generated
                    public Object getWriter() {
                        return this.writer.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure15.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.each((List)((List)ScriptBytecodeAdapter.castToType((Object)this.errors.get(), List.class)), (Closure)new _closure15((Object)this, this.getThisObject(), writer2));
            }

            @Generated
            public List getErrors() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.errors.get(), List.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _writeReport_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ResourceGroovyMethods.withWriter((File)reportFile, (Closure)new _writeReport_closure5((Object)this, (Object)this, errors2));
        return reportFile;
    }

    /*
     * WARNING - void declaration
     */
    private static void addTransitiveBomsToQueue(PomValidation validation, Deque<List<Object>> queue) {
        void var1_1;
        Reference validation2 = new Reference((Object)validation);
        Reference queue2 = new Reference((Object)var1_1);
        public final class _addTransitiveBomsToQueue_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference validation;
            private /* synthetic */ Reference queue;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addTransitiveBomsToQueue_closure6(Object _outerInstance, Object _thisObject, Reference validation, Reference queue) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.validation = reference2 = validation;
                this.queue = reference = queue;
            }

            public Boolean doCall(Object gav, Object file) {
                Object[] coord = ((String)gav).split(":");
                Reference group = new Reference((Object)ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])coord, (int)0)));
                Reference artifact = new Reference((Object)ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])coord, (int)1)));
                Reference version = new Reference((Object)ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])coord, (int)2)));
                public final class _closure16
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference group;
                    private /* synthetic */ Reference artifact;
                    private /* synthetic */ Reference version;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure16(Object _outerInstance, Object _thisObject, Reference group, Reference artifact, Reference version) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.group = reference3 = group;
                        this.artifact = reference2 = artifact;
                        this.version = reference = version;
                    }

                    public Boolean doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)((PomDependency)it).getGroupId(), (Object)this.group.get()) && ScriptBytecodeAdapter.compareEqual((Object)((PomDependency)it).getArtifactId(), (Object)this.artifact.get()) && ScriptBytecodeAdapter.compareEqual((Object)((PomDependency)it).getVersion(), (Object)this.version.get());
                    }

                    @Generated
                    public String getGroup() {
                        return ShortTypeHandling.castToString((Object)this.group.get());
                    }

                    @Generated
                    public String getArtifact() {
                        return ShortTypeHandling.castToString((Object)this.artifact.get());
                    }

                    @Generated
                    public String getVersion() {
                        return ShortTypeHandling.castToString((Object)this.version.get());
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Boolean doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure16.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                PomDependency dependency = (PomDependency)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find(((PomValidation)this.validation.get()).getPomFile().getDependencies(), (Closure)new _closure16((Object)this, this.getThisObject(), group, artifact, version)), PomDependency.class);
                if (dependency.isManaged() && dependency.isImport()) {
                    return ((Deque)this.queue.get()).add(ScriptBytecodeAdapter.createList((Object[])new Object[]{(String)group.get(), (String)artifact.get(), (String)version.get(), new File(ShortTypeHandling.castToString((Object)file)), new GStringImpl(new Object[]{((PomValidation)this.validation.get()).getDependencyPath(), gav}, new String[]{"", " -> ", ""}).toString()}));
                }
                return (Boolean)ScriptBytecodeAdapter.castToType(null, Boolean.class);
            }

            @Generated
            public Boolean call(Object gav, Object file) {
                return this.doCall(gav, file);
            }

            @Generated
            public PomValidation getValidation() {
                return (PomValidation)ScriptBytecodeAdapter.castToType((Object)this.validation.get(), PomValidation.class);
            }

            @Generated
            public Deque getQueue() {
                return (Deque)ScriptBytecodeAdapter.castToType((Object)this.queue.get(), Deque.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addTransitiveBomsToQueue_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(((PomValidation)validation2.get()).getValidDependencies(), (Closure)new _addTransitiveBomsToQueue_closure6(PomChecker.class, PomChecker.class, validation2, queue2));
    }

    /*
     * WARNING - void declaration
     */
    private static void assertThatImportingBomIsAllowed(PomValidation validation, ErrorCollector errors) {
        void var1_1;
        Reference validation2 = new Reference((Object)validation);
        Reference errors2 = new Reference((Object)var1_1);
        if (((PomValidation)validation2.get()).getPomFile().isBom() && ((PomValidation)validation2.get()).getPomFile().isImportingBom() && !((PomValidation)validation2.get()).getPomFile().getGroupId().startsWith("io.micronaut")) {
            public final class _assertThatImportingBomIsAllowed_closure7
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference errors;
                private /* synthetic */ Reference validation;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _assertThatImportingBomIsAllowed_closure7(Object _outerInstance, Object _thisObject, Reference errors, Reference validation) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.errors = reference2 = errors;
                    this.validation = reference = validation;
                }

                public Object doCall(Object it) {
                    String dependency = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((PomDependency)it).getGroupId(), ((PomDependency)it).getArtifactId(), ((PomDependency)it).getVersion()}, new String[]{"", ":", ":", ""}));
                    ((ErrorCollector)this.errors.get()).error(dependency, new GStringImpl(new Object[]{((PomValidation)this.validation.get()).getPomFile().getGroupId(), ((PomValidation)this.validation.get()).getPomFile().getArtifactId(), ((PomValidation)this.validation.get()).getPomFile().getVersion(), ((PomValidation)this.validation.get()).getDependencyPath(), dependency}, new String[]{"BOM ", ":", ":", " (via ", ") is not a Micronaut BOM but it imports another BOM (", ")"}).toString());
                    return null;
                }

                @Generated
                public ErrorCollector getErrors() {
                    return (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)this.errors.get(), ErrorCollector.class);
                }

                @Generated
                public PomValidation getValidation() {
                    return (PomValidation)ScriptBytecodeAdapter.castToType((Object)this.validation.get(), PomValidation.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _assertThatImportingBomIsAllowed_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(((PomValidation)validation2.get()).getPomFile().findImports(), (Closure)new _assertThatImportingBomIsAllowed_closure7(PomChecker.class, PomChecker.class, errors2, validation2));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != PomChecker.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PomChecker.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PomChecker.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PomChecker.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, PomChecker.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(PomChecker.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static class ErrorCollector
    implements GroovyObject {
        private final Set<String> silencedDependencies;
        private final List<String> errors;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public ErrorCollector(Set<String> silencedDependencies) {
            MetaClass metaClass;
            List list;
            this.errors = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Set<String> set = silencedDependencies;
            this.silencedDependencies = set;
        }

        public void silenced(String message) {
            DefaultGroovyMethods.println((Object)this, (Object)new GStringImpl(new Object[]{message}, new String[]{"[Silenced] ", ""}));
        }

        public void error(String dependency, String message) {
            if (!this.silencedDependencies.contains(dependency)) {
                DefaultGroovyMethods.leftShift(this.errors, (Object)message);
            } else {
                this.silenced(message);
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ErrorCollector.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(ErrorCollector.class, PomChecker.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(ErrorCollector.class, PomChecker.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(ErrorCollector.class, PomChecker.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(ErrorCollector.class, PomChecker.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(ErrorCollector.class, PomChecker.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(ErrorCollector.class, PomChecker.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PomChecker.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PomChecker.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ErrorCollector.class, PomChecker.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ErrorCollector.class, PomChecker.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public final List<String> getErrors() {
            return this.errors;
        }
    }

    public final class _lambda1
    extends Closure
    implements GeneratedLambda {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _lambda1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public OUT doCall(String v) {
            return !v.endsWith("-SNAPSHOT");
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _lambda1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure2
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure2(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public String doCall(Object it) {
            return String.valueOf(((PomChecker)((DefaultTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DefaultTask.class))).getProject().getGroup());
        }

        @Generated
        public Object call(Object args) {
            return this.doCall(args);
        }

        @Generated
        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public String doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

