/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.docs;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.micronaut.docs.converter.YamlFormatConverter;
import java.beans.Transient;
import java.util.Map;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.ContentModel;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.Contexts;
import org.asciidoctor.extension.Name;
import org.asciidoctor.extension.Reader;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

@Name(value="configuration")
@Contexts(value={":listing"})
@ContentModel(value=":compound")
public class ConfigurationPropertiesMacro
extends BlockProcessor
implements GroovyObject {
    private final Asciidoctor asciidoctor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ConfigurationPropertiesMacro(Asciidoctor asciidoctor) {
        Asciidoctor asciidoctor2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.asciidoctor = asciidoctor2 = asciidoctor;
    }

    public Object process(StructuralNode parent, Reader reader, Map<String, Object> attributes) {
        String content = reader.read();
        String title = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(attributes, (Object)"title"));
        YamlFormatConverter converter = new YamlFormatConverter(content);
        Block compound = this.createBlock(parent, "open", "", attributes);
        Block javaProperties = this.createBlock((StructuralNode)compound, "pass", this.toLanguageSample(converter.toJavaProperties(), "properties", title));
        compound.append((StructuralNode)javaProperties);
        Block yaml = this.createBlock((StructuralNode)compound, "pass", this.toLanguageSample(content, "yaml", title));
        compound.append((StructuralNode)yaml);
        Block toml = this.createBlock((StructuralNode)compound, "pass", this.toLanguageSample(converter.toToml(), "toml", title));
        compound.append((StructuralNode)toml);
        Block groovy = this.createBlock((StructuralNode)compound, "pass", this.toLanguageSample(converter.toGroovy(), "groovy-config", title));
        compound.append((StructuralNode)groovy);
        Block hocon = this.createBlock((StructuralNode)compound, "pass", this.toLanguageSample(converter.toHocon(), "hocon", title));
        compound.append((StructuralNode)hocon);
        Block json = this.createBlock((StructuralNode)compound, "pass", this.toLanguageSample(converter.toJson(), "json-config", title));
        compound.append((StructuralNode)json);
        return compound;
    }

    private String toLanguageSample(String sample, String language, String title) {
        Options options = Options.builder().attributes(Attributes.builder().attribute("source-highlighter", (Object)"highlightjs").build()).build();
        String maybeTitle = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)title) ? new GStringImpl(new Object[]{title}, new String[]{",", ""}) : ""));
        return this.asciidoctor.convert(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{language, maybeTitle, sample}, new String[]{"\n[source.multi-language-sample,", "", "]\n----\n", "\n----\n"})), options);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ConfigurationPropertiesMacro.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

