/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.docs.converter;

import io.micronaut.docs.converter.AbstractModelVisitor;
import io.micronaut.docs.converter.ModelVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;

public class ConfigSlurperGenerator
extends AbstractModelVisitor {
    private static final String INDENT = "  ";
    private static final Pattern NON_ASCII_CHARS = Pattern.compile("[^\\p{ASCII}]");
    private static final Set<String> KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("default", "while", "for", "break", "continue", "if", "else", "switch", "case", "return", "try", "catch", "finally", "throw", "this", "super", "new", "def", "in", "as", "assert", "abstract", "final", "native", "private", "protected", "public", "static", "strictfp", "synchronized", "transient", "volatile", "class", "enum", "interface", "extends", "implements", "import", "package", "instanceof", "boolean", "byte", "char", "double", "float", "int", "long", "short", "void", "null", "true", "false")));

    public ConfigSlurperGenerator(Map<String, Object> model) {
        super(model);
    }

    private void indent(ModelVisitor.Context context) {
        for (int i = 0; i < context.depth() - 1; ++i) {
            this.append(INDENT);
        }
    }

    @Override
    public void preVisitMap(ModelVisitor.Context context, Map<String, Object> map) {
        if (context.depth() > 0) {
            this.append("{").append("\n");
        }
    }

    @Override
    public void postVisitMap(ModelVisitor.Context context, Map<String, Object> map) {
        if (context.depth() > 0) {
            this.indent(context);
            this.append("}");
        }
    }

    @Override
    public void visitMapEntry(ModelVisitor.Context context, String entryKey, Object entryValue, boolean isLast) {
        this.indent(context);
        String escaped = ConfigSlurperGenerator.escapeToken(entryKey);
        this.append(escaped);
        if (ModelVisitor.kindOf(entryValue) == ModelVisitor.NodeKind.MAP) {
            this.append(" ");
        } else {
            this.append(" = ");
        }
        this.visit(context, entryValue);
    }

    @Override
    public void postVisitMapEntry(ModelVisitor.Context context, String entryKey, Object entryValue, boolean isLast) {
        this.append("\n");
    }

    @Override
    public void preVisitMapEntry(ModelVisitor.Context context, String entryKey, Object entryValue, boolean isLast) {
    }

    @Override
    public void preVisitList(ModelVisitor.Context context, List<Object> list) {
        this.append("[");
    }

    @Override
    public void postVisitList(ModelVisitor.Context context, List<Object> list) {
        this.append("]");
    }

    @Override
    public void preVisitListItem(ModelVisitor.Context context, Object item, boolean isLastItem) {
    }

    @Override
    public void postVisitListItem(ModelVisitor.Context context, Object item, boolean isLastItem) {
        if (!isLastItem) {
            this.append(", ");
        }
    }

    @Override
    public void visitListItem(ModelVisitor.Context context, Object item, boolean isLastItem) {
        this.visit(context, item);
    }

    @Override
    public void visitObject(ModelVisitor.Context context, Object object) {
        this.append(object);
    }

    @Override
    public void visitString(ModelVisitor.Context context, String value) {
        this.append("\"").append(StringEscapeUtils.escapeJava((String)value)).append("\"");
    }

    private static String escapeToken(String text) {
        if (KEYWORDS.contains(text) || NON_ASCII_CHARS.matcher(text).find()) {
            return "'" + text + "'";
        }
        String capitalized = Arrays.stream(text.split("-")).map(s -> s.substring(0, 1).toUpperCase(Locale.ENGLISH) + s.substring(1)).collect(Collectors.joining());
        return text.charAt(0) + capitalized.substring(1);
    }
}

