/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.docs.converter;

import io.micronaut.docs.converter.AbstractModelVisitor;
import io.micronaut.docs.converter.ModelVisitor;
import java.util.List;
import java.util.Map;
import org.tomlj.Toml;
import org.tomlj.TomlParseResult;

public class TomlGenerator
extends AbstractModelVisitor {
    public TomlGenerator(Map<String, Object> model) {
        super(model);
    }

    @Override
    public void preVisitMapEntry(ModelVisitor.Context context, String entryKey, Object entryValue, boolean isLast) {
        boolean addQuotes;
        String escaped = Toml.tomlEscape((String)entryKey).toString();
        boolean bl = addQuotes = !escaped.equals(entryKey) || entryKey.contains(".");
        if (addQuotes) {
            this.append("\"");
        }
        this.append(escaped);
        if (addQuotes) {
            this.append("\"");
        }
        this.append(" = ");
    }

    @Override
    public void postVisitMapEntry(ModelVisitor.Context context, String entryKey, Object entryValue, boolean isLast) {
        if (context.depth() == 1) {
            this.append("\n");
        } else if (context.depth() > 1 && !isLast) {
            this.append(", ");
        }
    }

    @Override
    public void preVisitMap(ModelVisitor.Context context, Map<String, Object> map) {
        if (context.depth() > 0) {
            this.append("{");
        }
    }

    @Override
    public void postVisitMap(ModelVisitor.Context context, Map<String, Object> map) {
        if (context.depth() > 0) {
            this.append("}");
        }
    }

    @Override
    public void visitMapEntry(ModelVisitor.Context context, String entryKey, Object entryValue, boolean isLast) {
        this.visit(context, entryValue);
    }

    @Override
    public void preVisitList(ModelVisitor.Context context, List<Object> list) {
        this.append("[");
    }

    @Override
    public void postVisitList(ModelVisitor.Context context, List<Object> list) {
        this.append("]");
    }

    @Override
    public void preVisitListItem(ModelVisitor.Context context, Object item, boolean isLastItem) {
    }

    @Override
    public void postVisitListItem(ModelVisitor.Context context, Object item, boolean isLastItem) {
        if (!isLastItem) {
            this.append(", ");
        }
    }

    @Override
    public void visitListItem(ModelVisitor.Context context, Object item, boolean isLastItem) {
        this.visit(context, item);
    }

    @Override
    public void visitObject(ModelVisitor.Context context, Object object) {
        this.append(object);
    }

    @Override
    public void visitString(ModelVisitor.Context context, String value) {
        this.append("\"").append((CharSequence)Toml.tomlEscape((String)value)).append("\"");
    }

    @Override
    public String toString() {
        TomlParseResult toml = Toml.parse((String)super.toString());
        toml.errors().stream().forEach(System.err::println);
        return toml.toToml();
    }
}

