/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.docs.converter;

import io.micronaut.docs.converter.AbstractModelVisitor;
import io.micronaut.docs.converter.ConfigSlurperGenerator;
import io.micronaut.docs.converter.HoconGenerator;
import io.micronaut.docs.converter.JavaPropertiesGenerator;
import io.micronaut.docs.converter.JsonGenerator;
import io.micronaut.docs.converter.TomlGenerator;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlFormatConverter {
    private final Map<String, Object> model = new LinkedHashMap<String, Object>();

    public YamlFormatConverter(String content) {
        Yaml yaml = new Yaml();
        try {
            Iterable objects = yaml.loadAll(content);
            for (Object object : objects) {
                if (object instanceof Map) {
                    this.model.putAll((Map)object);
                    continue;
                }
                throw new YAMLException("Unexpected YAML object type: " + object.getClass());
            }
        }
        catch (YAMLException e) {
            System.err.println("Invalid sample YAML discovered:\n");
            System.err.println("----");
            System.err.println(content);
            System.err.println("----");
            throw e;
        }
    }

    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.model);
    }

    public String toToml() {
        return this.convert(new TomlGenerator(this.model));
    }

    public String toJavaProperties() {
        return this.convert(new JavaPropertiesGenerator(this.model));
    }

    public String toHocon() {
        return this.convert(new HoconGenerator(this.model));
    }

    public String toJson() {
        return this.convert(new JsonGenerator(this.model));
    }

    public String toGroovy() {
        return this.convert(new ConfigSlurperGenerator(this.model));
    }

    private String convert(AbstractModelVisitor generator) {
        generator.visit();
        return generator.toString();
    }
}

