/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import io.micronaut.build.BomSupport;
import io.micronaut.build.catalogs.internal.LenientVersionCatalogParser;
import io.micronaut.build.catalogs.internal.RichVersion;
import io.micronaut.build.catalogs.internal.VersionCatalogTomlModel;
import io.micronaut.build.catalogs.internal.VersionModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.initialization.Settings;
import org.gradle.api.initialization.resolve.DependencyResolutionManagement;
import org.gradle.api.initialization.resolve.RepositoriesMode;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MicronautBuildSettingsExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicronautBuildSettingsExtension.class);
    private final AtomicBoolean repositoriesAdded = new AtomicBoolean();
    private final Settings settings;
    private final String micronautVersion;
    private final String micronautTestVersion;
    private final String micronautLoggingVersion;
    private final VersionCatalogTomlModel versionCatalogTomlModel;

    public abstract Property<Boolean> getUseLocalCache();

    public abstract Property<Boolean> getUseRemoteCache();

    public abstract Property<Boolean> getUseStandardizedProjectNames();

    public abstract ListProperty<String> getNonStandardProjectPathPrefixes();

    public abstract ListProperty<String> getNonStandardProjectNamePrefixes();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    public MicronautBuildSettingsExtension(ProviderFactory providers, Settings settings) {
        this.settings = settings;
        this.getUseLocalCache().convention(MicronautBuildSettingsExtension.booleanProvider(providers, "localCache", true));
        this.getUseRemoteCache().convention(MicronautBuildSettingsExtension.booleanProvider(providers, "remoteCache", true));
        this.getUseStandardizedProjectNames().convention((Object)false);
        this.getNonStandardProjectPathPrefixes().set(Collections.singletonList(":examples:"));
        this.getNonStandardProjectNamePrefixes().set(Arrays.asList("micronaut-", "test-suite"));
        this.versionCatalogTomlModel = this.loadVersionCatalogTomlModel();
        this.micronautVersion = this.determineMicronautVersion();
        this.micronautTestVersion = this.determineMicronautTestVersion();
        this.micronautLoggingVersion = this.determineMicronautLoggingVersion();
        settings.getDependencyResolutionManagement().getVersionCatalogs().configureEach(catalog -> {
            Provider overrideFile;
            String prefix = "override." + catalog.getName() + ".";
            Provider provider = providers.gradlePropertiesPrefixedBy(prefix);
            if (provider.isPresent()) {
                for (Map.Entry entry : ((Map)provider.get()).entrySet()) {
                    String key = ((String)entry.getKey()).substring(prefix.length());
                    String version = (String)entry.getValue();
                    catalog.version(key, version);
                    LOGGER.info("Overriding {} version to {}", (Object)key, (Object)version);
                }
            }
            if ((overrideFile = providers.gradleProperty("override.file." + catalog.getName())).isPresent()) {
                try {
                    List<String> overrides = Files.readAllLines(Path.of((String)overrideFile.get(), new String[0]));
                    for (String override : overrides) {
                        String[] entry = override.split("=");
                        if (entry.length != 2) continue;
                        String key = entry[0].trim();
                        String version = entry[1].trim();
                        catalog.version(key, version);
                        LOGGER.info("Overriding {} version to {}", (Object)key, (Object)version);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private VersionCatalogTomlModel loadVersionCatalogTomlModel() {
        File versionCatalog = new File(this.settings.getRootDir(), "gradle/libs.versions.toml");
        if (versionCatalog.exists()) {
            VersionCatalogTomlModel versionCatalogTomlModel;
            block9: {
                LenientVersionCatalogParser parser = new LenientVersionCatalogParser();
                InputStream in = Files.newInputStream(versionCatalog.toPath(), new OpenOption[0]);
                try {
                    parser.parse(in);
                    versionCatalogTomlModel = parser.getModel();
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                in.close();
            }
            return versionCatalogTomlModel;
        }
        return null;
    }

    public String getMicronautVersion() {
        return this.micronautVersion;
    }

    private String determineMicronautVersion() {
        return this.determineMicronautVersion("micronaut");
    }

    private String determineMicronautTestVersion() {
        return this.determineMicronautVersion("micronaut-test");
    }

    private String determineMicronautLoggingVersion() {
        return this.determineMicronautVersion("micronaut-logging");
    }

    private String determineMicronautVersion(String moduleNameKebabCase) {
        Optional<VersionModel> micronaut;
        Optional<Object> micronautVersion = Optional.empty();
        if (this.versionCatalogTomlModel != null && (micronaut = this.versionCatalogTomlModel.findVersion(moduleNameKebabCase)).isPresent()) {
            micronautVersion = Optional.ofNullable(micronaut.get().getVersion().getRequire());
        }
        if (!micronautVersion.isPresent()) {
            String capitalizedName = moduleNameKebabCase.charAt(0) + Arrays.stream(moduleNameKebabCase.split("-")).map(StringUtils::capitalize).collect(Collectors.joining()).substring(1) + "Version";
            micronautVersion = Optional.ofNullable((String)this.getProviders().gradleProperty(capitalizedName).getOrNull());
        }
        return micronautVersion.orElse(null);
    }

    public void importMicronautCatalog() {
        if (this.micronautVersion != null) {
            this.settings.dependencyResolutionManagement(mgmt -> {
                this.configureRepositories((DependencyResolutionManagement)mgmt);
                String artifactId = BomSupport.coreBomArtifactId(this.micronautVersion);
                mgmt.getVersionCatalogs().create("mn", catalog -> catalog.from((Object)("io.micronaut:" + artifactId + ":" + this.micronautVersion)));
            });
        }
        if (this.micronautTestVersion != null) {
            this.settings.getGradle().settingsEvaluated(unused -> this.settings.dependencyResolutionManagement(mgmt -> {
                this.configureRepositories((DependencyResolutionManagement)mgmt);
                if (mgmt.getVersionCatalogs().findByName("mnTest") == null) {
                    mgmt.getVersionCatalogs().create("mnTest", catalog -> catalog.from((Object)("io.micronaut.test:micronaut-test-bom:" + this.micronautTestVersion)));
                } else {
                    LOGGER.warn("Version catalog 'mnTest' can be automatically imported. You can remove it from settings.gradle(.kts) file.");
                }
            }));
        }
        if (this.micronautLoggingVersion != null) {
            this.settings.getGradle().settingsEvaluated(unused -> this.settings.dependencyResolutionManagement(mgmt -> {
                this.configureRepositories((DependencyResolutionManagement)mgmt);
                if (mgmt.getVersionCatalogs().findByName("mnLogging") == null) {
                    mgmt.getVersionCatalogs().create("mnLogging", catalog -> catalog.from((Object)("io.micronaut.logging:micronaut-logging-bom:" + this.micronautLoggingVersion)));
                } else {
                    LOGGER.warn("Version catalog 'mnLogging' can be automatically imported. You can remove it from settings.gradle(.kts) file.");
                }
            }));
        }
    }

    private void configureRepositories(DependencyResolutionManagement mgmt) {
        if (this.repositoriesAdded.compareAndSet(false, true)) {
            mgmt.getRepositoriesMode().set((Object)RepositoriesMode.PREFER_PROJECT);
            mgmt.repositories(RepositoryHandler::mavenCentral);
        }
    }

    public void importMicronautCatalogFromGAV(String gavCoordinates) {
        this.settings.dependencyResolutionManagement(mgmt -> {
            Object name;
            this.configureRepositories((DependencyResolutionManagement)mgmt);
            List<String> parts = Arrays.asList(gavCoordinates.split(":"));
            String groupId = parts.get(0);
            String artifactId = parts.get(1);
            if (MicronautBuildSettingsExtension.isMicronautPlatform(groupId, artifactId)) {
                throw new IllegalStateException("Projects must not import the platform BOM or it would create a cyclic dependency. Please use the core BOM instead.");
            }
            if (parts.size() == 3) {
                name = "mn";
                if (artifactId.startsWith("micronaut-")) {
                    artifactId = artifactId.substring("micronaut-".length());
                }
                if (artifactId.endsWith("-bom")) {
                    artifactId = artifactId.substring(0, artifactId.length() - 4);
                }
            } else {
                throw new IllegalStateException("Invalid version catalog GAV coordinates: " + gavCoordinates + ". Expected format: group:artifact:version");
            }
            name = (String)name + Arrays.stream(artifactId.split("-")).map(StringUtils::capitalize).collect(Collectors.joining());
            mgmt.getVersionCatalogs().create((String)name, catalog -> catalog.from((Object)gavCoordinates));
        });
    }

    private static boolean isMicronautPlatform(String groupId, String artifactId) {
        return "micronaut-bom".equals(groupId) && "micronaut-bom".equals(artifactId) || "micronaut-platform".equals(groupId) && "micronaut-platform".equals(artifactId);
    }

    public void importMicronautCatalog(String alias) {
        this.settings.dependencyResolutionManagement(mgmt -> {
            Object name;
            this.configureRepositories((DependencyResolutionManagement)mgmt);
            String gavCoordinates = this.versionCatalogTomlModel.getLibrariesTable().stream().filter(lib -> lib.getAlias().equals(alias)).findFirst().map(library -> {
                String version = library.getVersion().getReference() != null ? (String)this.versionCatalogTomlModel.findVersion(library.getVersion().getReference()).map(VersionModel::getVersion).map(RichVersion::getRequire).orElse(null) : library.getVersion().getVersion().getRequire();
                return library.getGroup() + ":" + library.getName() + ":" + version;
            }).orElseThrow(() -> new IllegalStateException("Version catalog doesn't contain a library with alias: " + alias));
            List<String> parts = Arrays.asList(gavCoordinates.split(":"));
            String groupId = parts.get(0);
            String artifactId = parts.get(1);
            if (MicronautBuildSettingsExtension.isMicronautPlatform(groupId, artifactId)) {
                throw new IllegalStateException("Projects must not import the platform BOM or it would create a cyclic dependency. Please use the core BOM instead.");
            }
            if (parts.size() == 3) {
                name = "mn";
                if (artifactId.startsWith("micronaut-")) {
                    artifactId = artifactId.substring("micronaut-".length());
                }
                if (artifactId.endsWith("-bom")) {
                    artifactId = artifactId.substring(0, artifactId.length() - 4);
                }
            } else {
                throw new IllegalStateException("Invalid version catalog GAV coordinates: " + gavCoordinates + ". Expected format: group:artifact:version");
            }
            name = (String)name + Arrays.stream(artifactId.split("-")).map(StringUtils::capitalize).collect(Collectors.joining());
            mgmt.getVersionCatalogs().create((String)name, catalog -> catalog.from((Object)gavCoordinates));
        });
    }

    public void addSnapshotRepository() {
        this.settings.dependencyResolutionManagement(mgmt -> {
            this.configureRepositories((DependencyResolutionManagement)mgmt);
            mgmt.repositories(repos -> repos.maven(repo -> repo.setUrl((Object)"https://s01.oss.sonatype.org/content/repositories/snapshots")));
        });
    }

    static Provider<Boolean> booleanProvider(ProviderFactory providers, String gradleProperty, boolean defaultValue) {
        return providers.gradleProperty(gradleProperty).map(Boolean::parseBoolean).orElse((Object)defaultValue);
    }
}

