/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import io.micronaut.build.MicronautBuildExtension;
import io.micronaut.build.MicronautBuildExtensionPlugin;
import io.micronaut.build.MicronautBuildSettingsExtension;
import io.micronaut.build.MicronautPlugin;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.initialization.resolve.RepositoriesMode;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;

public class MicronautDependencyResolutionConfigurationPlugin
implements MicronautPlugin<Project> {
    public void apply(Project project) {
        this.addMavenCentral(project);
        MicronautDependencyResolutionConfigurationPlugin.configureDependencySubstitutions(project);
        MicronautDependencyResolutionConfigurationPlugin.configureResolutionStrategy(project);
        MicronautDependencyResolutionConfigurationPlugin.configureDependencyCaching(project);
    }

    private static void configureResolutionStrategy(Project project) {
        project.getConfigurations().all(conf -> conf.resolutionStrategy(ResolutionStrategy::preferProjectModules));
    }

    private static void configureDependencyCaching(Project project) {
        project.getPlugins().withType(MicronautBuildExtensionPlugin.class, unused -> {
            MicronautBuildExtension micronautBuildExtension = (MicronautBuildExtension)project.getExtensions().findByType(MicronautBuildExtension.class);
            if (Boolean.TRUE.equals(micronautBuildExtension.getEnvironment().isGithubAction().get())) {
                project.getConfigurations().all(conf -> conf.resolutionStrategy(rs -> {
                    rs.cacheChangingModulesFor(0, TimeUnit.MINUTES);
                    rs.cacheDynamicVersionsFor(0, TimeUnit.MINUTES);
                }));
            }
        });
    }

    private void addMavenCentral(Project project) {
        SettingsInternal settings = ((GradleInternal)project.getGradle()).getSettings();
        RepositoriesMode repositoriesMode = (RepositoriesMode)settings.getDependencyResolutionManagement().getRepositoriesMode().get();
        if (!repositoriesMode.equals((Object)RepositoriesMode.FAIL_ON_PROJECT_REPOS)) {
            project.getRepositories().mavenCentral();
        }
    }

    public static void configureDependencySubstitutions(Project project) {
        project.getGradle().settingsEvaluated(settings -> {
            MicronautBuildSettingsExtension buildSettingsExtension = (MicronautBuildSettingsExtension)settings.getExtensions().getByType(MicronautBuildSettingsExtension.class);
            project.getGradle().projectsEvaluated(unused -> project.getConfigurations().all(conf -> conf.getResolutionStrategy().dependencySubstitution(ds -> project.getRootProject().getAllprojects().forEach(p -> {
                String shortName = p.getName().replaceFirst("micronaut-", "");
                String group = String.valueOf(p.getGroup());
                if (group.startsWith("io.micronaut") && !shortName.startsWith("test-suite")) {
                    ComponentSelector releasedModule = ds.module(group + ":micronaut-" + shortName);
                    String projectPath = ":" + (String)buildSettingsExtension.getUseStandardizedProjectNames().map(s -> s != false ? "micronaut-" : "").get() + shortName;
                    ComponentSelector localVersion = ds.project(projectPath);
                    if (shortName.endsWith("-bom")) {
                        ds.substitute(ds.platform(releasedModule)).using(ds.platform(localVersion)).because("we want to test with what we're building");
                    } else {
                        ds.substitute(releasedModule).using(localVersion).because("we want to test with what we're building");
                    }
                }
            }))));
        });
    }
}

