/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build;

import io.micronaut.build.MicronautBuildExtension;
import io.micronaut.build.MicronautQualityChecksParticipantPlugin;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.testing.jacoco.plugins.JacocoCoverageReport;
import org.gradle.testing.jacoco.plugins.JacocoReportAggregationPlugin;
import org.sonarqube.gradle.SonarExtension;
import org.sonarqube.gradle.SonarQubePlugin;
import org.sonarqube.gradle.SonarTask;

public class MicronautQualityReportingAggregatorPlugin
implements Plugin<Project> {
    public static final String COVERAGE_REPORT_TASK_NAME = "testCodeCoverageReport";

    public void apply(Project rootProject) {
        if (!rootProject.equals(rootProject.getRootProject())) {
            throw new GradleException("The Quality Checks Aggregator plugin must only be applied to the root project");
        }
        this.configureSonar(rootProject);
        this.configureJacoco(rootProject);
    }

    private void configureSonar(Project rootProject) {
        if (System.getenv("SONAR_TOKEN") != null) {
            rootProject.getPluginManager().apply(SonarQubePlugin.class);
            SonarExtension sonarQubeExtension = (SonarExtension)rootProject.getExtensions().findByType(SonarExtension.class);
            if (sonarQubeExtension != null) {
                sonarQubeExtension.properties(p -> {
                    String githubSlug = (String)rootProject.getProviders().gradleProperty("githubSlug").getOrNull();
                    if (githubSlug != null) {
                        p.property("sonar.projectKey", (Object)githubSlug.replaceAll("/", "_"));
                        p.property("sonar.organization", (Object)"micronaut-projects");
                        p.property("sonar.host.url", (Object)"https://sonarcloud.io");
                        MicronautBuildExtension micronautBuildExtension = (MicronautBuildExtension)rootProject.getExtensions().getByType(MicronautBuildExtension.class);
                        p.property("sonar.java.source", micronautBuildExtension.getJavaVersion().map(String::valueOf).get());
                        p.property("sonar.verbose", (Object)"true");
                        String jacocoReportPath = rootProject.getBuildDir().toPath().resolve("reports/jacoco/testCodeCoverageReport/testCodeCoverageReport.xml").toFile().getAbsolutePath();
                        p.property("sonar.coverage.jacoco.xmlReportPaths", (Object)jacocoReportPath);
                    }
                });
                rootProject.getTasks().withType(SonarTask.class).configureEach(t -> t.dependsOn(new Object[]{COVERAGE_REPORT_TASK_NAME}));
            } else {
                rootProject.getLogger().warn("Could not find the sonarqube extension");
            }
        }
    }

    private void configureJacoco(Project rootProject) {
        rootProject.getPluginManager().apply(BasePlugin.class);
        rootProject.getPluginManager().apply(JacocoReportAggregationPlugin.class);
        ReportingExtension reporting = (ReportingExtension)rootProject.getExtensions().getByType(ReportingExtension.class);
        reporting.getReports().create(COVERAGE_REPORT_TASK_NAME, JacocoCoverageReport.class, r -> r.getTestType().set((Object)"unit-test"));
        Configuration jacocoAggregation = rootProject.getConfigurations().getByName("jacocoAggregation");
        rootProject.getSubprojects().forEach(subproject -> {
            rootProject.evaluationDependsOn(subproject.getPath());
            subproject.getPlugins().withType(MicronautQualityChecksParticipantPlugin.class, plugin -> jacocoAggregation.getDependencies().add((Object)rootProject.getDependencies().create(subproject)));
        });
    }
}

