/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.catalogs.internal;

import io.micronaut.build.catalogs.internal.Library;
import io.micronaut.build.catalogs.internal.Plugin;
import io.micronaut.build.catalogs.internal.RichVersion;
import io.micronaut.build.catalogs.internal.RichVersionParser;
import io.micronaut.build.catalogs.internal.VersionCatalogTomlModel;
import io.micronaut.build.catalogs.internal.VersionModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlInvalidTypeException;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlPosition;
import org.tomlj.TomlTable;

public class LenientVersionCatalogParser {
    private static final String LIBRARIES_KEY = "libraries";
    private static final String PLUGINS_KEY = "plugins";
    private static final String VERSIONS_KEY = "versions";
    private final VersionCatalogTomlModel model = new VersionCatalogTomlModel();

    public static List<String> splitToList(String coordinates) {
        ArrayList<String> result = new ArrayList<String>(3);
        String[] split = coordinates.split(":");
        int splitLength = split.length;
        for (int i = 0; i < splitLength; ++i) {
            String part = split[i];
            if (i >= splitLength - 1 && part.isEmpty()) continue;
            result.add(part);
        }
        return result;
    }

    public void parse(InputStream in) throws IOException {
        RichVersionParser strictVersionParser = new RichVersionParser();
        TomlParseResult result = Toml.parse((InputStream)in);
        TomlTable librariesTable = result.getTable(LIBRARIES_KEY);
        TomlTable pluginsTable = result.getTable(PLUGINS_KEY);
        TomlTable versionsTable = result.getTable(VERSIONS_KEY);
        this.parseLibraries(librariesTable, strictVersionParser);
        this.parsePlugins(pluginsTable, strictVersionParser);
        this.parseVersions(versionsTable, strictVersionParser);
    }

    public VersionCatalogTomlModel getModel() {
        return this.model;
    }

    private void parseLibraries(@Nullable TomlTable librariesTable, RichVersionParser strictVersionParser) {
        if (librariesTable == null) {
            return;
        }
        List keys = librariesTable.keySet().stream().sorted(Comparator.comparing(String::length)).collect(Collectors.toList());
        for (String alias : keys) {
            this.parseLibrary(alias, librariesTable, strictVersionParser);
        }
    }

    private void parsePlugins(@Nullable TomlTable pluginsTable, RichVersionParser strictVersionParser) {
        if (pluginsTable == null) {
            return;
        }
        List<String> keys = pluginsTable.keySet().stream().sorted(Comparator.comparing(String::length)).toList();
        for (String alias : keys) {
            this.parsePlugin(alias, pluginsTable, strictVersionParser);
        }
    }

    private void parseVersions(@Nullable TomlTable versionsTable, RichVersionParser strictVersionParser) {
        if (versionsTable == null) {
            return;
        }
        List keys = versionsTable.keySet().stream().sorted(Comparator.comparing(String::length)).collect(Collectors.toList());
        for (String alias : keys) {
            this.parseVersion(alias, versionsTable, strictVersionParser);
        }
    }

    @Nullable
    private static String expectString(String name, TomlTable table, @Nullable String element) {
        Object path = name;
        if (element != null) {
            path = (String)path + "." + element;
        }
        return table.getString((String)path);
    }

    @Nullable
    private static TomlArray expectArray(TomlTable table, String element) {
        try {
            return table.getArray(element);
        }
        catch (TomlInvalidTypeException ex) {
            return null;
        }
    }

    @Nullable
    private static Boolean expectBoolean(TomlTable table, String element) {
        return table.getBoolean(element);
    }

    private void parseLibrary(String alias, TomlTable librariesTable, RichVersionParser strictVersionParser) {
        List<String> splitted;
        List<String> splitted2;
        Object gav = librariesTable.get(alias);
        TomlPosition position = librariesTable.inputPositionOf(alias);
        if (gav instanceof String && (splitted2 = LenientVersionCatalogParser.splitToList((String)gav)).size() == 3) {
            String group = splitted2.get(0);
            String name = splitted2.get(1);
            String version = splitted2.get(2);
            RichVersion rich = strictVersionParser.parse(version);
            VersionModel versionModel = new VersionModel(null, rich, position);
            this.model.addLibrary(new Library(alias, group, name, versionModel, position));
            return;
        }
        String group = LenientVersionCatalogParser.expectString(alias, librariesTable, "group");
        String name = LenientVersionCatalogParser.expectString(alias, librariesTable, "name");
        Object version = librariesTable.get(alias + ".version");
        String mi = LenientVersionCatalogParser.expectString(alias, librariesTable, "module");
        if (mi != null && (splitted = LenientVersionCatalogParser.splitToList(mi)).size() == 2) {
            group = splitted.get(0);
            name = splitted.get(1);
        }
        VersionModel versionModel = null;
        if (version instanceof String) {
            String require = (String)version;
            RichVersion richVersion = strictVersionParser.parse(require);
            versionModel = new VersionModel(null, richVersion, position);
        } else if (version instanceof TomlTable) {
            TomlTable versionTable = (TomlTable)version;
            String versionRef = versionTable.getString("ref");
            String require = versionTable.getString("require");
            String prefer = versionTable.getString("prefer");
            String strictly = versionTable.getString("strictly");
            TomlArray rejectedArray = LenientVersionCatalogParser.expectArray(versionTable, "reject");
            List<String> rejectedVersions = rejectedArray != null ? rejectedArray.toList().stream().map(String::valueOf).collect(Collectors.toList()) : null;
            Boolean rejectAll = LenientVersionCatalogParser.expectBoolean(versionTable, "rejectAll");
            versionModel = new VersionModel(versionRef, versionRef == null ? new RichVersion(require, strictly, prefer, rejectedVersions, rejectAll != null ? rejectAll : false) : null, position);
        }
        if (versionModel != null) {
            this.model.addLibrary(new Library(alias, group, name, versionModel, position));
        }
    }

    private void parsePlugin(String alias, TomlTable pluginsTable, RichVersionParser strictVersionParser) {
        TomlPosition position = pluginsTable.inputPositionOf(alias);
        String id = LenientVersionCatalogParser.expectString(alias, pluginsTable, "id");
        Object version = pluginsTable.get(alias + ".version");
        VersionModel versionModel = null;
        if (version instanceof String) {
            String require = (String)version;
            RichVersion richVersion = strictVersionParser.parse(require);
            versionModel = new VersionModel(null, richVersion, position);
        } else if (version instanceof TomlTable) {
            TomlTable versionTable = (TomlTable)version;
            String versionRef = versionTable.getString("ref");
            versionModel = new VersionModel(versionRef, null, position);
        }
        if (versionModel != null) {
            this.model.addPlugin(new Plugin(alias, id, versionModel, position));
        }
    }

    private void parseVersion(String alias, TomlTable versionsTable, RichVersionParser strictVersionParser) {
        String require = null;
        String strictly = null;
        String prefer = null;
        List<String> rejectedVersions = null;
        Boolean rejectAll = null;
        Object version = versionsTable.get(alias);
        TomlPosition position = versionsTable.inputPositionOf(alias);
        if (version instanceof String) {
            require = (String)version;
            RichVersion richVersion = strictVersionParser.parse(require);
            this.model.addVersion(new VersionModel(alias, richVersion, position));
        } else if (version instanceof TomlTable) {
            TomlTable versionTable = (TomlTable)version;
            require = versionTable.getString("require");
            prefer = versionTable.getString("prefer");
            strictly = versionTable.getString("strictly");
            TomlArray rejectedArray = LenientVersionCatalogParser.expectArray(versionTable, "reject");
            rejectedVersions = rejectedArray != null ? rejectedArray.toList().stream().map(String::valueOf).collect(Collectors.toList()) : null;
            rejectAll = LenientVersionCatalogParser.expectBoolean(versionTable, "rejectAll");
            this.model.addVersion(new VersionModel(alias, new RichVersion(require, strictly, prefer, rejectedVersions, rejectAll != null ? rejectAll : false), position));
        }
    }
}

