/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.build.compat;

import io.micronaut.build.compat.AcceptanceHelper;
import io.micronaut.build.compat.AcceptedApiChange;
import io.micronaut.build.compat.AcceptedApiChangesParser;
import japicmp.model.JApiCompatibility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.champeau.gradle.japicmp.report.Violation;
import me.champeau.gradle.japicmp.report.ViolationTransformer;
import org.gradle.api.GradleException;

public class AcceptedApiChangesRule
implements ViolationTransformer {
    public static final String CHANGES_FILE = "changesFile";
    private final Map<String, List<AcceptedApiChange>> changes;

    public AcceptedApiChangesRule(Map<String, String> params) {
        block8: {
            String filePath = params.get(CHANGES_FILE);
            File changesFile = new File(filePath);
            if (changesFile.exists()) {
                try (FileInputStream fis = new FileInputStream(filePath);){
                    this.changes = AcceptedApiChangesParser.parse(fis).stream().collect(Collectors.groupingBy(AcceptedApiChange::getType));
                    break block8;
                }
                catch (IOException e) {
                    throw new GradleException("Unable to parse accepted regressions file", (Throwable)e);
                }
            }
            this.changes = Collections.emptyMap();
        }
    }

    public Optional<Violation> transform(String type, Violation violation) {
        Optional<AcceptedApiChange> any;
        List<AcceptedApiChange> apiChanges = this.changes.get(type);
        String violationDescription = Violation.describe((JApiCompatibility)violation.getMember());
        if (apiChanges != null && (any = apiChanges.stream().filter(c -> c.matches(type, violationDescription)).findAny()).isPresent()) {
            return Optional.of(violation.acceptWithDescription(any.get().getReason()));
        }
        switch (violation.getSeverity()) {
            case info: 
            case accepted: 
            case warning: {
                return Optional.of(violation);
            }
        }
        return Optional.of(violation.withDescription(violation.getHumanExplanation() + AcceptanceHelper.formatAcceptance(type, violationDescription)));
    }
}

